/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.datatype.encoder;

import com.iab.gpp.encoder.datatype.encoder.FibonacciIntegerRangeEncoder;
import com.iab.gpp.encoder.datatype.encoder.FixedBitfieldEncoder;
import com.iab.gpp.encoder.datatype.encoder.FixedIntegerEncoder;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.EncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class OptimizedFibonacciRangeEncoder {
    private static Pattern BITSTRING_VERIFICATION_PATTERN = Pattern.compile("^[0-1]*$", 2);

    public static String encode(List<Integer> value) throws EncodingException {
        int bitFieldLength;
        int max = value.size() > 0 ? value.get(value.size() - 1) : 0;
        String rangeBitString = FibonacciIntegerRangeEncoder.encode(value);
        int rangeLength = rangeBitString.length();
        if (rangeLength <= (bitFieldLength = max)) {
            return FixedIntegerEncoder.encode(max, 16) + "1" + rangeBitString;
        }
        ArrayList<Boolean> bits = new ArrayList<Boolean>();
        int index = 0;
        for (int i = 0; i < max; ++i) {
            if (i == value.get(index) - 1) {
                bits.add(true);
                ++index;
                continue;
            }
            bits.add(false);
        }
        return FixedIntegerEncoder.encode(max, 16) + "0" + FixedBitfieldEncoder.encode(bits, bitFieldLength);
    }

    public static List<Integer> decode(String bitString) throws DecodingException {
        if (!BITSTRING_VERIFICATION_PATTERN.matcher(bitString).matches() || bitString.length() < 12) {
            throw new DecodingException("Undecodable FibonacciIntegerRange '" + bitString + "'");
        }
        if (bitString.charAt(16) == '1') {
            return FibonacciIntegerRangeEncoder.decode(bitString.substring(17));
        }
        ArrayList<Integer> value = new ArrayList<Integer>();
        List<Boolean> bits = FixedBitfieldEncoder.decode(bitString.substring(17));
        for (int i = 0; i < bits.size(); ++i) {
            if (!bits.get(i).booleanValue()) continue;
            value.add(i + 1);
        }
        return value;
    }
}

