/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.section;

import com.iab.gpp.encoder.error.InvalidFieldException;
import com.iab.gpp.encoder.section.EncodableSection;
import com.iab.gpp.encoder.segment.EncodableSegment;
import java.util.List;

public abstract class AbstractLazilyEncodableSection
implements EncodableSection {
    private List<EncodableSegment> segments = this.initializeSegments();
    private String encodedString = null;
    private boolean dirty = false;
    private boolean decoded = true;

    protected abstract List<EncodableSegment> initializeSegments();

    protected abstract String encodeSection(List<EncodableSegment> var1);

    protected abstract List<EncodableSegment> decodeSection(String var1);

    @Override
    public boolean hasField(String fieldName) {
        if (!this.decoded) {
            this.segments = this.decodeSection(this.encodedString);
            this.dirty = false;
            this.decoded = true;
        }
        for (EncodableSegment segment : this.segments) {
            if (!segment.getFieldNames().contains(fieldName)) continue;
            return segment.hasField(fieldName);
        }
        return false;
    }

    @Override
    public Object getFieldValue(String fieldName) {
        if (!this.decoded) {
            this.segments = this.decodeSection(this.encodedString);
            this.dirty = false;
            this.decoded = true;
        }
        for (EncodableSegment segment : this.segments) {
            if (!segment.hasField(fieldName)) continue;
            return segment.getFieldValue(fieldName);
        }
        throw new InvalidFieldException("Invalid field: '" + fieldName + "'");
    }

    @Override
    public void setFieldValue(String fieldName, Object value) {
        if (!this.decoded) {
            this.segments = this.decodeSection(this.encodedString);
            this.dirty = false;
            this.decoded = true;
        }
        for (EncodableSegment segment : this.segments) {
            if (!segment.hasField(fieldName)) continue;
            segment.setFieldValue(fieldName, value);
            this.dirty = true;
            return;
        }
        throw new InvalidFieldException("Invalid field: '" + fieldName + "'");
    }

    @Override
    public String encode() {
        if (this.encodedString == null || this.encodedString.isEmpty() || this.dirty) {
            this.encodedString = this.encodeSection(this.segments);
            this.dirty = false;
            this.decoded = true;
        }
        return this.encodedString;
    }

    @Override
    public void decode(String encodedString) {
        this.encodedString = encodedString;
        this.dirty = false;
        this.decoded = false;
    }
}

