/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.section;

import com.iab.gpp.encoder.datatype.RangeEntry;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.InvalidFieldException;
import com.iab.gpp.encoder.field.TcfCaV1Field;
import com.iab.gpp.encoder.section.AbstractLazilyEncodableSection;
import com.iab.gpp.encoder.segment.EncodableSegment;
import com.iab.gpp.encoder.segment.TcfCaV1CoreSegment;
import com.iab.gpp.encoder.segment.TcfCaV1DisclosedVendorsSegment;
import com.iab.gpp.encoder.segment.TcfCaV1PublisherPurposesSegment;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;

public class TcfCaV1
extends AbstractLazilyEncodableSection {
    public static int ID = 5;
    public static int VERSION = 1;
    public static String NAME = "tcfcav1";

    public TcfCaV1() {
    }

    public TcfCaV1(String encodedString) {
        this.decode(encodedString);
    }

    @Override
    public int getId() {
        return ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getVersion() {
        return VERSION;
    }

    @Override
    protected List<EncodableSegment> initializeSegments() {
        ArrayList<EncodableSegment> segments = new ArrayList<EncodableSegment>();
        segments.add(new TcfCaV1CoreSegment());
        segments.add(new TcfCaV1PublisherPurposesSegment());
        segments.add(new TcfCaV1DisclosedVendorsSegment());
        return segments;
    }

    @Override
    public List<EncodableSegment> decodeSection(String encodedString) {
        List<EncodableSegment> segments = this.initializeSegments();
        if (encodedString != null && !encodedString.isEmpty()) {
            String[] encodedSegments = encodedString.split("\\.");
            for (int i = 0; i < encodedSegments.length; ++i) {
                String encodedSegment = encodedSegments[i];
                if (encodedSegment.isEmpty()) continue;
                char firstChar = encodedSegment.charAt(0);
                if (firstChar >= 'A' && firstChar <= 'H') {
                    segments.get(0).decode(encodedSegments[i]);
                    continue;
                }
                if (firstChar >= 'I' && firstChar <= 'P') {
                    segments.get(2).decode(encodedSegments[i]);
                    continue;
                }
                if (firstChar >= 'Y' && firstChar <= 'Z' || firstChar >= 'a' && firstChar <= 'f') {
                    segments.get(1).decode(encodedSegments[i]);
                    continue;
                }
                throw new DecodingException("Invalid segment '" + encodedSegment + "'");
            }
        }
        return segments;
    }

    @Override
    public String encodeSection(List<EncodableSegment> segments) {
        ArrayList<String> encodedSegments = new ArrayList<String>();
        encodedSegments.add(segments.get(0).encode());
        encodedSegments.add(segments.get(1).encode());
        if (!this.getDisclosedVendors().isEmpty()) {
            encodedSegments.add(segments.get(2).encode());
        }
        return String.join((CharSequence)".", encodedSegments);
    }

    @Override
    public void setFieldValue(String fieldName, Object value) throws InvalidFieldException {
        super.setFieldValue(fieldName, value);
        if (!fieldName.equals(TcfCaV1Field.CREATED) && !fieldName.equals(TcfCaV1Field.LAST_UPDATED)) {
            ZonedDateTime utcDateTime = ZonedDateTime.now(ZoneId.of("UTC"));
            super.setFieldValue(TcfCaV1Field.CREATED, utcDateTime);
            super.setFieldValue(TcfCaV1Field.LAST_UPDATED, utcDateTime);
        }
    }

    public ZonedDateTime getCreated() {
        return (ZonedDateTime)this.getFieldValue(TcfCaV1Field.CREATED);
    }

    public ZonedDateTime getLastUpdated() {
        return (ZonedDateTime)this.getFieldValue(TcfCaV1Field.LAST_UPDATED);
    }

    public Integer getCmpId() {
        return (Integer)this.getFieldValue(TcfCaV1Field.CMP_ID);
    }

    public Integer getCmpVersion() {
        return (Integer)this.getFieldValue(TcfCaV1Field.CMP_VERSION);
    }

    public Integer getConsentScreen() {
        return (Integer)this.getFieldValue(TcfCaV1Field.CONSENT_SCREEN);
    }

    public String getConsentLanguage() {
        return (String)this.getFieldValue(TcfCaV1Field.CONSENT_LANGUAGE);
    }

    public Integer getVendorListVersion() {
        return (Integer)this.getFieldValue(TcfCaV1Field.VENDOR_LIST_VERSION);
    }

    public Integer getPolicyVersion() {
        return (Integer)this.getFieldValue(TcfCaV1Field.TCF_POLICY_VERSION);
    }

    public Boolean getUseNonStandardStacks() {
        return (Boolean)this.getFieldValue(TcfCaV1Field.USE_NON_STANDARD_STACKS);
    }

    public List<Boolean> getSpecialFeatureExpressConsent() {
        return (List)this.getFieldValue(TcfCaV1Field.SPECIAL_FEATURE_EXPRESS_CONSENT);
    }

    public List<Boolean> getPurposesExpressConsent() {
        return (List)this.getFieldValue(TcfCaV1Field.PURPOSES_EXPRESS_CONSENT);
    }

    public List<Boolean> getPurposesImpliedConsent() {
        return (List)this.getFieldValue(TcfCaV1Field.PURPOSES_IMPLIED_CONSENT);
    }

    public List<Integer> getVendorExpressConsent() {
        return (List)this.getFieldValue(TcfCaV1Field.VENDOR_EXPRESS_CONSENT);
    }

    public List<Integer> getVendorImpliedConsent() {
        return (List)this.getFieldValue(TcfCaV1Field.VENDOR_IMPLIED_CONSENT);
    }

    public List<RangeEntry> getPubRestrictions() {
        return (List)this.getFieldValue(TcfCaV1Field.PUB_RESTRICTIONS);
    }

    public Integer getPubPurposesSegmentType() {
        return (Integer)this.getFieldValue(TcfCaV1Field.PUB_PURPOSES_SEGMENT_TYPE);
    }

    public List<Boolean> getPubPurposesExpressConsent() {
        return (List)this.getFieldValue(TcfCaV1Field.PUB_PURPOSES_EXPRESS_CONSENT);
    }

    public List<Boolean> getPubPurposesImpliedConsent() {
        return (List)this.getFieldValue(TcfCaV1Field.PUB_PURPOSES_IMPLIED_CONSENT);
    }

    public Integer getNumCustomPurposes() {
        return (Integer)this.getFieldValue(TcfCaV1Field.NUM_CUSTOM_PURPOSES);
    }

    public List<Integer> getCustomPurposesExpressConsent() {
        return (List)this.getFieldValue(TcfCaV1Field.CUSTOM_PURPOSES_EXPRESS_CONSENT);
    }

    public List<Integer> getCustomPurposesImpliedConsent() {
        return (List)this.getFieldValue(TcfCaV1Field.CUSTOM_PURPOSES_IMPLIED_CONSENT);
    }

    public Integer getDisclosedVendorsSegmentType() {
        return (Integer)this.getFieldValue(TcfCaV1Field.DISCLOSED_VENDORS_SEGMENT_TYPE);
    }

    public List<Integer> getDisclosedVendors() {
        return (List)this.getFieldValue(TcfCaV1Field.DISCLOSED_VENDORS);
    }
}

