/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.section;

import com.iab.gpp.encoder.datatype.RangeEntry;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.InvalidFieldException;
import com.iab.gpp.encoder.field.TcfEuV2Field;
import com.iab.gpp.encoder.section.AbstractLazilyEncodableSection;
import com.iab.gpp.encoder.segment.EncodableSegment;
import com.iab.gpp.encoder.segment.TcfEuV2CoreSegment;
import com.iab.gpp.encoder.segment.TcfEuV2PublisherPurposesSegment;
import com.iab.gpp.encoder.segment.TcfEuV2VendorsAllowedSegment;
import com.iab.gpp.encoder.segment.TcfEuV2VendorsDisclosedSegment;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;

public class TcfEuV2
extends AbstractLazilyEncodableSection {
    public static int ID = 2;
    public static int VERSION = 2;
    public static String NAME = "tcfeuv2";

    public TcfEuV2() {
    }

    public TcfEuV2(String encodedString) {
        this.decode(encodedString);
    }

    @Override
    public int getId() {
        return ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getVersion() {
        return VERSION;
    }

    @Override
    protected List<EncodableSegment> initializeSegments() {
        ArrayList<EncodableSegment> segments = new ArrayList<EncodableSegment>();
        segments.add(new TcfEuV2CoreSegment());
        segments.add(new TcfEuV2PublisherPurposesSegment());
        segments.add(new TcfEuV2VendorsAllowedSegment());
        segments.add(new TcfEuV2VendorsDisclosedSegment());
        return segments;
    }

    @Override
    public List<EncodableSegment> decodeSection(String encodedString) {
        List<EncodableSegment> segments = this.initializeSegments();
        if (encodedString != null && !encodedString.isEmpty()) {
            String[] encodedSegments = encodedString.split("\\.");
            for (int i = 0; i < encodedSegments.length; ++i) {
                String encodedSegment = encodedSegments[i];
                if (encodedSegment.isEmpty()) continue;
                char firstChar = encodedSegment.charAt(0);
                if (firstChar >= 'A' && firstChar <= 'H') {
                    segments.get(0).decode(encodedSegments[i]);
                    continue;
                }
                if (firstChar >= 'I' && firstChar <= 'P') {
                    segments.get(3).decode(encodedSegments[i]);
                    continue;
                }
                if (firstChar >= 'Q' && firstChar <= 'X') {
                    segments.get(2).decode(encodedSegments[i]);
                    continue;
                }
                if (firstChar >= 'Y' && firstChar <= 'Z' || firstChar >= 'a' && firstChar <= 'f') {
                    segments.get(1).decode(encodedSegments[i]);
                    continue;
                }
                throw new DecodingException("Invalid segment '" + encodedSegment + "'");
            }
        }
        return segments;
    }

    @Override
    public String encodeSection(List<EncodableSegment> segments) {
        ArrayList<String> encodedSegments = new ArrayList<String>();
        if (segments.size() >= 1) {
            encodedSegments.add(segments.get(0).encode());
            Boolean isServiceSpecific = (Boolean)this.getFieldValue(TcfEuV2Field.IS_SERVICE_SPECIFIC);
            if (isServiceSpecific.booleanValue()) {
                if (segments.size() >= 2) {
                    encodedSegments.add(segments.get(1).encode());
                }
            } else if (segments.size() >= 2) {
                encodedSegments.add(segments.get(2).encode());
                if (segments.size() >= 3) {
                    encodedSegments.add(segments.get(3).encode());
                }
            }
        }
        return String.join((CharSequence)".", encodedSegments);
    }

    @Override
    public void setFieldValue(String fieldName, Object value) throws InvalidFieldException {
        super.setFieldValue(fieldName, value);
        if (!fieldName.equals(TcfEuV2Field.CREATED) && !fieldName.equals(TcfEuV2Field.LAST_UPDATED)) {
            ZonedDateTime utcDateTime = ZonedDateTime.now(ZoneId.of("UTC"));
            super.setFieldValue(TcfEuV2Field.CREATED, utcDateTime);
            super.setFieldValue(TcfEuV2Field.LAST_UPDATED, utcDateTime);
        }
    }

    public ZonedDateTime getCreated() {
        return (ZonedDateTime)this.getFieldValue(TcfEuV2Field.CREATED);
    }

    public ZonedDateTime getLastUpdated() {
        return (ZonedDateTime)this.getFieldValue(TcfEuV2Field.LAST_UPDATED);
    }

    public Integer getCmpId() {
        return (Integer)this.getFieldValue(TcfEuV2Field.CMP_ID);
    }

    public Integer getCmpVersion() {
        return (Integer)this.getFieldValue(TcfEuV2Field.CMP_VERSION);
    }

    public Integer getConsentScreen() {
        return (Integer)this.getFieldValue(TcfEuV2Field.CONSENT_SCREEN);
    }

    public String getConsentLanguage() {
        return (String)this.getFieldValue(TcfEuV2Field.CONSENT_LANGUAGE);
    }

    public Integer getVendorListVersion() {
        return (Integer)this.getFieldValue(TcfEuV2Field.VENDOR_LIST_VERSION);
    }

    public Integer getPolicyVersion() {
        return (Integer)this.getFieldValue(TcfEuV2Field.POLICY_VERSION);
    }

    public Boolean getIsServiceSpecific() {
        return (Boolean)this.getFieldValue(TcfEuV2Field.IS_SERVICE_SPECIFIC);
    }

    public Boolean getUseNonStandardStacks() {
        return (Boolean)this.getFieldValue(TcfEuV2Field.USE_NON_STANDARD_STACKS);
    }

    public List<Boolean> getSpecialFeatureOptins() {
        return (List)this.getFieldValue(TcfEuV2Field.SPECIAL_FEATURE_OPTINS);
    }

    public List<Boolean> getPurposeConsents() {
        return (List)this.getFieldValue(TcfEuV2Field.PURPOSE_CONSENTS);
    }

    public List<Boolean> getPurposeLegitimateInterests() {
        return (List)this.getFieldValue(TcfEuV2Field.PURPOSE_LEGITIMATE_INTERESTS);
    }

    public Boolean getPurposeOneTreatment() {
        return (Boolean)this.getFieldValue(TcfEuV2Field.PURPOSE_ONE_TREATMENT);
    }

    public String getPublisherCountryCode() {
        return (String)this.getFieldValue(TcfEuV2Field.PUBLISHER_COUNTRY_CODE);
    }

    public List<Integer> getVendorConsents() {
        return (List)this.getFieldValue(TcfEuV2Field.VENDOR_CONSENTS);
    }

    public List<Integer> getVendorLegitimateInterests() {
        return (List)this.getFieldValue(TcfEuV2Field.VENDOR_LEGITIMATE_INTERESTS);
    }

    public List<RangeEntry> getPublisherRestrictions() {
        return (List)this.getFieldValue(TcfEuV2Field.PUBLISHER_RESTRICTIONS);
    }

    public Integer getPublisherPurposesSegmentType() {
        return (Integer)this.getFieldValue(TcfEuV2Field.PUBLISHER_PURPOSES_SEGMENT_TYPE);
    }

    public List<Boolean> getPublisherConsents() {
        return (List)this.getFieldValue(TcfEuV2Field.PUBLISHER_CONSENTS);
    }

    public List<Boolean> getPublisherLegitimateInterests() {
        return (List)this.getFieldValue(TcfEuV2Field.PUBLISHER_LEGITIMATE_INTERESTS);
    }

    public Integer getNumCustomPurposes() {
        return (Integer)this.getFieldValue(TcfEuV2Field.NUM_CUSTOM_PURPOSES);
    }

    public List<Integer> getPublisherCustomConsents() {
        return (List)this.getFieldValue(TcfEuV2Field.PUBLISHER_CUSTOM_CONSENTS);
    }

    public List<Integer> getPublisherCustomLegitimateInterests() {
        return (List)this.getFieldValue(TcfEuV2Field.PUBLISHER_CUSTOM_LEGITIMATE_INTERESTS);
    }

    public Integer getVendorsAllowedSegmentType() {
        return (Integer)this.getFieldValue(TcfEuV2Field.VENDORS_ALLOWED_SEGMENT_TYPE);
    }

    public List<Integer> getVendorsAllowed() {
        return (List)this.getFieldValue(TcfEuV2Field.VENDORS_ALLOWED);
    }

    public Integer getVendorsDisclosedSegmentType() {
        return (Integer)this.getFieldValue(TcfEuV2Field.VENDORS_DISCLOSED_SEGMENT_TYPE);
    }

    public List<Integer> getVendorsDisclosed() {
        return (List)this.getFieldValue(TcfEuV2Field.VENDORS_DISCLOSED);
    }
}

