/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.segment;

import com.iab.gpp.encoder.base64.AbstractBase64UrlEncoder;
import com.iab.gpp.encoder.base64.TraditionalBase64UrlEncoder;
import com.iab.gpp.encoder.bitstring.BitStringEncoder;
import com.iab.gpp.encoder.datatype.EncodableArrayOfFixedIntegerRanges;
import com.iab.gpp.encoder.datatype.EncodableBoolean;
import com.iab.gpp.encoder.datatype.EncodableDatetime;
import com.iab.gpp.encoder.datatype.EncodableFixedBitfield;
import com.iab.gpp.encoder.datatype.EncodableFixedInteger;
import com.iab.gpp.encoder.datatype.EncodableFixedString;
import com.iab.gpp.encoder.datatype.EncodableOptimizedFixedRange;
import com.iab.gpp.encoder.datatype.RangeEntry;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.field.EncodableBitStringFields;
import com.iab.gpp.encoder.field.TcfEuV2Field;
import com.iab.gpp.encoder.section.TcfEuV2;
import com.iab.gpp.encoder.segment.AbstractLazilyEncodableSegment;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TcfEuV2CoreSegment
extends AbstractLazilyEncodableSegment<EncodableBitStringFields> {
    private AbstractBase64UrlEncoder base64UrlEncoder = TraditionalBase64UrlEncoder.getInstance();
    private BitStringEncoder bitStringEncoder = BitStringEncoder.getInstance();

    public TcfEuV2CoreSegment() {
    }

    public TcfEuV2CoreSegment(String encodedString) {
        this.decode(encodedString);
    }

    @Override
    public List<String> getFieldNames() {
        return TcfEuV2Field.TCFEUV2_CORE_SEGMENT_FIELD_NAMES;
    }

    @Override
    protected EncodableBitStringFields initializeFields() {
        ZonedDateTime date = ZonedDateTime.now();
        EncodableBitStringFields fields = new EncodableBitStringFields();
        fields.put(TcfEuV2Field.VERSION, new EncodableFixedInteger(6, TcfEuV2.VERSION));
        fields.put(TcfEuV2Field.CREATED, new EncodableDatetime(date));
        fields.put(TcfEuV2Field.LAST_UPDATED, new EncodableDatetime(date));
        fields.put(TcfEuV2Field.CMP_ID, new EncodableFixedInteger(12, 0));
        fields.put(TcfEuV2Field.CMP_VERSION, new EncodableFixedInteger(12, 0));
        fields.put(TcfEuV2Field.CONSENT_SCREEN, new EncodableFixedInteger(6, 0));
        fields.put(TcfEuV2Field.CONSENT_LANGUAGE, new EncodableFixedString(2, "EN"));
        fields.put(TcfEuV2Field.VENDOR_LIST_VERSION, new EncodableFixedInteger(12, 0));
        fields.put(TcfEuV2Field.POLICY_VERSION, new EncodableFixedInteger(6, 2));
        fields.put(TcfEuV2Field.IS_SERVICE_SPECIFIC, new EncodableBoolean((Boolean)false));
        fields.put(TcfEuV2Field.USE_NON_STANDARD_STACKS, new EncodableBoolean((Boolean)false));
        fields.put(TcfEuV2Field.SPECIAL_FEATURE_OPTINS, new EncodableFixedBitfield(Arrays.asList(false, false, false, false, false, false, false, false, false, false, false, false)));
        fields.put(TcfEuV2Field.PURPOSE_CONSENTS, new EncodableFixedBitfield(Arrays.asList(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false)));
        fields.put(TcfEuV2Field.PURPOSE_LEGITIMATE_INTERESTS, new EncodableFixedBitfield(Arrays.asList(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false)));
        fields.put(TcfEuV2Field.PURPOSE_ONE_TREATMENT, new EncodableBoolean((Boolean)false));
        fields.put(TcfEuV2Field.PUBLISHER_COUNTRY_CODE, new EncodableFixedString(2, "AA"));
        fields.put(TcfEuV2Field.VENDOR_CONSENTS, new EncodableOptimizedFixedRange(new ArrayList<Integer>()));
        fields.put(TcfEuV2Field.VENDOR_LEGITIMATE_INTERESTS, new EncodableOptimizedFixedRange(new ArrayList<Integer>()));
        fields.put(TcfEuV2Field.PUBLISHER_RESTRICTIONS, new EncodableArrayOfFixedIntegerRanges(6, 2, new ArrayList<RangeEntry>(), false));
        return fields;
    }

    @Override
    protected String encodeSegment(EncodableBitStringFields fields) {
        String bitString = this.bitStringEncoder.encode(fields, this.getFieldNames());
        String encodedString = this.base64UrlEncoder.encode(bitString);
        return encodedString;
    }

    @Override
    protected void decodeSegment(String encodedString, EncodableBitStringFields fields) {
        if (encodedString == null || encodedString.isEmpty()) {
            ((EncodableBitStringFields)this.fields).reset(fields);
        }
        try {
            String bitString = this.base64UrlEncoder.decode(encodedString);
            this.bitStringEncoder.decode(bitString, this.getFieldNames(), fields);
        }
        catch (Exception e) {
            throw new DecodingException("Unable to decode TcfEuV2CoreSegment '" + encodedString + "'", e);
        }
    }
}

