/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.segment;

import com.iab.gpp.encoder.base64.AbstractBase64UrlEncoder;
import com.iab.gpp.encoder.base64.TraditionalBase64UrlEncoder;
import com.iab.gpp.encoder.bitstring.BitStringEncoder;
import com.iab.gpp.encoder.datatype.EncodableFixedBitfield;
import com.iab.gpp.encoder.datatype.EncodableFixedInteger;
import com.iab.gpp.encoder.datatype.EncodableFlexibleBitfield;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.field.EncodableBitStringFields;
import com.iab.gpp.encoder.field.TcfEuV2Field;
import com.iab.gpp.encoder.segment.AbstractLazilyEncodableSegment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntSupplier;

public class TcfEuV2PublisherPurposesSegment
extends AbstractLazilyEncodableSegment<EncodableBitStringFields> {
    private AbstractBase64UrlEncoder base64UrlEncoder = TraditionalBase64UrlEncoder.getInstance();
    private BitStringEncoder bitStringEncoder = BitStringEncoder.getInstance();

    public TcfEuV2PublisherPurposesSegment() {
    }

    public TcfEuV2PublisherPurposesSegment(String encodedString) {
        this.decode(encodedString);
    }

    @Override
    public List<String> getFieldNames() {
        return TcfEuV2Field.TCFEUV2_PUBLISHER_PURPOSES_SEGMENT_FIELD_NAMES;
    }

    @Override
    protected EncodableBitStringFields initializeFields() {
        EncodableBitStringFields fields = new EncodableBitStringFields();
        fields.put(TcfEuV2Field.PUBLISHER_PURPOSES_SEGMENT_TYPE, new EncodableFixedInteger(3, 3));
        fields.put(TcfEuV2Field.PUBLISHER_CONSENTS, new EncodableFixedBitfield(Arrays.asList(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false)));
        fields.put(TcfEuV2Field.PUBLISHER_LEGITIMATE_INTERESTS, new EncodableFixedBitfield(Arrays.asList(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false)));
        final EncodableFixedInteger numCustomPurposes = new EncodableFixedInteger(6, 0);
        fields.put(TcfEuV2Field.NUM_CUSTOM_PURPOSES, numCustomPurposes);
        IntSupplier getLengthSupplier = new IntSupplier(){

            @Override
            public int getAsInt() {
                return (Integer)numCustomPurposes.getValue();
            }
        };
        fields.put(TcfEuV2Field.PUBLISHER_CUSTOM_CONSENTS, new EncodableFlexibleBitfield(getLengthSupplier, new ArrayList<Boolean>()));
        fields.put(TcfEuV2Field.PUBLISHER_CUSTOM_LEGITIMATE_INTERESTS, new EncodableFlexibleBitfield(getLengthSupplier, new ArrayList<Boolean>()));
        return fields;
    }

    @Override
    protected String encodeSegment(EncodableBitStringFields fields) {
        String bitString = this.bitStringEncoder.encode(fields, this.getFieldNames());
        String encodedString = this.base64UrlEncoder.encode(bitString);
        return encodedString;
    }

    @Override
    protected void decodeSegment(String encodedString, EncodableBitStringFields fields) {
        if (encodedString == null || encodedString.isEmpty()) {
            ((EncodableBitStringFields)this.fields).reset(fields);
        }
        try {
            String bitString = this.base64UrlEncoder.decode(encodedString);
            this.bitStringEncoder.decode(bitString, this.getFieldNames(), fields);
        }
        catch (Exception e) {
            throw new DecodingException("Unable to decode TcfEuV2PublisherPurposesSegment '" + encodedString + "'", e);
        }
    }
}

