/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.segment;

import com.iab.gpp.encoder.base64.AbstractBase64UrlEncoder;
import com.iab.gpp.encoder.base64.CompressedBase64UrlEncoder;
import com.iab.gpp.encoder.bitstring.BitStringEncoder;
import com.iab.gpp.encoder.datatype.EncodableBoolean;
import com.iab.gpp.encoder.datatype.EncodableFixedInteger;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.field.EncodableBitStringFields;
import com.iab.gpp.encoder.field.UsMtField;
import com.iab.gpp.encoder.segment.AbstractLazilyEncodableSegment;
import java.util.List;

public class UsMtGpcSegment
extends AbstractLazilyEncodableSegment<EncodableBitStringFields> {
    private AbstractBase64UrlEncoder base64UrlEncoder = CompressedBase64UrlEncoder.getInstance();
    private BitStringEncoder bitStringEncoder = BitStringEncoder.getInstance();

    public UsMtGpcSegment() {
    }

    public UsMtGpcSegment(String encodedString) {
        this.decode(encodedString);
    }

    @Override
    public List<String> getFieldNames() {
        return UsMtField.USMT_GPC_SEGMENT_FIELD_NAMES;
    }

    @Override
    protected EncodableBitStringFields initializeFields() {
        EncodableBitStringFields fields = new EncodableBitStringFields();
        fields.put(UsMtField.GPC_SEGMENT_TYPE, new EncodableFixedInteger(2, 1));
        fields.put(UsMtField.GPC_SEGMENT_INCLUDED, new EncodableBoolean((Boolean)true));
        fields.put(UsMtField.GPC, new EncodableBoolean((Boolean)false));
        return fields;
    }

    @Override
    protected String encodeSegment(EncodableBitStringFields fields) {
        String bitString = this.bitStringEncoder.encode(fields, this.getFieldNames());
        String encodedString = this.base64UrlEncoder.encode(bitString);
        return encodedString;
    }

    @Override
    protected void decodeSegment(String encodedString, EncodableBitStringFields fields) {
        if (encodedString == null || encodedString.isEmpty()) {
            ((EncodableBitStringFields)this.fields).reset(fields);
        }
        try {
            String bitString = this.base64UrlEncoder.decode(encodedString);
            this.bitStringEncoder.decode(bitString, this.getFieldNames(), fields);
        }
        catch (Exception e) {
            throw new DecodingException("Unable to decode UsMtGpcSegment '" + encodedString + "'", e);
        }
    }
}

