/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.segment;

import com.iab.gpp.encoder.base64.AbstractBase64UrlEncoder;
import com.iab.gpp.encoder.base64.CompressedBase64UrlEncoder;
import com.iab.gpp.encoder.bitstring.BitStringEncoder;
import com.iab.gpp.encoder.datatype.EncodableFixedInteger;
import com.iab.gpp.encoder.datatype.EncodableFixedIntegerList;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.field.EncodableBitStringFields;
import com.iab.gpp.encoder.field.UsNeField;
import com.iab.gpp.encoder.field.UsVaField;
import com.iab.gpp.encoder.section.UsNe;
import com.iab.gpp.encoder.segment.AbstractLazilyEncodableSegment;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class UsNeCoreSegment
extends AbstractLazilyEncodableSegment<EncodableBitStringFields> {
    private AbstractBase64UrlEncoder base64UrlEncoder = CompressedBase64UrlEncoder.getInstance();
    private BitStringEncoder bitStringEncoder = BitStringEncoder.getInstance();

    public UsNeCoreSegment() {
    }

    public UsNeCoreSegment(String encodedString) {
        this.decode(encodedString);
    }

    @Override
    public List<String> getFieldNames() {
        return UsNeField.USNE_CORE_SEGMENT_FIELD_NAMES;
    }

    @Override
    protected EncodableBitStringFields initializeFields() {
        Predicate<Integer> nullableBooleanAsTwoBitIntegerValidator = n -> n >= 0 && n <= 2;
        Predicate<Integer> nonNullableBooleanAsTwoBitIntegerValidator = n -> n >= 1 && n <= 2;
        Predicate<List> nullableBooleanAsTwoBitIntegerListValidator = l -> {
            Iterator iterator = l.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (n >= 0 && n <= 2) continue;
                return false;
            }
            return true;
        };
        EncodableBitStringFields fields = new EncodableBitStringFields();
        fields.put(UsNeField.VERSION, new EncodableFixedInteger(6, UsNe.VERSION));
        fields.put(UsNeField.PROCESSING_NOTICE, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsNeField.SALE_OPT_OUT_NOTICE, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsNeField.TARGETED_ADVERTISING_OPT_OUT_NOTICE, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsNeField.SALE_OPT_OUT, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsNeField.TARGETED_ADVERTISING_OPT_OUT, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsNeField.SENSITIVE_DATA_PROCESSING, new EncodableFixedIntegerList(2, Arrays.asList(0, 0, 0, 0, 0, 0, 0, 0)).withValidator(nullableBooleanAsTwoBitIntegerListValidator));
        fields.put(UsVaField.KNOWN_CHILD_SENSITIVE_DATA_CONSENTS, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsNeField.ADDITIONAL_DATA_PROCESSING_CONSENT, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsNeField.MSPA_COVERED_TRANSACTION, new EncodableFixedInteger(2, 1).withValidator(nonNullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsNeField.MSPA_OPT_OUT_OPTION_MODE, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsNeField.MSPA_SERVICE_PROVIDER_MODE, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        return fields;
    }

    @Override
    protected String encodeSegment(EncodableBitStringFields fields) {
        String bitString = this.bitStringEncoder.encode(fields, this.getFieldNames());
        String encodedString = this.base64UrlEncoder.encode(bitString);
        return encodedString;
    }

    @Override
    protected void decodeSegment(String encodedString, EncodableBitStringFields fields) {
        if (encodedString == null || encodedString.isEmpty()) {
            ((EncodableBitStringFields)this.fields).reset(fields);
        }
        try {
            String bitString = this.base64UrlEncoder.decode(encodedString);
            this.bitStringEncoder.decode(bitString, this.getFieldNames(), fields);
        }
        catch (Exception e) {
            throw new DecodingException("Unable to decode UsNeCoreSegment '" + encodedString + "'", e);
        }
    }
}

