/*
 * Decompiled with CFR 0.152.
 */
package com.iabtcf.decoder;

import java.io.IOException;
import java.io.InputStream;

class SegmentInputStream
extends InputStream {
    private final String src;
    private int rpos;
    private int start;
    private int end = -1;

    public SegmentInputStream(String src, int start) {
        if (src == null) {
            throw new IllegalArgumentException("src");
        }
        if (start < 0) {
            throw new IllegalArgumentException(String.format("start is invalid %d", start));
        }
        this.src = src;
        start = this.rpos = Math.min(start, src.length());
    }

    @Override
    public int read() throws IOException {
        char c;
        if (this.rpos >= this.src.length() || (c = this.src.charAt(this.rpos)) == '.') {
            return -1;
        }
        ++this.rpos;
        return (c & 0xFF) != c ? -1 : (int)c;
    }

    @Override
    public int available() throws IOException {
        if (this.rpos < this.src.length() && this.src.charAt(this.rpos) != '.') {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.rpos = this.start;
    }

    protected int segmentEnd() {
        if (this.end == -1) {
            this.end = this.rpos;
            while (this.end < this.src.length() && this.src.charAt(this.end) != '.') {
                ++this.end;
            }
        }
        return this.end;
    }

    protected boolean hasNextSegment() {
        for (int idx = Math.max(this.rpos, this.end); idx < this.src.length(); ++idx) {
            if (this.src.charAt(idx) != '.') continue;
            this.end = idx;
            return true;
        }
        return false;
    }
}

