/*
 * Decompiled with CFR 0.152.
 */
package com.iabtcf.decoder;

import com.iabtcf.decoder.DecoderOption;
import com.iabtcf.decoder.TCString;
import com.iabtcf.decoder.TCStringV1;
import com.iabtcf.decoder.TCStringV2;
import com.iabtcf.exceptions.ByteParseException;
import com.iabtcf.exceptions.UnsupportedVersionException;
import com.iabtcf.utils.BitReader;
import com.iabtcf.utils.FieldDefs;
import java.util.Base64;
import java.util.EnumSet;

class TCStringDecoder {
    TCStringDecoder() {
    }

    static BitReader vectorFromString(String base64UrlEncodedString) {
        byte[] bytes = Base64.getUrlDecoder().decode(base64UrlEncodedString);
        return new BitReader(bytes);
    }

    public static TCString decode(String consentString, DecoderOption ... options) throws IllegalArgumentException, ByteParseException, UnsupportedVersionException {
        EnumSet<DecoderOption> optSet = EnumSet.noneOf(DecoderOption.class);
        for (DecoderOption opt : options) {
            optSet.add(opt);
        }
        String[] split = consentString.split("\\.");
        String base64UrlEncodedString = split[0];
        BitReader bitVector = TCStringDecoder.vectorFromString(base64UrlEncodedString);
        byte version = bitVector.readBits6(FieldDefs.CORE_VERSION);
        switch (version) {
            case 1: {
                return TCStringV1.fromBitVector(bitVector);
            }
            case 2: {
                TCStringV2 tcString = null;
                if (split.length > 1) {
                    BitReader[] remaining = new BitReader[split.length - 1];
                    for (int i = 1; i < split.length; ++i) {
                        remaining[i - 1] = TCStringDecoder.vectorFromString(split[i]);
                    }
                    tcString = TCStringV2.fromBitVector(bitVector, remaining);
                } else {
                    tcString = TCStringV2.fromBitVector(bitVector, new BitReader[0]);
                }
                if (!optSet.contains((Object)DecoderOption.LAZY)) {
                    ((Object)tcString).hashCode();
                }
                return tcString;
            }
        }
        throw new UnsupportedVersionException("Version " + version + "is unsupported yet");
    }
}

