/*
 * Decompiled with CFR 0.152.
 */
package com.iabtcf.utils;

import com.iabtcf.exceptions.ByteParseException;
import com.iabtcf.utils.FieldDefs;
import com.iabtcf.utils.LengthOffsetCache;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;

public class BitReader {
    private byte[] buffer;
    private int isrpos;
    private final InputStream is;
    final LengthOffsetCache cache;

    public BitReader(InputStream is) {
        this.buffer = new byte[4096];
        this.is = is;
        this.isrpos = 0;
        this.cache = new LengthOffsetCache(this);
    }

    public BitReader(byte[] buffer) {
        this.buffer = buffer;
        this.isrpos = buffer.length;
        this.is = null;
        this.cache = new LengthOffsetCache(this);
    }

    private void ensureCapacity(int length) {
        if (this.buffer.length >= length) {
            return;
        }
        byte[] b = new byte[length * 2];
        System.arraycopy(this.buffer, 0, b, 0, this.buffer.length);
        this.buffer = b;
    }

    private boolean ensureReadable(int offset, int length) {
        int tlength = offset + length;
        if (tlength <= this.isrpos) {
            return true;
        }
        if (this.is == null) {
            throw new ByteParseException(String.format("read %d bytes at index %d out of bounds for buffer length %d", length, offset, this.buffer.length));
        }
        this.ensureCapacity(tlength);
        try {
            int n;
            for (int rem = tlength - this.isrpos; rem > 0; rem -= n) {
                n = this.is.read(this.buffer, this.isrpos, rem);
                if (n == -1) {
                    return false;
                }
                this.isrpos += n;
            }
        }
        catch (IOException e) {
            throw new ByteParseException(String.format("error decoding at offset %d length %d", offset, length), e);
        }
        return true;
    }

    public String readStr2(int offset) {
        return String.valueOf(new char[]{(char)(65 + this.readBits6(offset)), (char)(65 + this.readBits6(offset + 6))});
    }

    public String readStr2(FieldDefs field) {
        return this.readStr2(field.getOffset(this));
    }

    public boolean readBits1(FieldDefs field) {
        assert (field.getLength(this) == 1);
        return this.readBits1(field.getOffset(this));
    }

    public boolean readBits1(int offset) {
        int startByte = offset >>> 3;
        int bitPos = offset % 8;
        this.ensureReadable(startByte, 1);
        return (this.buffer[startByte] >>> 7 - bitPos & 1) == 1;
    }

    public byte readBits2(FieldDefs field) {
        assert (field.getLength(this) == 2);
        return this.readBits2(field.getOffset(this));
    }

    public byte readBits2(int offset) {
        return this.readByteBits(offset, 2);
    }

    public byte readBits3(FieldDefs field) {
        assert (field.getLength(this) == 3);
        return this.readBits3(field.getOffset(this));
    }

    public byte readBits3(int offset) {
        return this.readByteBits(offset, 3);
    }

    public byte readBits6(FieldDefs field) {
        assert (field.getLength(this) == 6);
        return this.readBits6(field.getOffset(this));
    }

    public byte readBits6(int offset) {
        int startByte = offset >>> 3;
        int bitPos = offset % 8;
        int n = 8 - bitPos;
        if (n < 6) {
            this.ensureReadable(startByte, 2);
            return (byte)(this.unsafeReadLsb(this.buffer[startByte], 6 - n, n) | this.unsafeReadMsb(this.buffer[startByte + 1], 0, 6 - n));
        }
        this.ensureReadable(startByte, 1);
        return this.unsafeReadMsb(this.buffer[startByte], bitPos, 6);
    }

    private byte readByteBits(int offset, int nbits) {
        int startByte = offset >>> 3;
        int bitPos = offset % 8;
        int n = 8 - bitPos;
        if (n < nbits) {
            this.ensureReadable(startByte, 2);
            return (byte)(this.unsafeReadLsb(this.buffer[startByte], nbits - n, n) | this.unsafeReadMsb(this.buffer[startByte + 1], 0, nbits - n));
        }
        this.ensureReadable(startByte, 1);
        return this.unsafeReadMsb(this.buffer[startByte], bitPos, nbits);
    }

    public int readBits12(FieldDefs field) {
        assert (field.getLength(this) == 12);
        return this.readBits12(field.getOffset(this));
    }

    public int readBits12(int offset) {
        int startByte = offset >>> 3;
        int bitPos = offset % 8;
        int n = 8 - bitPos;
        if (n < 4) {
            this.ensureReadable(startByte, 3);
            return (this.unsafeReadLsb(this.buffer[startByte], bitPos, n) & 0xFF) << 4 | (this.buffer[startByte + 1] & 0xFF) << bitPos - 4 | this.unsafeReadMsb(this.buffer[startByte + 2], 0, bitPos - 4) & 0xFF;
        }
        this.ensureReadable(startByte, 2);
        return (this.unsafeReadLsb(this.buffer[startByte], bitPos, n) & 0xFF) << 4 | this.unsafeReadMsb(this.buffer[startByte + 1], 0, 4 + bitPos) & 0xFF;
    }

    public int readBits16(FieldDefs field) {
        assert (field.getLength(this) == 16);
        return this.readBits16(field.getOffset(this));
    }

    public int readBits16(int offset) {
        int startByte = offset >>> 3;
        int bitPos = offset % 8;
        int n = 8 - bitPos;
        if (n < 8) {
            this.ensureReadable(startByte, 3);
            return (this.unsafeReadLsb(this.buffer[startByte], bitPos, n) & 0xFF) << 8 | (this.buffer[startByte + 1] & 0xFF) << bitPos | this.unsafeReadMsb(this.buffer[startByte + 2], 0, bitPos) & 0xFF;
        }
        this.ensureReadable(startByte, 2);
        return (this.buffer[startByte] & 0xFF) << 8 | this.buffer[startByte + 1] & 0xFF;
    }

    public int readBits24(FieldDefs field) {
        assert (field.getLength(this) == 24);
        return this.readBits24(field.getOffset(this));
    }

    public int readBits24(int offset) {
        int startByte = offset >>> 3;
        int bitPos = offset % 8;
        int n = 8 - bitPos;
        if (n < 8) {
            this.ensureReadable(startByte, 4);
            return (this.unsafeReadLsb(this.buffer[startByte], bitPos, n) & 0xFF) << 16 | (this.buffer[startByte + 1] & 0xFF) << 8 + bitPos | (this.buffer[startByte + 2] & 0xFF) << bitPos | this.unsafeReadMsb(this.buffer[startByte + 3], 0, bitPos) & 0xFF;
        }
        this.ensureReadable(startByte, 3);
        return (this.buffer[startByte] & 0xFF) << 16 | (this.buffer[startByte + 1] & 0xFF) << 8 | this.buffer[startByte + 2] & 0xFF;
    }

    public long readBits36(FieldDefs field) {
        assert (field.getLength(this) == 36);
        return this.readBits36(field.getOffset(this));
    }

    public long readBits36(int offset) {
        int startByte = offset >>> 3;
        int bitPos = offset % 8;
        int n = 8 - bitPos;
        if (n < 4) {
            this.ensureReadable(startByte, 6);
            return ((long)this.unsafeReadLsb(this.buffer[startByte], bitPos, n) & 0xFFL) << 28 | ((long)this.buffer[startByte + 1] & 0xFFL) << 20 + bitPos | ((long)this.buffer[startByte + 2] & 0xFFL) << 12 + bitPos | ((long)this.buffer[startByte + 3] & 0xFFL) << 4 + bitPos | ((long)this.buffer[startByte + 4] & 0xFFL) << bitPos - 4 | (long)this.unsafeReadMsb(this.buffer[startByte + 5], 0, bitPos - 4) & 0xFFL;
        }
        this.ensureReadable(startByte, 5);
        return ((long)this.unsafeReadLsb(this.buffer[startByte], bitPos, n) & 0xFFL) << 28 | ((long)this.buffer[startByte + 1] & 0xFFL) << 20 + bitPos | ((long)this.buffer[startByte + 2] & 0xFFL) << 12 + bitPos | ((long)this.buffer[startByte + 3] & 0xFFL) << 4 + bitPos | (long)this.unsafeReadMsb(this.buffer[startByte + 4], 0, 4 + bitPos) & 0xFFL;
    }

    public BitSet readBitSet(int offset, int length) {
        BitSet bs = new BitSet(length);
        for (int i = 0; i < length; ++i) {
            if (!this.readBits1(offset + i)) continue;
            bs.set(i);
        }
        return bs;
    }

    private byte unsafeReadMsb(byte from, int offset, int length) {
        return length == 0 ? (byte)0 : (byte)(from >>> 8 - length - offset & (1 << length) - 1);
    }

    private byte unsafeReadLsb(byte from, int offset, int length) {
        return length == 0 ? from : (byte)((from & (1 << length) - 1) << offset);
    }
}

