/*
 * Decompiled with CFR 0.152.
 */
package com.iabtcf.v2;

import com.iabtcf.utils.IntIterable;
import com.iabtcf.utils.IntIterator;
import com.iabtcf.v2.RestrictionType;
import java.util.Objects;
import java.util.StringJoiner;

public class PublisherRestriction {
    private final int purposeId;
    private final RestrictionType restrictionType;
    private final IntIterable vendorIds;

    public PublisherRestriction(int purposeId, RestrictionType restrictionType, IntIterable vendorIds) {
        Objects.requireNonNull(vendorIds);
        Objects.requireNonNull(restrictionType);
        this.purposeId = purposeId;
        this.restrictionType = restrictionType;
        this.vendorIds = vendorIds;
    }

    public int getPurposeId() {
        return this.purposeId;
    }

    public RestrictionType getRestrictionType() {
        return this.restrictionType;
    }

    public IntIterable getVendorIds() {
        return this.vendorIds;
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        IntIterator i = this.getVendorIds().intIterator();
        while (i.hasNext()) {
            sj.add(((Integer)i.next()).toString());
        }
        return "PublisherRestriction{purposeId=" + this.purposeId + ", restrictionType=" + (Object)((Object)this.restrictionType) + ", vendorIds=" + sj.toString() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublisherRestriction that = (PublisherRestriction)o;
        return this.purposeId == that.purposeId && this.restrictionType == that.restrictionType && this.vendorIds.equals(that.vendorIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.purposeId, this.restrictionType, this.vendorIds});
    }
}

