/*
 * Decompiled with CFR 0.152.
 */
package com.iabtcf.decoder;

import com.iabtcf.decoder.SegmentInputStream;
import java.io.InputStream;
import java.util.function.Supplier;

class LazySegmentFactory {
    private SegmentSupplier sup;
    private final String src;

    public LazySegmentFactory(String src) {
        this.src = src;
        this.sup = new SegmentSupplier();
    }

    public Supplier<InputStream> next() {
        SegmentSupplier prev = this.sup;
        this.sup = new SegmentSupplier(prev);
        return prev;
    }

    class SegmentSupplier
    implements Supplier<InputStream> {
        private final SegmentSupplier prev;
        private SegmentInputStream current;

        public SegmentSupplier() {
            this.prev = null;
            this.current = new SegmentInputStream(LazySegmentFactory.this.src, 0);
        }

        public SegmentSupplier(SegmentSupplier prev) {
            assert (prev != null);
            this.prev = prev;
        }

        private SegmentInputStream getCurrent() {
            if (this.current == null) {
                SegmentInputStream prevStream = this.prev.getCurrent();
                this.current = prevStream == EmptyInputStream.INSTANCE ? EmptyInputStream.INSTANCE : new SegmentInputStream(LazySegmentFactory.this.src, prevStream.segmentEnd() + 1);
            }
            return this.current;
        }

        @Override
        public InputStream get() {
            return this.getCurrent();
        }
    }

    private static class EmptyInputStream
    extends SegmentInputStream {
        public static EmptyInputStream INSTANCE = new EmptyInputStream();

        private EmptyInputStream() {
            super("", 0);
        }

        @Override
        protected boolean hasNextSegment() {
            return false;
        }

        @Override
        protected int segmentEnd() {
            return -1;
        }
    }
}

