/*
 * Decompiled with CFR 0.152.
 */
package com.iabtcf.decoder;

import com.iabtcf.decoder.TCStringV2;
import com.iabtcf.exceptions.ByteParseException;
import com.iabtcf.exceptions.UnsupportedVersionException;
import com.iabtcf.utils.BitReader;
import com.iabtcf.utils.FieldDefs;
import com.iabtcf.utils.IntIterable;
import java.time.Instant;
import java.util.Base64;
import java.util.Objects;

public class PPCString {
    private final BitReader bbv;

    private PPCString(BitReader bitVector) {
        this.bbv = bitVector;
    }

    public static PPCString decode(String consentString) throws IllegalArgumentException, ByteParseException, UnsupportedVersionException {
        byte[] bytes = Base64.getUrlDecoder().decode(consentString);
        return new PPCString(new BitReader(bytes));
    }

    public int getVersion() {
        return this.bbv.readBits6(FieldDefs.V1_VERSION);
    }

    public Instant getCreated() {
        return Instant.ofEpochMilli(this.bbv.readBits36(FieldDefs.V1_CREATED) * 100L);
    }

    public Instant getLastUpdated() {
        return Instant.ofEpochMilli(this.bbv.readBits36(FieldDefs.V1_LAST_UPDATED) * 100L);
    }

    public int getCmpId() {
        return this.bbv.readBits12(FieldDefs.V1_CMP_ID);
    }

    public int getCmpVersion() {
        return this.bbv.readBits12(FieldDefs.V1_CMP_VERSION);
    }

    public int getConsentScreen() {
        return this.bbv.readBits6(FieldDefs.V1_CONSENT_SCREEN);
    }

    public String getConsentLanguage() {
        return this.bbv.readStr2(FieldDefs.V1_CONSENT_LANGUAGE);
    }

    public int getVendorListVersion() {
        return this.bbv.readBits12(FieldDefs.V1_VENDOR_LIST_VERSION);
    }

    public int getPublisherPurposesVersion() {
        return this.bbv.readBits12(FieldDefs.V1_PPC_PUBLISHER_PURPOSES_VERSION);
    }

    public IntIterable getStandardPurposesAllowed() {
        return TCStringV2.fillBitSet(this.bbv, FieldDefs.V1_PPC_STANDARD_PURPOSES_ALLOWED);
    }

    public IntIterable getCustomPurposesBitField() {
        return TCStringV2.fillBitSet(this.bbv, FieldDefs.V1_PPC_CUSTOM_PURPOSES_BITFIELD);
    }

    public int hashCode() {
        return Objects.hash(this.getVersion(), this.getCreated(), this.getLastUpdated(), this.getCmpId(), this.getCmpVersion(), this.getConsentScreen(), this.getConsentLanguage(), this.getVendorListVersion(), this.getPublisherPurposesVersion(), this.getStandardPurposesAllowed(), this.getCustomPurposesBitField());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PPCString other = (PPCString)obj;
        return this.getVersion() == other.getVersion() && Objects.equals(this.getCreated(), other.getCreated()) && Objects.equals(this.getLastUpdated(), other.getLastUpdated()) && this.getCmpId() == other.getCmpId() && this.getCmpVersion() == other.getCmpVersion() && this.getConsentScreen() == other.getConsentScreen() && Objects.equals(this.getConsentLanguage(), other.getConsentLanguage()) && this.getVendorListVersion() == other.getVendorListVersion() && Objects.equals(this.getPublisherPurposesVersion(), other.getPublisherPurposesVersion()) && Objects.equals(this.getStandardPurposesAllowed(), other.getStandardPurposesAllowed()) && Objects.equals(this.getCustomPurposesBitField(), other.getCustomPurposesBitField());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PPCString [getVersion()=");
        builder.append(this.getVersion());
        builder.append(", getCreated()=");
        builder.append(this.getCreated());
        builder.append(", getLastUpdated()=");
        builder.append(this.getLastUpdated());
        builder.append(", getCmpId()=");
        builder.append(this.getCmpId());
        builder.append(", getCmpVersion()=");
        builder.append(this.getCmpVersion());
        builder.append(", getConsentScreen()=");
        builder.append(this.getConsentScreen());
        builder.append(", getConsentLanguage()=");
        builder.append(this.getConsentLanguage());
        builder.append(", getVendorListVersion()=");
        builder.append(this.getVendorListVersion());
        builder.append(", getPublisherPurposesVersion()=");
        builder.append(this.getPublisherPurposesVersion());
        builder.append(", getStandardPurposesAllowed()=");
        builder.append(this.getStandardPurposesAllowed());
        builder.append(", getCustomPurposesBitField()=");
        builder.append(this.getCustomPurposesBitField());
        builder.append("]");
        return builder.toString();
    }
}

