/*
 * Decompiled with CFR 0.152.
 */
package com.iabtcf.decoder;

import com.iabtcf.decoder.TCString;
import com.iabtcf.decoder.TCStringV2;
import com.iabtcf.utils.BitReader;
import com.iabtcf.utils.BitSetIntIterable;
import com.iabtcf.utils.FieldDefs;
import com.iabtcf.utils.IntIterable;
import com.iabtcf.v2.PublisherRestriction;
import java.time.Instant;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class TCStringV1
implements TCString {
    private final BitReader bbv;

    private TCStringV1(BitReader bitVector) {
        this.bbv = bitVector;
    }

    public static TCStringV1 fromBitVector(BitReader bitVector) {
        return new TCStringV1(bitVector);
    }

    @Override
    public int getVersion() {
        return this.bbv.readBits6(FieldDefs.V1_VERSION);
    }

    @Override
    public Instant getCreated() {
        return Instant.ofEpochMilli(this.bbv.readBits36(FieldDefs.V1_CREATED) * 100L);
    }

    @Override
    public Instant getLastUpdated() {
        return Instant.ofEpochMilli(this.bbv.readBits36(FieldDefs.V1_LAST_UPDATED) * 100L);
    }

    @Override
    public int getCmpId() {
        return this.bbv.readBits12(FieldDefs.V1_CMP_ID);
    }

    @Override
    public int getCmpVersion() {
        return this.bbv.readBits12(FieldDefs.V1_CMP_VERSION);
    }

    @Override
    public int getConsentScreen() {
        return this.bbv.readBits6(FieldDefs.V1_CONSENT_SCREEN);
    }

    @Override
    public String getConsentLanguage() {
        return this.bbv.readStr2(FieldDefs.V1_CONSENT_LANGUAGE);
    }

    @Override
    public int getVendorListVersion() {
        return this.bbv.readBits12(FieldDefs.V1_VENDOR_LIST_VERSION);
    }

    @Override
    public IntIterable getVendorConsent() {
        return this.fillVendorsV1(this.bbv, FieldDefs.V1_VENDOR_MAX_VENDOR_ID, FieldDefs.V1_VENDOR_BITRANGE_FIELD);
    }

    @Override
    public boolean getDefaultVendorConsent() {
        return this.bbv.readBits1(FieldDefs.V1_VENDOR_IS_RANGE_ENCODING) && this.bbv.readBits1(FieldDefs.V1_VENDOR_DEFAULT_CONSENT);
    }

    @Override
    public IntIterable getPurposesConsent() {
        return TCStringV2.fillBitSet(this.bbv, FieldDefs.V1_PURPOSES_ALLOW);
    }

    @Override
    public int getTcfPolicyVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isServiceSpecific() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getUseNonStandardStacks() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntIterable getSpecialFeatureOptIns() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntIterable getPurposesLITransparency() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getPurposeOneTreatment() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPublisherCC() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntIterable getVendorLegitimateInterest() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<PublisherRestriction> getPublisherRestrictions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntIterable getAllowedVendors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntIterable getDisclosedVendors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntIterable getPubPurposesConsent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntIterable getPubPurposesLITransparency() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntIterable getCustomPurposesConsent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntIterable getCustomPurposesLITransparency() {
        throw new UnsupportedOperationException();
    }

    private IntIterable fillVendorsV1(BitReader bbv, FieldDefs maxVendor, FieldDefs vendorField) {
        BitSet bs = new BitSet();
        int maxV = bbv.readBits16(maxVendor);
        boolean isRangeEncoding = bbv.readBits1(maxVendor.getEnd(bbv));
        if (isRangeEncoding) {
            boolean defaultConsent = bbv.readBits1(FieldDefs.V1_VENDOR_DEFAULT_CONSENT);
            TCStringV2.vendorIdsFromRange(bbv, bs, FieldDefs.V1_VENDOR_NUM_ENTRIES.getOffset(bbv), Optional.of(maxVendor));
            if (defaultConsent) {
                bs.flip(1, maxV + 1);
            }
        } else {
            for (int i = 0; i < maxV; ++i) {
                boolean hasVendorConsent = bbv.readBits1(vendorField.getOffset(bbv) + i);
                if (!hasVendorConsent) continue;
                bs.set(i + 1);
            }
        }
        return BitSetIntIterable.from(bs);
    }

    public int hashCode() {
        return Objects.hash(this.getVersion(), this.getCreated(), this.getLastUpdated(), this.getCmpId(), this.getCmpVersion(), this.getConsentScreen(), this.getConsentLanguage(), this.getVendorListVersion(), this.getVendorConsent(), this.getDefaultVendorConsent(), this.getPurposesConsent());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TCStringV1 other = (TCStringV1)obj;
        return this.getVersion() == other.getVersion() && Objects.equals(this.getCreated(), other.getCreated()) && Objects.equals(this.getLastUpdated(), other.getLastUpdated()) && this.getCmpId() == other.getCmpId() && this.getCmpVersion() == other.getCmpVersion() && this.getConsentScreen() == other.getConsentScreen() && Objects.equals(this.getConsentLanguage(), other.getConsentLanguage()) && this.getVendorListVersion() == other.getVendorListVersion() && Objects.equals(this.getVendorConsent(), other.getVendorConsent()) && this.getDefaultVendorConsent() == other.getDefaultVendorConsent() && Objects.equals(this.getPurposesConsent(), other.getPurposesConsent());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TCStringV1 [getVersion()=");
        builder.append(this.getVersion());
        builder.append(", getCreated()=");
        builder.append(this.getCreated());
        builder.append(", getLastUpdated()=");
        builder.append(this.getLastUpdated());
        builder.append(", getCmpId()=");
        builder.append(this.getCmpId());
        builder.append(", getCmpVersion()=");
        builder.append(this.getCmpVersion());
        builder.append(", getConsentScreen()=");
        builder.append(this.getConsentScreen());
        builder.append(", getConsentLanguage()=");
        builder.append(this.getConsentLanguage());
        builder.append(", getVendorListVersion()=");
        builder.append(this.getVendorListVersion());
        builder.append(", getVendorConsent()=");
        builder.append(this.getVendorConsent());
        builder.append(", getDefaultVendorConsent()=");
        builder.append(this.getDefaultVendorConsent());
        builder.append(", getPurposesConsent()=");
        builder.append(this.getPurposesConsent());
        builder.append("]");
        return builder.toString();
    }
}

