/*
 * Decompiled with CFR 0.152.
 */
package com.iabtcf.decoder;

import com.iabtcf.decoder.TCString;
import com.iabtcf.exceptions.InvalidRangeFieldException;
import com.iabtcf.utils.BitReader;
import com.iabtcf.utils.BitSetIntIterable;
import com.iabtcf.utils.FieldDefs;
import com.iabtcf.utils.IntIterable;
import com.iabtcf.v2.PublisherRestriction;
import com.iabtcf.v2.RestrictionType;
import com.iabtcf.v2.SegmentType;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class TCStringV2
implements TCString {
    private int version;
    private Instant consentRecordCreated;
    private Instant consentRecordLastUpdated;
    private int consentManagerProviderId;
    private int consentManagerProviderVersion;
    private int consentScreen;
    private String consentLanguage;
    private int vendorListVersion;
    private int policyVersion;
    private boolean isServiceSpecific;
    private boolean useNonStandardStacks;
    private IntIterable specialFeaturesOptInts;
    private IntIterable purposesConsent;
    private IntIterable purposesLITransparency;
    private boolean isPurposeOneTreatment;
    private String publisherCountryCode;
    private IntIterable vendorConsents;
    private IntIterable vendorLegitimateInterests;
    private List<PublisherRestriction> publisherRestrictions;
    private IntIterable disclosedVendors;
    private IntIterable allowedVendors;
    private IntIterable publisherPurposesConsent;
    private IntIterable publisherPurposesLITransparency;
    private IntIterable customPurposesConsent;
    private IntIterable customPurposesLITransparency;
    private final EnumSet<FieldDefs> cache = EnumSet.noneOf(FieldDefs.class);
    private final BitReader bbv;
    private final Collection<BitReader> remainingVectors;

    private TCStringV2(BitReader bbv) {
        this(bbv, new BitReader[0]);
    }

    private TCStringV2(BitReader bbv, BitReader ... theRest) {
        this.bbv = bbv;
        this.remainingVectors = Arrays.asList(theRest);
    }

    public static TCStringV2 fromBitVector(BitReader coreBitVector, BitReader ... remainingVectors) {
        return new TCStringV2(coreBitVector, remainingVectors);
    }

    private BitReader getSegment(SegmentType segmentType) {
        if (segmentType == SegmentType.DEFAULT) {
            return this.bbv;
        }
        for (BitReader rbbv : this.remainingVectors) {
            byte rSegmentType = rbbv.readBits3(FieldDefs.OOB_SEGMENT_TYPE);
            if (segmentType != SegmentType.from(rSegmentType)) continue;
            return rbbv;
        }
        return null;
    }

    @Override
    public IntIterable getPubPurposesConsent() {
        if (this.cache.add(FieldDefs.PPTC_PUB_PURPOSES_CONSENT)) {
            this.publisherPurposesConsent = BitSetIntIterable.EMPTY;
            BitReader dvBbv = this.getSegment(SegmentType.PUBLISHER_TC);
            if (dvBbv != null) {
                this.publisherPurposesConsent = TCStringV2.fillBitSet(dvBbv, FieldDefs.PPTC_PUB_PURPOSES_CONSENT);
            }
        }
        return this.publisherPurposesConsent;
    }

    static BitSetIntIterable fillVendors(BitReader bbv, FieldDefs maxVendor, FieldDefs vendorField) {
        BitSet bs = new BitSet();
        int maxV = bbv.readBits16(maxVendor);
        boolean isRangeEncoding = bbv.readBits1(maxVendor.getEnd(bbv));
        if (isRangeEncoding) {
            TCStringV2.vendorIdsFromRange(bbv, bs, vendorField, Optional.of(maxVendor));
        } else {
            for (int i = 0; i < maxV; ++i) {
                boolean hasVendorConsent = bbv.readBits1(vendorField.getOffset(bbv) + i);
                if (!hasVendorConsent) continue;
                bs.set(i + 1);
            }
        }
        return BitSetIntIterable.from(bs);
    }

    static int vendorIdsFromRange(BitReader bbv, BitSet bs, int numberOfVendorEntriesOffset, Optional<FieldDefs> maxVendor) {
        int numberOfVendorEntries = bbv.readBits12(numberOfVendorEntriesOffset);
        int offset = numberOfVendorEntriesOffset + FieldDefs.NUM_ENTRIES.getLength(bbv);
        int maxV = maxVendor.map(maxVF -> bbv.readBits16((FieldDefs)((Object)maxVF))).orElse(Integer.MAX_VALUE);
        for (int j = 0; j < numberOfVendorEntries; ++j) {
            boolean isRangeEntry = bbv.readBits1(offset++);
            int startOrOnlyVendorId = bbv.readBits16(offset);
            offset += FieldDefs.START_OR_ONLY_VENDOR_ID.getLength(bbv);
            if (isRangeEntry) {
                int endVendorId = bbv.readBits16(offset);
                offset += FieldDefs.START_OR_ONLY_VENDOR_ID.getLength(bbv);
                if (startOrOnlyVendorId > endVendorId) {
                    throw new InvalidRangeFieldException(String.format("start vendor id (%d) is greater than endVendorId (%d)", startOrOnlyVendorId, endVendorId));
                }
                if (endVendorId > maxV) {
                    throw new InvalidRangeFieldException(String.format("end vendor id (%d) is greater than max (%d)", endVendorId, maxV));
                }
                bs.set(startOrOnlyVendorId, endVendorId + 1);
                continue;
            }
            bs.set(startOrOnlyVendorId);
        }
        return offset;
    }

    static void vendorIdsFromRange(BitReader bbv, BitSet bs, FieldDefs vendorField, Optional<FieldDefs> maxVendor) {
        TCStringV2.vendorIdsFromRange(bbv, bs, vendorField.getOffset(bbv), maxVendor);
    }

    private int fillPublisherRestrictions(List<PublisherRestriction> publisherRestrictions, int currentPointer, BitReader bitVector) {
        int numberOfPublisherRestrictions = bitVector.readBits12(currentPointer);
        currentPointer += FieldDefs.NUM_ENTRIES.getLength(bitVector);
        for (int i = 0; i < numberOfPublisherRestrictions; ++i) {
            byte purposeId = bitVector.readBits6(currentPointer);
            byte restrictionTypeId = bitVector.readBits2(currentPointer += FieldDefs.PURPOSE_ID.getLength(bitVector));
            currentPointer += 2;
            RestrictionType restrictionType = RestrictionType.from(restrictionTypeId);
            BitSet bs = new BitSet();
            currentPointer = TCStringV2.vendorIdsFromRange(this.bbv, bs, currentPointer, Optional.empty());
            PublisherRestriction publisherRestriction = new PublisherRestriction(purposeId, restrictionType, BitSetIntIterable.from(bs));
            publisherRestrictions.add(publisherRestriction);
        }
        return currentPointer;
    }

    static BitSetIntIterable fillBitSet(BitReader bbv, FieldDefs field) {
        int offset = field.getOffset(bbv);
        int length = field.getLength(bbv);
        BitSetIntIterable.Builder bs = BitSetIntIterable.newBuilder();
        for (int i = 0; i < length; ++i) {
            if (!bbv.readBits1(offset + i)) continue;
            bs.add(i + 1);
        }
        return bs.build();
    }

    @Override
    public int getVersion() {
        if (this.cache.add(FieldDefs.CORE_VERSION)) {
            this.version = this.bbv.readBits6(FieldDefs.CORE_VERSION);
        }
        return this.version;
    }

    @Override
    public Instant getCreated() {
        if (this.cache.add(FieldDefs.CORE_CREATED)) {
            this.consentRecordCreated = Instant.ofEpochMilli(this.bbv.readBits36(FieldDefs.CORE_CREATED) * 100L);
        }
        return this.consentRecordCreated;
    }

    @Override
    public Instant getLastUpdated() {
        if (this.cache.add(FieldDefs.CORE_LAST_UPDATED)) {
            this.consentRecordLastUpdated = Instant.ofEpochMilli(this.bbv.readBits36(FieldDefs.CORE_LAST_UPDATED) * 100L);
        }
        return this.consentRecordLastUpdated;
    }

    @Override
    public int getCmpId() {
        if (this.cache.add(FieldDefs.CORE_CMP_ID)) {
            this.consentManagerProviderId = (short)this.bbv.readBits12(FieldDefs.CORE_CMP_ID);
        }
        return this.consentManagerProviderId;
    }

    @Override
    public int getCmpVersion() {
        if (this.cache.add(FieldDefs.CORE_CMP_VERSION)) {
            this.consentManagerProviderVersion = (short)this.bbv.readBits12(FieldDefs.CORE_CMP_VERSION);
        }
        return this.consentManagerProviderVersion;
    }

    @Override
    public int getConsentScreen() {
        if (this.cache.add(FieldDefs.CORE_CONSENT_SCREEN)) {
            this.consentScreen = this.bbv.readBits6(FieldDefs.CORE_CONSENT_SCREEN);
        }
        return this.consentScreen;
    }

    @Override
    public String getConsentLanguage() {
        if (this.cache.add(FieldDefs.CORE_CONSENT_LANGUAGE)) {
            this.consentLanguage = this.bbv.readStr2(FieldDefs.CORE_CONSENT_LANGUAGE);
        }
        return this.consentLanguage;
    }

    @Override
    public int getVendorListVersion() {
        if (this.cache.add(FieldDefs.CORE_VENDOR_LIST_VERSION)) {
            this.vendorListVersion = (short)this.bbv.readBits12(FieldDefs.CORE_VENDOR_LIST_VERSION);
        }
        return this.vendorListVersion;
    }

    @Override
    public IntIterable getPurposesConsent() {
        if (this.cache.add(FieldDefs.CORE_PURPOSES_CONSENT)) {
            this.purposesConsent = TCStringV2.fillBitSet(this.bbv, FieldDefs.CORE_PURPOSES_CONSENT);
        }
        return this.purposesConsent;
    }

    @Override
    public IntIterable getVendorConsent() {
        if (this.cache.add(FieldDefs.CORE_VENDOR_BITRANGE_FIELD)) {
            this.vendorConsents = TCStringV2.fillVendors(this.bbv, FieldDefs.CORE_VENDOR_MAX_VENDOR_ID, FieldDefs.CORE_VENDOR_BITRANGE_FIELD);
        }
        return this.vendorConsents;
    }

    @Override
    public boolean getDefaultVendorConsent() {
        return false;
    }

    @Override
    public int getTcfPolicyVersion() {
        if (this.cache.add(FieldDefs.CORE_TCF_POLICY_VERSION)) {
            this.policyVersion = this.bbv.readBits6(FieldDefs.CORE_TCF_POLICY_VERSION);
        }
        return this.policyVersion;
    }

    @Override
    public boolean isServiceSpecific() {
        if (this.cache.add(FieldDefs.CORE_IS_SERVICE_SPECIFIC)) {
            this.isServiceSpecific = this.bbv.readBits1(FieldDefs.CORE_IS_SERVICE_SPECIFIC);
        }
        return this.isServiceSpecific;
    }

    @Override
    public boolean getUseNonStandardStacks() {
        if (this.cache.add(FieldDefs.CORE_USE_NON_STANDARD_STOCKS)) {
            this.useNonStandardStacks = this.bbv.readBits1(FieldDefs.CORE_USE_NON_STANDARD_STOCKS);
        }
        return this.useNonStandardStacks;
    }

    @Override
    public IntIterable getSpecialFeatureOptIns() {
        if (this.cache.add(FieldDefs.CORE_SPECIAL_FEATURE_OPT_INS)) {
            this.specialFeaturesOptInts = TCStringV2.fillBitSet(this.bbv, FieldDefs.CORE_SPECIAL_FEATURE_OPT_INS);
        }
        return this.specialFeaturesOptInts;
    }

    @Override
    public IntIterable getPurposesLITransparency() {
        if (this.cache.add(FieldDefs.CORE_PURPOSES_LI_TRANSPARENCY)) {
            this.purposesLITransparency = TCStringV2.fillBitSet(this.bbv, FieldDefs.CORE_PURPOSES_LI_TRANSPARENCY);
        }
        return this.purposesLITransparency;
    }

    @Override
    public boolean getPurposeOneTreatment() {
        if (this.cache.add(FieldDefs.CORE_PURPOSE_ONE_TREATMENT)) {
            this.isPurposeOneTreatment = this.bbv.readBits1(FieldDefs.CORE_PURPOSE_ONE_TREATMENT);
        }
        return this.isPurposeOneTreatment;
    }

    @Override
    public String getPublisherCC() {
        if (this.cache.add(FieldDefs.CORE_PUBLISHER_CC)) {
            this.publisherCountryCode = this.bbv.readStr2(FieldDefs.CORE_PUBLISHER_CC);
        }
        return this.publisherCountryCode;
    }

    @Override
    public IntIterable getVendorLegitimateInterest() {
        if (this.cache.add(FieldDefs.CORE_VENDOR_LI_BITRANGE_FIELD)) {
            this.vendorLegitimateInterests = TCStringV2.fillVendors(this.bbv, FieldDefs.CORE_VENDOR_LI_MAX_VENDOR_ID, FieldDefs.CORE_VENDOR_LI_BITRANGE_FIELD);
        }
        return this.vendorLegitimateInterests;
    }

    @Override
    public List<PublisherRestriction> getPublisherRestrictions() {
        if (this.cache.add(FieldDefs.CORE_PUB_RESTRICTION_ENTRY)) {
            this.publisherRestrictions = new ArrayList<PublisherRestriction>();
            this.fillPublisherRestrictions(this.publisherRestrictions, FieldDefs.CORE_NUM_PUB_RESTRICTION.getOffset(this.bbv), this.bbv);
        }
        return this.publisherRestrictions;
    }

    @Override
    public IntIterable getAllowedVendors() {
        if (this.cache.add(FieldDefs.AV_VENDOR_BITRANGE_FIELD)) {
            this.allowedVendors = BitSetIntIterable.EMPTY;
            BitReader dvBbv = this.getSegment(SegmentType.ALLOWED_VENDOR);
            if (dvBbv != null) {
                this.allowedVendors = TCStringV2.fillVendors(dvBbv, FieldDefs.AV_MAX_VENDOR_ID, FieldDefs.AV_VENDOR_BITRANGE_FIELD);
            }
        }
        return this.allowedVendors;
    }

    @Override
    public IntIterable getDisclosedVendors() {
        if (this.cache.add(FieldDefs.DV_VENDOR_BITRANGE_FIELD)) {
            this.disclosedVendors = BitSetIntIterable.EMPTY;
            BitReader dvBbv = this.getSegment(SegmentType.DISCLOSED_VENDOR);
            if (dvBbv != null) {
                this.disclosedVendors = TCStringV2.fillVendors(dvBbv, FieldDefs.DV_MAX_VENDOR_ID, FieldDefs.DV_VENDOR_BITRANGE_FIELD);
            }
        }
        return this.disclosedVendors;
    }

    @Override
    public IntIterable getPubPurposesLITransparency() {
        if (this.cache.add(FieldDefs.PPTC_PUB_PURPOSES_LI_TRANSPARENCY)) {
            this.publisherPurposesLITransparency = BitSetIntIterable.EMPTY;
            BitReader dvBbv = this.getSegment(SegmentType.PUBLISHER_TC);
            if (dvBbv != null) {
                this.publisherPurposesLITransparency = TCStringV2.fillBitSet(dvBbv, FieldDefs.PPTC_PUB_PURPOSES_LI_TRANSPARENCY);
            }
        }
        return this.publisherPurposesLITransparency;
    }

    @Override
    public IntIterable getCustomPurposesConsent() {
        if (this.cache.add(FieldDefs.PPTC_CUSTOM_PURPOSES_CONSENT)) {
            this.customPurposesConsent = BitSetIntIterable.EMPTY;
            BitReader dvBbv = this.getSegment(SegmentType.PUBLISHER_TC);
            if (dvBbv != null) {
                this.customPurposesConsent = TCStringV2.fillBitSet(dvBbv, FieldDefs.PPTC_CUSTOM_PURPOSES_CONSENT);
            }
        }
        return this.customPurposesConsent;
    }

    @Override
    public IntIterable getCustomPurposesLITransparency() {
        if (this.cache.add(FieldDefs.PPTC_CUSTOM_PURPOSES_LI_TRANSPARENCY)) {
            this.customPurposesLITransparency = BitSetIntIterable.EMPTY;
            BitReader dvBbv = this.getSegment(SegmentType.PUBLISHER_TC);
            if (dvBbv != null) {
                this.customPurposesLITransparency = TCStringV2.fillBitSet(dvBbv, FieldDefs.PPTC_CUSTOM_PURPOSES_LI_TRANSPARENCY);
            }
        }
        return this.customPurposesLITransparency;
    }

    public int hashCode() {
        return Objects.hash(this.getAllowedVendors(), this.getConsentLanguage(), this.getCmpId(), this.getCmpVersion(), this.getCreated(), this.getLastUpdated(), this.getConsentScreen(), this.getCustomPurposesConsent(), this.getCustomPurposesLITransparency(), this.getDisclosedVendors(), this.getPurposeOneTreatment(), this.isServiceSpecific(), this.getTcfPolicyVersion(), this.getPublisherCC(), this.getPubPurposesConsent(), this.getPubPurposesLITransparency(), this.getPublisherRestrictions(), this.getPurposesConsent(), this.getPurposesLITransparency(), this.getSpecialFeatureOptIns(), this.getUseNonStandardStacks(), this.getVendorConsent(), this.getVendorLegitimateInterest(), this.getVendorListVersion(), this.getVersion());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TCStringV2 other = (TCStringV2)obj;
        return Objects.equals(this.getAllowedVendors(), other.getAllowedVendors()) && Objects.equals(this.getConsentLanguage(), other.getConsentLanguage()) && this.getCmpId() == other.getCmpId() && this.getCmpVersion() == other.getCmpVersion() && Objects.equals(this.getCreated(), other.getCreated()) && Objects.equals(this.getLastUpdated(), other.getLastUpdated()) && this.getConsentScreen() == other.getConsentScreen() && Objects.equals(this.getCustomPurposesConsent(), other.getCustomPurposesConsent()) && Objects.equals(this.getCustomPurposesLITransparency(), other.getCustomPurposesLITransparency()) && Objects.equals(this.getDisclosedVendors(), other.getDisclosedVendors()) && this.getPurposeOneTreatment() == other.getPurposeOneTreatment() && this.isServiceSpecific() == other.isServiceSpecific() && this.getTcfPolicyVersion() == other.getTcfPolicyVersion() && Objects.equals(this.getPublisherCC(), other.getPublisherCC()) && Objects.equals(this.getPubPurposesConsent(), other.getPubPurposesConsent()) && Objects.equals(this.getPubPurposesLITransparency(), other.getPubPurposesLITransparency()) && Objects.equals(this.getPublisherRestrictions(), other.getPublisherRestrictions()) && Objects.equals(this.getPurposesConsent(), other.getPurposesConsent()) && Objects.equals(this.getPurposesLITransparency(), other.getPurposesLITransparency()) && Objects.equals(this.getSpecialFeatureOptIns(), other.getSpecialFeatureOptIns()) && this.getUseNonStandardStacks() == other.getUseNonStandardStacks() && Objects.equals(this.getVendorConsent(), other.getVendorConsent()) && Objects.equals(this.getVendorLegitimateInterest(), other.getVendorLegitimateInterest()) && this.getVendorListVersion() == other.getVendorListVersion() && this.getVersion() == other.getVersion();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TCStringV2 [getVersion()=");
        builder.append(this.getVersion());
        builder.append(", getCreated()=");
        builder.append(this.getCreated());
        builder.append(", getLastUpdated()=");
        builder.append(this.getLastUpdated());
        builder.append(", getCmpId()=");
        builder.append(this.getCmpId());
        builder.append(", getCmpVersion()=");
        builder.append(this.getCmpVersion());
        builder.append(", getConsentScreen()=");
        builder.append(this.getConsentScreen());
        builder.append(", getConsentLanguage()=");
        builder.append(this.getConsentLanguage());
        builder.append(", getVendorListVersion()=");
        builder.append(this.getVendorListVersion());
        builder.append(", getTcfPolicyVersion()=");
        builder.append(this.getTcfPolicyVersion());
        builder.append(", isServiceSpecific()=");
        builder.append(this.isServiceSpecific());
        builder.append(", getUseNonStandardStacks()=");
        builder.append(this.getUseNonStandardStacks());
        builder.append(", getSpecialFeatureOptIns()=");
        builder.append(this.getSpecialFeatureOptIns());
        builder.append(", getPurposesConsent()=");
        builder.append(this.getPurposesConsent());
        builder.append(", getPurposesLITransparency()=");
        builder.append(this.getPurposesLITransparency());
        builder.append(", getPurposeOneTreatment()=");
        builder.append(this.getPurposeOneTreatment());
        builder.append(", getPublisherCC()=");
        builder.append(this.getPublisherCC());
        builder.append(", getVendorConsent()=");
        builder.append(this.getVendorConsent());
        builder.append(", getVendorLegitimateInterest()=");
        builder.append(this.getVendorLegitimateInterest());
        builder.append(", getPublisherRestrictions()=");
        builder.append(this.getPublisherRestrictions());
        builder.append(", getDisclosedVendors()=");
        builder.append(this.getDisclosedVendors());
        builder.append(", getAllowedVendors()=");
        builder.append(this.getAllowedVendors());
        builder.append(", getPubPurposesConsent()=");
        builder.append(this.getPubPurposesConsent());
        builder.append(", getPubPurposesLITransparency()=");
        builder.append(this.getPubPurposesLITransparency());
        builder.append(", getCustomPurposesConsent()=");
        builder.append(this.getCustomPurposesConsent());
        builder.append(", getCustomPurposesLITransparency()=");
        builder.append(this.getCustomPurposesLITransparency());
        builder.append("]");
        return builder.toString();
    }
}

