/*
 * Decompiled with CFR 0.152.
 */
package com.iabtcf.utils;

import com.iabtcf.utils.BitReader;
import com.iabtcf.utils.FieldDefs;
import java.util.EnumMap;
import java.util.function.Function;

class LengthOffsetCache {
    private final BitReader bbv;
    private final EnumMap<FieldDefs, Integer> lengthCache = new EnumMap(FieldDefs.class);
    private final EnumMap<FieldDefs, Integer> offsetCache = new EnumMap(FieldDefs.class);

    public LengthOffsetCache(BitReader bbv) {
        this.bbv = bbv;
    }

    public Integer getLength(FieldDefs field, Function<BitReader, Integer> f) {
        return this.memoize(field, this.lengthCache, f);
    }

    public Integer getOffset(FieldDefs field, Function<BitReader, Integer> f) {
        return this.memoize(field, this.offsetCache, f);
    }

    private Integer memoize(FieldDefs field, EnumMap<FieldDefs, Integer> cache, Function<BitReader, Integer> f) {
        if (!field.isDynamic()) {
            return f.apply(this.bbv);
        }
        Integer rv = cache.get((Object)field);
        if (rv == null) {
            rv = f.apply(this.bbv);
            cache.put(field, rv);
        }
        return rv;
    }
}

