/*
 * Decompiled with CFR 0.152.
 */
package com.iabtcf.encoder;

import com.iabtcf.encoder.Bounds;
import com.iabtcf.utils.BitSetIntIterable;
import com.iabtcf.utils.FieldDefs;
import com.iabtcf.utils.IntIterable;
import com.iabtcf.utils.IntIterator;
import com.iabtcf.v2.RestrictionType;

public class PublisherRestrictionEntry {
    private final int purposeId;
    private final RestrictionType restrictionType;
    private final IntIterable vendors;

    private PublisherRestrictionEntry(int purposeId, RestrictionType restrictionType, IntIterable vendors) {
        if (purposeId <= 0) {
            throw new IllegalArgumentException("purposeId must be positive: " + purposeId);
        }
        this.purposeId = Bounds.checkBounds(purposeId, FieldDefs.PURPOSE_ID);
        this.restrictionType = restrictionType;
        this.vendors = vendors;
    }

    public int getPurposeId() {
        return this.purposeId;
    }

    public RestrictionType getRestrictionType() {
        return this.restrictionType;
    }

    public IntIterable getVendors() {
        return this.vendors;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(PublisherRestrictionEntry prototype) {
        return new Builder(prototype);
    }

    public static Builder newBuilder(Builder prototype) {
        return new Builder(prototype);
    }

    public static class Builder {
        private int purposeId;
        private RestrictionType restrictionType;
        private final BitSetIntIterable.Builder vendors = BitSetIntIterable.newBuilder();

        public Builder() {
        }

        public Builder(PublisherRestrictionEntry prototype) {
            this.purposeId = prototype.purposeId;
            this.restrictionType = prototype.restrictionType;
            this.vendors.add(prototype.vendors);
        }

        public Builder(Builder prototype) {
            this.purposeId = prototype.purposeId;
            this.restrictionType = prototype.restrictionType;
            this.vendors.add(prototype.vendors);
        }

        public Builder purposeId(int purposeId) {
            this.purposeId = purposeId;
            return this;
        }

        public Builder restrictionType(RestrictionType restrictionType) {
            this.restrictionType = restrictionType;
            return this;
        }

        public Builder addVendor(int vendor) {
            if (vendor < 1) {
                throw new IllegalArgumentException("vendor id must be > 0: " + vendor);
            }
            this.vendors.add(vendor);
            return this;
        }

        public Builder addVendor(int ... vendors) {
            for (int i = 0; i < vendors.length; ++i) {
                this.addVendor(vendors[i]);
            }
            return this;
        }

        public Builder addVendor(IntIterable vendors) {
            IntIterator ii = vendors.intIterator();
            while (ii.hasNext()) {
                this.addVendor(ii.nextInt());
            }
            return this;
        }

        public Builder clearVendors() {
            this.vendors.clear();
            return this;
        }

        public PublisherRestrictionEntry build() {
            return new PublisherRestrictionEntry(this.purposeId, this.restrictionType, (IntIterable)this.vendors.build());
        }
    }
}

