/*
 * Decompiled with CFR 0.152.
 */
package com.iabtcf.encoder;

import com.iabtcf.encoder.BitWriter;
import com.iabtcf.utils.FieldDefs;
import com.iabtcf.utils.IntIterable;
import com.iabtcf.utils.IntIterator;
import java.util.BitSet;
import java.util.Iterator;

class VendorFieldEncoder {
    private final BitSet vendors;
    private int maxVendorId;
    private boolean defaultConsent;
    private boolean emitRangeEncoding;
    private boolean emitMaxVendorId;
    private boolean emitIsRangeEncoding;

    public VendorFieldEncoder() {
        this(new BitSet(), 0, false, false, true, true);
    }

    public VendorFieldEncoder(VendorFieldEncoder prototype) {
        this(prototype.vendors.length() == 0 ? new BitSet() : prototype.vendors.get(0, prototype.vendors.length()), prototype.maxVendorId, prototype.defaultConsent, prototype.emitRangeEncoding, prototype.emitMaxVendorId, prototype.emitIsRangeEncoding);
    }

    private VendorFieldEncoder(BitSet vendors, int maxVendorId, boolean defaultConsent, boolean emitRangeEncoding, boolean emitMaxVendorId, boolean emitIsRangeEncoding) {
        this.vendors = vendors;
        this.maxVendorId = maxVendorId;
        this.defaultConsent = defaultConsent;
        this.emitRangeEncoding = emitRangeEncoding;
        this.emitMaxVendorId = emitMaxVendorId;
        this.emitIsRangeEncoding = emitIsRangeEncoding;
    }

    public VendorFieldEncoder emitRangeEncoding(boolean value) {
        this.emitRangeEncoding = value;
        return this;
    }

    public VendorFieldEncoder emitMaxVendorId(boolean value) {
        this.emitMaxVendorId = value;
        return this;
    }

    public VendorFieldEncoder emitIsRangeEncoding(boolean value) {
        this.emitIsRangeEncoding = value;
        return this;
    }

    public VendorFieldEncoder defaultConsent(boolean value) {
        this.defaultConsent = value;
        return this;
    }

    public VendorFieldEncoder add(int vendorId) {
        if (vendorId <= 0) {
            throw new IndexOutOfBoundsException("vendorId < 1: " + vendorId);
        }
        this.vendors.set(vendorId - 1);
        return this;
    }

    public VendorFieldEncoder add(Iterable<Integer> vendorIds) {
        Iterator<Integer> i = vendorIds.iterator();
        while (i.hasNext()) {
            this.add((int)i.next());
        }
        return this;
    }

    public VendorFieldEncoder add(int ... vendorIds) {
        for (int i = 0; i < vendorIds.length; ++i) {
            this.add(vendorIds[i]);
        }
        return this;
    }

    public VendorFieldEncoder add(IntIterable ii) {
        IntIterator i = ii.intIterator();
        while (i.hasNext()) {
            this.add(i.nextInt());
        }
        return this;
    }

    VendorFieldEncoder setMaxVendorId(int maxVendorId) {
        this.maxVendorId = maxVendorId;
        return this;
    }

    public BitWriter buildV1() {
        return this.build(true);
    }

    public BitWriter build() {
        return this.build(false);
    }

    private BitWriter build(boolean emitDefaultConsent) {
        int idxClr;
        BitWriter bv = new BitWriter();
        if (this.vendors.length() == 0) {
            bv.writeV(0L, FieldDefs.CORE_VENDOR_MAX_VENDOR_ID);
            bv.write(false, FieldDefs.CORE_VENDOR_IS_RANGE_ENCODING);
            return bv;
        }
        this.maxVendorId = Math.max(this.vendors.length(), this.maxVendorId);
        BitWriter rangeBits = new BitWriter();
        int idxSet = this.vendors.get(0) ? 0 : this.vendors.nextSetBit(0);
        int numEntries = 0;
        do {
            int length;
            if ((length = (idxClr = this.vendors.nextClearBit(idxSet)) - idxSet) == 1) {
                rangeBits.write(false, FieldDefs.CORE_VENDOR_IS_RANGE_ENCODING);
                rangeBits.writeV(idxSet + 1, FieldDefs.START_OR_ONLY_VENDOR_ID);
            } else {
                rangeBits.write(true, FieldDefs.CORE_VENDOR_IS_RANGE_ENCODING);
                rangeBits.writeV(idxSet + 1, FieldDefs.START_OR_ONLY_VENDOR_ID);
                rangeBits.writeV(idxClr, FieldDefs.END_VENDOR_ID);
            }
            ++numEntries;
        } while ((idxSet = this.vendors.nextSetBit(idxClr)) > 0 && (rangeBits.length() < this.vendors.length() || this.emitRangeEncoding));
        if (this.emitMaxVendorId) {
            bv.writeV(this.maxVendorId, FieldDefs.CORE_VENDOR_MAX_VENDOR_ID);
        }
        if (rangeBits.length() < this.vendors.length() || this.emitRangeEncoding) {
            if (this.emitIsRangeEncoding) {
                bv.write(true, FieldDefs.IS_A_RANGE);
            }
            if (emitDefaultConsent) {
                bv.write(this.defaultConsent, FieldDefs.V1_VENDOR_DEFAULT_CONSENT);
            }
            bv.writeV(numEntries, FieldDefs.NUM_ENTRIES);
            bv.write(rangeBits);
        } else {
            bv.write(false, FieldDefs.IS_A_RANGE);
            int rem = this.vendors.length() % 64;
            if (rem == 0) {
                rem = 64;
            }
            long[] bits = this.vendors.toLongArray();
            for (int i = 0; i < bits.length - 1; ++i) {
                bv.write(Long.reverse(bits[i]), 64);
            }
            bv.write(Long.reverse(bits[bits.length - 1]) >>> 64 - rem, rem);
            bv.enforcePrecision(this.maxVendorId - this.vendors.length());
        }
        return bv;
    }
}

