/*
 * Decompiled with CFR 0.152.
 */
package com.iabtcf.encoder;

import com.iabtcf.encoder.Bounds;
import com.iabtcf.encoder.OfLongIterable;
import com.iabtcf.utils.FieldDefs;
import com.iabtcf.utils.IntIterable;
import com.iabtcf.utils.IntIterator;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Base64;
import java.util.BitSet;
import java.util.PrimitiveIterator;

class BitWriter {
    private static final long[] LONG_MASKS = new long[65];
    private final OfLongIterable buffer = new OfLongIterable();
    private int bitsRemaining = 64;
    private long pending = 0L;
    private int precision = 0;

    public BitWriter() {
        this(0);
    }

    public BitWriter(int precision) {
        if (precision < 0) {
            throw new IllegalArgumentException("precision must be non-negative");
        }
        this.precision = precision;
    }

    public void write(boolean value) {
        this.write(value ? 1L : 0L, 1);
    }

    public void write(boolean data, FieldDefs field) {
        assert (field.getLength() == 1);
        this.write(data);
    }

    public void write(String str) {
        assert (Charset.forName("US-ASCII").newEncoder().canEncode(str));
        byte[] b = str.toUpperCase().getBytes(StandardCharsets.US_ASCII);
        for (int i = 0; i < b.length; ++i) {
            this.writeV(b[i] - 65, FieldDefs.CHAR);
        }
    }

    public void write(String str, FieldDefs field) {
        assert (field.getLength() / FieldDefs.CHAR.getLength() == str.length());
        this.write(str);
    }

    public void write(IntIterable of, FieldDefs field) {
        this.write(of, field.getLength());
    }

    public void write(Instant i, FieldDefs field) {
        this.write(i.toEpochMilli() / 100L, field);
    }

    public void write(IntIterable of, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be non-negative");
        }
        BitWriter bw = new BitWriter(length);
        BitSet bs = new BitSet();
        IntIterator i = of.intIterator();
        while (i.hasNext()) {
            int nextInt = i.nextInt();
            if (nextInt <= 0) {
                throw new IndexOutOfBoundsException("invalid index: " + nextInt);
            }
            if (nextInt > length) continue;
            bs.set(nextInt - 1);
        }
        for (int i2 = 0; i2 < length; ++i2) {
            bw.write(bs.get(i2));
        }
        this.write(bw);
    }

    public void write(Instant i) {
        this.write(i, FieldDefs.TIMESTAMP);
    }

    public void write(long data, FieldDefs field) {
        this.write(data, field.getLength());
    }

    public void writeV(long i, FieldDefs field) {
        Bounds.checkBounds(i, field);
        this.write(i, field);
    }

    public void write(long data, int length) {
        if (length < 0 || length > 64) {
            throw new IllegalArgumentException("length is invalid: " + length);
        }
        data &= LONG_MASKS[length];
        this.bitsRemaining -= length;
        this.precision -= length;
        if (this.bitsRemaining >= 0) {
            this.pending |= data << this.bitsRemaining;
        } else {
            this.buffer.add(this.pending |= data >>> -this.bitsRemaining);
            this.bitsRemaining += 64;
            this.pending = data << this.bitsRemaining;
        }
    }

    public void write(BitWriter bw) {
        PrimitiveIterator.OfLong i = bw.buffer.longIterator();
        while (i.hasNext()) {
            this.write(i.nextLong(), 64);
        }
        this.write(bw.pending >>> bw.bitsRemaining, 64 - bw.bitsRemaining);
        this.enforcePrecision(bw.precision);
    }

    public int length() {
        return this.buffer.size() * 64 + (64 - this.bitsRemaining) + (this.precision >= 0 ? this.precision : 0);
    }

    public byte[] toByteArray() {
        this.enforcePrecision();
        int bytesToWrite = 71 - this.bitsRemaining >> 3;
        ByteBuffer bb = ByteBuffer.allocate(this.buffer.size() * 8 + bytesToWrite);
        PrimitiveIterator.OfLong li = this.buffer.longIterator();
        while (li.hasNext()) {
            bb.putLong(li.nextLong());
        }
        for (int i = 0; i < bytesToWrite; ++i) {
            bb.put((byte)(this.pending >> 56 - i * 8));
        }
        return bb.array();
    }

    protected void enforcePrecision(int p) {
        if (p <= 0) {
            return;
        }
        for (int i = 0; i < p / 64; ++i) {
            this.write(0L, 64);
        }
        this.write(0L, p % 64);
    }

    private void enforcePrecision() {
        this.enforcePrecision(this.precision);
        this.precision = 0;
    }

    public String toBase64() {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(this.toByteArray());
    }

    static {
        for (int i = 0; i < 64; ++i) {
            BitWriter.LONG_MASKS[i] = (1L << i) - 1L;
        }
        BitWriter.LONG_MASKS[64] = -1L;
    }
}

