/*
 * Decompiled with CFR 0.152.
 */
package com.iabtcf.encoder;

import com.iabtcf.encoder.PublisherRestrictionEntry;
import com.iabtcf.encoder.exceptions.ValueOverflowException;
import com.iabtcf.utils.BitSetIntIterable;
import com.iabtcf.utils.FieldDefs;
import java.util.List;

class Bounds {
    Bounds() {
    }

    public static List<PublisherRestrictionEntry> checkBounds(List<PublisherRestrictionEntry> value) {
        Bounds.checkBounds(value.size(), (1L << FieldDefs.CORE_NUM_PUB_RESTRICTION.getLength()) - 1L, FieldDefs.CORE_NUM_PUB_RESTRICTION);
        return value;
    }

    public static BitSetIntIterable.Builder checkBounds(BitSetIntIterable.Builder values, FieldDefs field) {
        Bounds.checkBounds(values.max(), (1L << field.getLength()) - 1L, field);
        return values;
    }

    public static BitSetIntIterable.Builder checkBoundsBits(BitSetIntIterable.Builder values, FieldDefs field) {
        Bounds.checkBounds(values.max(), field.getLength(), field);
        return values;
    }

    public static int checkBounds(int value, FieldDefs field) {
        if (field.getLength() > 32) {
            throw new ValueOverflowException(32L, field.getLength());
        }
        Bounds.checkBounds((long)value & 0xFFFFFFFFL, field);
        return value;
    }

    public static long checkBounds(long value, FieldDefs field) {
        int length = field.getLength();
        if (length > 64) {
            throw new ValueOverflowException(64L, length);
        }
        if (length == 64) {
            return value;
        }
        return Bounds.checkBounds(value, (1L << length) - 1L, field);
    }

    private static long checkBounds(long value, long max, FieldDefs field) {
        if (Long.compareUnsigned(value, max) > 0) {
            throw new ValueOverflowException(value, max, field);
        }
        return value;
    }
}

