/*
 * Decompiled with CFR 0.152.
 */
package com.iabtcf.encoder;

import com.iabtcf.decoder.DecoderOption;
import com.iabtcf.decoder.TCString;
import com.iabtcf.encoder.BitWriter;
import com.iabtcf.encoder.Bounds;
import com.iabtcf.encoder.PublisherRestrictionEntry;
import com.iabtcf.encoder.VendorFieldEncoder;
import com.iabtcf.encoder.exceptions.ValueOverflowException;
import com.iabtcf.utils.BitSetIntIterable;
import com.iabtcf.utils.FieldDefs;
import com.iabtcf.utils.IntIterable;
import com.iabtcf.v2.SegmentType;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface TCStringEncoder {
    public String encode() throws IllegalArgumentException, ValueOverflowException;

    public TCString toTCString() throws IllegalArgumentException, ValueOverflowException;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder tcStringEncoder) {
        return new Builder(tcStringEncoder);
    }

    public static Builder newBuilder(TCString tcString) {
        return new Builder(tcString);
    }

    public static class Builder
    implements TCStringEncoder {
        private int version = 0;
        private Instant created;
        private Instant updated = this.created = Instant.now(Clock.systemUTC());
        private int cmpId = 0;
        private int cmpVersion = 0;
        private int consentScreen = 0;
        private String consentLanguage = "EN";
        private int vendorListVersion = 0;
        private BitSetIntIterable.Builder purposesConsent = BitSetIntIterable.newBuilder();
        private BitSetIntIterable.Builder vendorConsent = BitSetIntIterable.newBuilder();
        private int tcfPolicyVersion = 0;
        private boolean isServiceSpecific = false;
        private boolean useNonStandardStacks = false;
        private BitSetIntIterable.Builder specialFeatureOptIns = BitSetIntIterable.newBuilder();
        private BitSetIntIterable.Builder purposesLITransparency = BitSetIntIterable.newBuilder();
        private boolean purposeOneTreatment = false;
        private String publisherCC = "US";
        private BitSetIntIterable.Builder vendorLegitimateInterest = BitSetIntIterable.newBuilder();
        private BitSetIntIterable.Builder disclosedVendors = BitSetIntIterable.newBuilder();
        private BitSetIntIterable.Builder allowedVendors = BitSetIntIterable.newBuilder();
        private BitSetIntIterable.Builder pubPurposesConsent = BitSetIntIterable.newBuilder();
        private BitSetIntIterable.Builder customPurposesConsent = BitSetIntIterable.newBuilder();
        private BitSetIntIterable.Builder customPurposesLITransparency = BitSetIntIterable.newBuilder();
        private BitSetIntIterable.Builder pubPurposesLITransparency = BitSetIntIterable.newBuilder();
        private boolean defaultConsent = false;
        private final List<PublisherRestrictionEntry> publisherRestrictions = new ArrayList<PublisherRestrictionEntry>();

        private Builder() {
        }

        private Builder(Builder prototype) {
            this.version = prototype.version;
            this.created = prototype.created;
            this.updated = prototype.updated;
            this.cmpId = prototype.cmpId;
            this.cmpVersion = prototype.cmpVersion;
            this.consentScreen = prototype.consentScreen;
            this.consentLanguage = prototype.consentLanguage;
            this.vendorListVersion = prototype.vendorListVersion;
            this.purposesConsent = prototype.purposesConsent;
            this.vendorConsent = prototype.vendorConsent;
            this.tcfPolicyVersion = prototype.tcfPolicyVersion;
            this.isServiceSpecific = prototype.isServiceSpecific;
            this.useNonStandardStacks = prototype.useNonStandardStacks;
            this.specialFeatureOptIns = prototype.specialFeatureOptIns;
            this.purposesLITransparency = prototype.purposesLITransparency;
            this.purposeOneTreatment = prototype.purposeOneTreatment;
            this.publisherCC = prototype.publisherCC;
            this.vendorLegitimateInterest = prototype.vendorLegitimateInterest;
            this.disclosedVendors = prototype.disclosedVendors;
            this.allowedVendors = prototype.allowedVendors;
        }

        public Builder(TCString tcString) {
            this.version = tcString.getVersion();
            this.created = tcString.getCreated();
            this.updated = tcString.getLastUpdated();
            this.cmpId = tcString.getCmpId();
            this.cmpVersion = tcString.getCmpVersion();
            this.consentScreen = tcString.getConsentScreen();
            this.consentLanguage = tcString.getConsentLanguage();
            this.vendorListVersion = tcString.getVendorListVersion();
            this.purposesConsent = BitSetIntIterable.newBuilder((IntIterable)tcString.getPurposesConsent());
            this.vendorConsent = BitSetIntIterable.newBuilder((IntIterable)tcString.getVendorConsent());
            if (this.version != 1) {
                this.tcfPolicyVersion = tcString.getTcfPolicyVersion();
                this.isServiceSpecific = tcString.isServiceSpecific();
                this.useNonStandardStacks = tcString.getUseNonStandardStacks();
                this.specialFeatureOptIns = BitSetIntIterable.newBuilder((IntIterable)tcString.getSpecialFeatureOptIns());
                this.purposesLITransparency = BitSetIntIterable.newBuilder((IntIterable)tcString.getPurposesLITransparency());
                this.purposeOneTreatment = tcString.getPurposeOneTreatment();
                this.publisherCC = tcString.getPublisherCC();
                this.vendorLegitimateInterest = BitSetIntIterable.newBuilder((IntIterable)tcString.getVendorLegitimateInterest());
                this.disclosedVendors = BitSetIntIterable.newBuilder((IntIterable)tcString.getDisclosedVendors());
                this.allowedVendors = BitSetIntIterable.newBuilder((IntIterable)tcString.getAllowedVendors());
            }
        }

        public Builder version(int version) throws IllegalArgumentException {
            this.version = this.validateVersion(version);
            return this;
        }

        public Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public Builder lastUpdated(Instant updated) {
            this.updated = updated;
            return this;
        }

        public Builder cmpId(int cmpId) {
            this.cmpId = cmpId;
            return this;
        }

        public Builder cmpVersion(int cmpVersion) {
            this.cmpVersion = cmpVersion;
            return this;
        }

        public Builder consentScreen(int consentScreen) {
            this.consentScreen = consentScreen;
            return this;
        }

        public Builder consentLanguage(String consentLanguage) throws IllegalArgumentException {
            this.consentLanguage = this.validateString(consentLanguage, FieldDefs.CORE_CONSENT_LANGUAGE);
            return this;
        }

        public Builder vendorListVersion(int version) {
            this.vendorListVersion = version;
            return this;
        }

        public Builder addPurposesConsent(int purposesConsent) {
            this.purposesConsent.add(purposesConsent);
            return this;
        }

        public Builder addPurposesConsent(IntIterable purposesConsent) {
            this.purposesConsent.add(purposesConsent);
            return this;
        }

        public Builder clearPurposesConsent() {
            this.purposesConsent.clear();
            return this;
        }

        public Builder addVendorConsent(int vendorsConsent) {
            this.vendorConsent.add(vendorsConsent);
            return this;
        }

        public Builder addVendorConsent(IntIterable vendorsConsent) {
            this.vendorConsent.add(vendorsConsent);
            return this;
        }

        public Builder clearVendorConsent() {
            this.vendorConsent.clear();
            return this;
        }

        public Builder tcfPolicyVersion(int tcfPolicyVersion) {
            this.tcfPolicyVersion = tcfPolicyVersion;
            return this;
        }

        public Builder isServiceSpecific(boolean isServiceSpecific) {
            this.isServiceSpecific = isServiceSpecific;
            return this;
        }

        public Builder useNonStandardStacks(boolean useNonStandardStacks) {
            this.useNonStandardStacks = useNonStandardStacks;
            return this;
        }

        public Builder addSpecialFeatureOptIns(int specialFeatureOptIns) {
            this.specialFeatureOptIns.add(specialFeatureOptIns);
            return this;
        }

        public Builder addSpecialFeatureOptIns(IntIterable specialFeatureOptIns) {
            this.specialFeatureOptIns.add(specialFeatureOptIns);
            return this;
        }

        public Builder clearSpecialFeatureOptIns() {
            this.specialFeatureOptIns.clear();
            return this;
        }

        public Builder addPurposesLITransparency(int purposesLITransparency) {
            this.purposesLITransparency.add(purposesLITransparency);
            return this;
        }

        public Builder addPurposesLITransparency(IntIterable purposesLITransparency) {
            this.purposesLITransparency.add(purposesLITransparency);
            return this;
        }

        public Builder clearPurposesLITransparency() {
            this.purposesLITransparency.clear();
            return this;
        }

        public Builder purposeOneTreatment(boolean purposeOneTreatment) {
            this.purposeOneTreatment = purposeOneTreatment;
            return this;
        }

        public Builder publisherCC(String publisherCC) {
            this.publisherCC = this.validateString(publisherCC, FieldDefs.CORE_PUBLISHER_CC);
            return this;
        }

        public Builder addVendorLegitimateInterest(int vendorLegitimateInterest) {
            this.vendorLegitimateInterest.add(vendorLegitimateInterest);
            return this;
        }

        public Builder addVendorLegitimateInterest(IntIterable vendorLegitimateInterest) {
            this.vendorLegitimateInterest.add(vendorLegitimateInterest);
            return this;
        }

        public Builder clearVendorLegitimateInterest() {
            this.vendorLegitimateInterest.clear();
            return this;
        }

        public Builder addDisclosedVendors(int disclosedVendors) {
            this.disclosedVendors.add(disclosedVendors);
            return this;
        }

        public Builder addDisclosedVendors(IntIterable disclosedVendors) {
            this.disclosedVendors.add(disclosedVendors);
            return this;
        }

        public Builder clearDisclosedVendors() {
            this.disclosedVendors.clear();
            return this;
        }

        public Builder addAllowedVendors(int allowedVendors) {
            this.allowedVendors.add(allowedVendors);
            return this;
        }

        public Builder addAllowedVendors(IntIterable allowedVendors) {
            this.allowedVendors.add(allowedVendors);
            return this;
        }

        public Builder clearAllowedVendors() {
            this.allowedVendors.clear();
            return this;
        }

        public Builder addPubPurposesConsent(int pubPurposesConsent) {
            this.pubPurposesConsent.add(pubPurposesConsent);
            return this;
        }

        public Builder addPubPurposesConsent(IntIterable pubPurposesConsent) {
            this.pubPurposesConsent.add(pubPurposesConsent);
            return this;
        }

        public Builder clearPubPurposesConsent() {
            this.pubPurposesConsent.clear();
            return this;
        }

        public Builder addCustomPurposesConsent(int customPurposesConsent) {
            this.customPurposesConsent.add(customPurposesConsent);
            return this;
        }

        public Builder addCustomPurposesConsent(IntIterable customPurposesConsent) {
            this.customPurposesConsent.add(customPurposesConsent);
            return this;
        }

        public Builder clearCustomPurposesConsent() {
            this.customPurposesConsent.clear();
            return this;
        }

        public Builder addCustomPurposesLITransparency(int customPurposesLITransparency) {
            this.customPurposesLITransparency.add(customPurposesLITransparency);
            return this;
        }

        public Builder addCustomPurposesLITransparency(IntIterable customPurposesLITransparency) {
            this.customPurposesLITransparency.add(customPurposesLITransparency);
            return this;
        }

        public Builder clearCustomPurposesLITransparency() {
            this.customPurposesLITransparency.clear();
            return this;
        }

        public Builder addPubPurposesLITransparency(int pubPurposesLITransparency) {
            this.pubPurposesLITransparency.add(pubPurposesLITransparency);
            return this;
        }

        public Builder addPubPurposesLITransparency(IntIterable pubPurposesLITransparency) {
            this.pubPurposesLITransparency.add(pubPurposesLITransparency);
            return this;
        }

        public Builder clearPubPurposesLITransparency() {
            this.pubPurposesLITransparency.clear();
            return this;
        }

        public Builder addPublisherRestrictionEntry(PublisherRestrictionEntry entry) {
            this.publisherRestrictions.add(entry);
            return this;
        }

        public Builder addPublisherRestrictionEntry(PublisherRestrictionEntry ... entries) {
            for (int i = 0; i < entries.length; ++i) {
                this.addPublisherRestrictionEntry(entries[i]);
            }
            return this;
        }

        public Builder addPublisherRestrictionEntry(Collection<PublisherRestrictionEntry> entries) {
            this.publisherRestrictions.addAll(entries);
            return this;
        }

        public Builder clearPublisherRestrictionEntry() {
            this.publisherRestrictions.clear();
            return this;
        }

        public Builder defaultConsent(boolean defaultConsent) {
            this.defaultConsent = defaultConsent;
            return this;
        }

        @Override
        public String encode() {
            if (this.version == 1) {
                return new TCStringEncoderV1(this).encode();
            }
            return new TCStringEncoderV2(this).encode();
        }

        @Override
        public TCString toTCString() {
            return TCString.decode((String)this.encode(), (DecoderOption[])new DecoderOption[0]);
        }

        private String validateString(String str, FieldDefs field) {
            if (str.length() != field.getLength() / FieldDefs.CHAR.getLength()) {
                throw new IllegalArgumentException(str + " must be length 2 but is " + str.length());
            }
            return str.toUpperCase();
        }

        private int validateVersion(int version) {
            if (version < 1 || version > 2) {
                throw new IllegalArgumentException(version + " not supported");
            }
            return version;
        }
    }

    public static class TCStringEncoderV2
    implements TCStringEncoder {
        private final int version;
        private final Instant created;
        private final Instant updated;
        private final int cmpId;
        private final int cmpVersion;
        private final int consentScreen;
        private final String consentLanguage;
        private final int vendorListVersion;
        private final IntIterable purposesConsent;
        private final IntIterable vendorsConsent;
        private final int tcfPolicyVersion;
        private final boolean isServiceSpecific;
        private final boolean useNonStandardStacks;
        private final IntIterable specialFeatureOptIns;
        private final IntIterable purposesLITransparency;
        private final boolean purposeOneTreatment;
        private final String publisherCC;
        private final IntIterable vendorLegitimateInterest;
        private final IntIterable disclosedVendors;
        private final IntIterable allowedVendors;
        private final IntIterable pubPurposesConsent;
        private final int numberOfCustomPurposes;
        private final IntIterable customPurposesConsent;
        private final IntIterable customPurposesLITransparency;
        private final IntIterable pubPurposesLITransparency;
        private final List<PublisherRestrictionEntry> publisherRestrictions;

        private TCStringEncoderV2(Builder builder) throws IllegalArgumentException, ValueOverflowException {
            if (builder.version != 2) {
                throw new IllegalArgumentException("version must be 2: " + builder.version);
            }
            this.version = Bounds.checkBounds(builder.version, FieldDefs.CORE_CMP_VERSION);
            this.created = Objects.requireNonNull(builder.created);
            this.updated = Objects.requireNonNull(builder.updated);
            this.cmpId = Bounds.checkBounds(builder.cmpId, FieldDefs.CORE_CMP_ID);
            this.cmpVersion = Bounds.checkBounds(builder.cmpVersion, FieldDefs.CORE_CMP_VERSION);
            this.consentScreen = Bounds.checkBounds(builder.consentScreen, FieldDefs.CORE_CONSENT_SCREEN);
            this.consentLanguage = Objects.requireNonNull(builder.consentLanguage);
            this.vendorListVersion = Bounds.checkBounds(builder.vendorListVersion, FieldDefs.CORE_VENDOR_LIST_VERSION);
            this.purposesConsent = Bounds.checkBoundsBits(builder.purposesConsent, FieldDefs.CORE_PURPOSES_CONSENT).build();
            this.vendorsConsent = Bounds.checkBounds(builder.vendorConsent, FieldDefs.CORE_VENDOR_MAX_VENDOR_ID).build();
            this.tcfPolicyVersion = Bounds.checkBounds(builder.tcfPolicyVersion, FieldDefs.CORE_TCF_POLICY_VERSION);
            this.isServiceSpecific = builder.isServiceSpecific;
            this.useNonStandardStacks = builder.useNonStandardStacks;
            this.specialFeatureOptIns = Bounds.checkBoundsBits(builder.specialFeatureOptIns, FieldDefs.CORE_SPECIAL_FEATURE_OPT_INS).build();
            this.purposesLITransparency = Bounds.checkBoundsBits(builder.purposesLITransparency, FieldDefs.CORE_PURPOSES_LI_TRANSPARENCY).build();
            this.purposeOneTreatment = builder.purposeOneTreatment;
            this.publisherCC = Objects.requireNonNull(builder.publisherCC);
            this.vendorLegitimateInterest = Bounds.checkBounds(builder.vendorLegitimateInterest, FieldDefs.CORE_VENDOR_MAX_VENDOR_ID).build();
            this.disclosedVendors = Bounds.checkBounds(builder.disclosedVendors, FieldDefs.CORE_VENDOR_MAX_VENDOR_ID).build();
            this.allowedVendors = Bounds.checkBounds(builder.allowedVendors, FieldDefs.CORE_VENDOR_MAX_VENDOR_ID).build();
            this.pubPurposesLITransparency = Bounds.checkBoundsBits(builder.pubPurposesLITransparency, FieldDefs.PPTC_PUB_PURPOSES_LI_TRANSPARENCY).build();
            this.pubPurposesConsent = Bounds.checkBoundsBits(builder.pubPurposesConsent, FieldDefs.PPTC_PUB_PURPOSES_CONSENT).build();
            this.numberOfCustomPurposes = Bounds.checkBounds(Math.max(builder.customPurposesLITransparency.max(), builder.customPurposesConsent.max()), FieldDefs.PPTC_NUM_CUSTOM_PURPOSES);
            this.customPurposesLITransparency = builder.customPurposesLITransparency.build();
            this.customPurposesConsent = builder.customPurposesConsent.build();
            this.publisherRestrictions = Bounds.checkBounds(new ArrayList<PublisherRestrictionEntry>(builder.publisherRestrictions));
        }

        private String encodeSegment(SegmentType segmentType) {
            BitSetIntIterable intIterable = BitSetIntIterable.EMPTY;
            switch (segmentType) {
                case DISCLOSED_VENDOR: {
                    intIterable = this.disclosedVendors;
                    break;
                }
                case ALLOWED_VENDOR: {
                    intIterable = this.allowedVendors;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid segment type: " + segmentType);
                }
            }
            if (intIterable.isEmpty()) {
                return "";
            }
            BitWriter bitWriter = new BitWriter();
            bitWriter.write((long)segmentType.value(), FieldDefs.OOB_SEGMENT_TYPE);
            bitWriter.write(new VendorFieldEncoder().add((IntIterable)intIterable).build());
            return bitWriter.toBase64();
        }

        private String encodeDisclosedVendors() {
            return this.encodeSegment(SegmentType.DISCLOSED_VENDOR);
        }

        private String encodeAllowedVendors() {
            return this.encodeSegment(SegmentType.ALLOWED_VENDOR);
        }

        private String encodeCoreString() {
            BitWriter bitWriter = new BitWriter();
            bitWriter.write((long)this.version, FieldDefs.CORE_VERSION);
            bitWriter.write(this.created, FieldDefs.CORE_CREATED);
            bitWriter.write(this.updated, FieldDefs.CORE_LAST_UPDATED);
            bitWriter.write((long)this.cmpId, FieldDefs.CORE_CMP_ID);
            bitWriter.write((long)this.cmpVersion, FieldDefs.CORE_CMP_VERSION);
            bitWriter.write((long)this.consentScreen, FieldDefs.CORE_CONSENT_SCREEN);
            bitWriter.write(this.consentLanguage, FieldDefs.CORE_CONSENT_LANGUAGE);
            bitWriter.write((long)this.vendorListVersion, FieldDefs.CORE_VENDOR_LIST_VERSION);
            bitWriter.write((long)this.tcfPolicyVersion, FieldDefs.CORE_TCF_POLICY_VERSION);
            bitWriter.write(this.isServiceSpecific, FieldDefs.CORE_IS_SERVICE_SPECIFIC);
            bitWriter.write(this.useNonStandardStacks, FieldDefs.CORE_USE_NON_STANDARD_STOCKS);
            bitWriter.write(this.specialFeatureOptIns, FieldDefs.CORE_SPECIAL_FEATURE_OPT_INS);
            bitWriter.write(this.purposesConsent, FieldDefs.CORE_PURPOSES_CONSENT);
            bitWriter.write(this.purposesLITransparency, FieldDefs.CORE_PURPOSES_LI_TRANSPARENCY);
            bitWriter.write(this.purposeOneTreatment, FieldDefs.CORE_PURPOSE_ONE_TREATMENT);
            bitWriter.write(this.publisherCC, FieldDefs.CORE_PUBLISHER_CC);
            bitWriter.write(new VendorFieldEncoder().add(this.vendorsConsent).build());
            bitWriter.write(new VendorFieldEncoder().add(this.vendorLegitimateInterest).build());
            bitWriter.write((long)this.publisherRestrictions.size(), FieldDefs.CORE_NUM_PUB_RESTRICTION);
            for (PublisherRestrictionEntry pre : this.publisherRestrictions) {
                bitWriter.write((long)pre.getPurposeId(), FieldDefs.PURPOSE_ID);
                bitWriter.write((long)pre.getRestrictionType().ordinal(), FieldDefs.RESTRICTION_TYPE);
                VendorFieldEncoder v = new VendorFieldEncoder().emitRangeEncoding(true).emitMaxVendorId(false).emitIsRangeEncoding(false).add(pre.getVendors());
                bitWriter.write(v.build());
            }
            return bitWriter.toBase64();
        }

        private String encodePPTC() {
            if (this.pubPurposesConsent.isEmpty() && this.pubPurposesLITransparency.isEmpty() && this.numberOfCustomPurposes == 0) {
                return "";
            }
            BitWriter bitWriter = new BitWriter();
            bitWriter.write((long)SegmentType.PUBLISHER_TC.value(), FieldDefs.PPTC_SEGMENT_TYPE);
            bitWriter.write(this.pubPurposesConsent, FieldDefs.PPTC_PUB_PURPOSES_CONSENT);
            bitWriter.write(this.pubPurposesLITransparency, FieldDefs.PPTC_PUB_PURPOSES_LI_TRANSPARENCY);
            bitWriter.write((long)this.numberOfCustomPurposes, FieldDefs.PPTC_NUM_CUSTOM_PURPOSES);
            bitWriter.write(this.customPurposesConsent, this.numberOfCustomPurposes);
            bitWriter.write(this.customPurposesLITransparency, this.numberOfCustomPurposes);
            return bitWriter.toBase64();
        }

        @Override
        public String encode() {
            return Stream.of(this.encodeCoreString(), this.encodeDisclosedVendors(), this.encodeAllowedVendors(), this.encodePPTC()).filter(str -> str != null && !str.isEmpty()).collect(Collectors.joining("."));
        }

        @Override
        public TCString toTCString() {
            return TCString.decode((String)this.encode(), (DecoderOption[])new DecoderOption[0]);
        }
    }

    public static class TCStringEncoderV1
    implements TCStringEncoder {
        private final int version;
        private final Instant created;
        private final Instant updated;
        private final int cmpId;
        private final int cmpVersion;
        private final int consentScreen;
        private final String consentLanguage;
        private final int vendorListVersion;
        private final IntIterable purposesConsent;
        private final IntIterable vendorsConsent;
        private final boolean defaultConsent;

        public TCStringEncoderV1(Builder builder) {
            if (builder.version != 1) {
                throw new IllegalArgumentException("version must be 1: " + builder.version);
            }
            this.version = builder.version;
            this.created = builder.created;
            this.updated = builder.updated;
            this.cmpId = builder.cmpId;
            this.cmpVersion = builder.cmpVersion;
            this.consentScreen = builder.consentScreen;
            this.consentLanguage = builder.consentLanguage;
            this.vendorListVersion = builder.vendorListVersion;
            this.purposesConsent = builder.purposesConsent.build();
            this.vendorsConsent = builder.vendorConsent.build();
            this.defaultConsent = builder.defaultConsent;
        }

        @Override
        public String encode() {
            BitWriter bitWriter = new BitWriter();
            bitWriter.write((long)this.version, FieldDefs.V1_VERSION);
            bitWriter.write(this.created, FieldDefs.V1_CREATED);
            bitWriter.write(this.updated, FieldDefs.V1_LAST_UPDATED);
            bitWriter.write((long)this.cmpId, FieldDefs.V1_CMP_ID);
            bitWriter.write((long)this.cmpVersion, FieldDefs.V1_CMP_VERSION);
            bitWriter.write((long)this.consentScreen, FieldDefs.V1_CONSENT_SCREEN);
            bitWriter.write(this.consentLanguage, FieldDefs.V1_CONSENT_LANGUAGE);
            bitWriter.write((long)this.vendorListVersion, FieldDefs.V1_VENDOR_LIST_VERSION);
            bitWriter.write(this.purposesConsent, FieldDefs.V1_PURPOSES_ALLOW);
            BitWriter vendorConsentBits = new VendorFieldEncoder().defaultConsent(this.defaultConsent).add(this.vendorsConsent).buildV1();
            bitWriter.write(vendorConsentBits);
            return bitWriter.toBase64();
        }

        @Override
        public TCString toTCString() {
            return TCString.decode((String)this.encode(), (DecoderOption[])new DecoderOption[0]);
        }
    }
}

