/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.builders;

import com.ibanity.apis.client.builders.IbanityApiEndpointBuilder;
import com.ibanity.apis.client.builders.IbanityConfiguration;
import com.ibanity.apis.client.builders.OptionalPropertiesBuilder;
import com.ibanity.apis.client.builders.RequestSignatureCertificateBuilder;
import com.ibanity.apis.client.builders.RequestSignatureCertificateIdBuilder;
import com.ibanity.apis.client.builders.RequestSignaturePassphraseBuilder;
import com.ibanity.apis.client.builders.RequestSignaturePrivateKeyBuilder;
import com.ibanity.apis.client.builders.TlsCertificateBuilder;
import com.ibanity.apis.client.builders.TlsPassphraseBuilder;
import com.ibanity.apis.client.builders.TlsPrivateKeyBuilder;
import com.ibanity.apis.client.models.SignatureCredentials;
import com.ibanity.apis.client.models.TlsCredentials;
import com.ibanity.apis.client.services.IbanityService;
import com.ibanity.apis.client.services.impl.IbanityServiceImpl;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;

public class IbanityServiceBuilder
implements OptionalPropertiesBuilder,
IbanityApiEndpointBuilder,
TlsPrivateKeyBuilder,
TlsPassphraseBuilder,
TlsCertificateBuilder,
RequestSignaturePrivateKeyBuilder,
RequestSignaturePassphraseBuilder,
RequestSignatureCertificateBuilder,
RequestSignatureCertificateIdBuilder {
    private String apiEndpoint;
    private String proxyEndpoint;
    private Certificate caCertificate;
    private X509Certificate tlsCertificate;
    private PrivateKey tlsPrivateKey;
    private String tlsPrivateKeyPassphrase;
    private X509Certificate signatureCertificate;
    private PrivateKey signaturePrivateKey;
    private String signaturePrivateKeyPassphrase;
    private String signatureCertificateId;
    private String pontoConnectOauth2ClientId;
    private String isabelConnectOauth2ClientId;
    private boolean disableTlsClientCertificate;
    private List<HttpRequestInterceptor> requestInterceptors = new ArrayList<HttpRequestInterceptor>();
    private List<HttpResponseInterceptor> responseInterceptors = new ArrayList<HttpResponseInterceptor>();
    private int connectionRequestTimeout = 30000;
    private int connectTimeout = 30000;
    private int socketTimeout = 30000;
    private String applicationId;
    private int webhooksJwksCacheTTLMillis = 60000;
    private int webhooksJwtClockSkewSeconds = 30;

    public static IbanityApiEndpointBuilder builder() {
        return new IbanityServiceBuilder();
    }

    @Override
    public IbanityService build() {
        SignatureCredentials signatureCredentials = null;
        if (this.signaturePrivateKey != null) {
            signatureCredentials = SignatureCredentials.builder().certificate(this.signatureCertificate).certificateId(this.signatureCertificateId).privateKey(this.signaturePrivateKey).privateKeyPassphrase(this.signaturePrivateKeyPassphrase).build();
            this.signaturePrivateKeyPassphrase = null;
        }
        TlsCredentials tlsCredentials = null;
        if (!this.disableTlsClientCertificate) {
            tlsCredentials = TlsCredentials.builder().certificate(this.tlsCertificate).privateKey(this.tlsPrivateKey).privateKeyPassphrase(this.tlsPrivateKeyPassphrase).build();
            this.tlsPrivateKeyPassphrase = null;
        }
        IbanityConfiguration ibanityConfiguration = IbanityConfiguration.builder().apiEndpoint(this.apiEndpoint).caCertificate(this.caCertificate).tlsCredentials(tlsCredentials).signatureCredentials(signatureCredentials).proxyEndpoint(this.proxyEndpoint).pontoConnectOauth2ClientId(this.pontoConnectOauth2ClientId).isabelConnectOauth2ClientId(this.isabelConnectOauth2ClientId).httpRequestInterceptors(this.requestInterceptors).httpResponseInterceptors(this.responseInterceptors).connectionRequestTimeout(this.connectionRequestTimeout).connectTimeout(this.connectTimeout).socketTimeout(this.socketTimeout).applicationId(this.applicationId).webhooksJwksCacheTTL(this.webhooksJwksCacheTTLMillis).webhooksJwtClockSkew(this.webhooksJwtClockSkewSeconds).build();
        return new IbanityServiceImpl(ibanityConfiguration);
    }

    @Override
    public OptionalPropertiesBuilder caCertificate(Certificate certificate) {
        this.caCertificate = certificate;
        return this;
    }

    @Override
    public TlsPassphraseBuilder tlsPrivateKey(PrivateKey privateKey) {
        this.tlsPrivateKey = privateKey;
        return this;
    }

    @Override
    public OptionalPropertiesBuilder disableTlsClientCertificate() {
        this.disableTlsClientCertificate = true;
        return this;
    }

    @Override
    public RequestSignaturePassphraseBuilder requestSignaturePrivateKey(PrivateKey privateKey) {
        this.signaturePrivateKey = privateKey;
        return this;
    }

    @Override
    public OptionalPropertiesBuilder pontoConnectOauth2ClientId(String clientId) {
        this.pontoConnectOauth2ClientId = clientId;
        return this;
    }

    @Override
    public OptionalPropertiesBuilder isabelConnectOauth2ClientId(String clientId) {
        this.isabelConnectOauth2ClientId = clientId;
        return this;
    }

    @Override
    public OptionalPropertiesBuilder proxyEndpoint(String proxyEndpoint) {
        this.proxyEndpoint = this.removeTrailingSlash(proxyEndpoint);
        return this;
    }

    @Override
    public OptionalPropertiesBuilder withHttpRequestInterceptors(HttpRequestInterceptor ... httpRequestInterceptor) {
        this.requestInterceptors.addAll(Arrays.asList(httpRequestInterceptor));
        return this;
    }

    @Override
    public OptionalPropertiesBuilder withHttpResponseInterceptors(HttpResponseInterceptor ... httpResponseInterceptor) {
        this.responseInterceptors.addAll(Arrays.asList(httpResponseInterceptor));
        return this;
    }

    @Override
    public OptionalPropertiesBuilder socketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    @Override
    public OptionalPropertiesBuilder connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Override
    public OptionalPropertiesBuilder connectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
        return this;
    }

    @Override
    public OptionalPropertiesBuilder webhooksJwksCacheTTLMillis(int webhooksJwksCacheTTLMillis) {
        this.webhooksJwksCacheTTLMillis = webhooksJwksCacheTTLMillis;
        return this;
    }

    @Override
    public OptionalPropertiesBuilder webhooksJwtClockSkewSeconds(int webhooksJwtClockSkewSeconds) {
        this.webhooksJwtClockSkewSeconds = webhooksJwtClockSkewSeconds;
        return this;
    }

    @Override
    public OptionalPropertiesBuilder applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @Override
    public OptionalPropertiesBuilder tlsCertificate(X509Certificate certificate) {
        this.tlsCertificate = certificate;
        return this;
    }

    @Override
    public IbanityServiceBuilder requestSignatureCertificate(X509Certificate certificate) {
        this.signatureCertificate = certificate;
        return this;
    }

    @Override
    public IbanityServiceBuilder signatureCertificateId(String certificateId) {
        this.signatureCertificateId = certificateId;
        return this;
    }

    @Override
    public TlsCertificateBuilder passphrase(String passphrase) {
        this.tlsPrivateKeyPassphrase = StringUtils.isBlank((CharSequence)passphrase) ? "" : passphrase;
        return this;
    }

    @Override
    public TlsCertificateBuilder noPassphrase() {
        this.tlsPrivateKeyPassphrase = "";
        return this;
    }

    @Override
    public RequestSignatureCertificateBuilder requestSignaturePassphrase(String passphrase) {
        this.signaturePrivateKeyPassphrase = StringUtils.isBlank((CharSequence)passphrase) ? "" : passphrase;
        return this;
    }

    @Override
    public RequestSignatureCertificateBuilder requestSignatureNoPassphrase() {
        this.signaturePrivateKeyPassphrase = "";
        return this;
    }

    @Override
    public TlsPrivateKeyBuilder ibanityApiEndpoint(String apiEndpoint) {
        this.apiEndpoint = this.removeTrailingSlash(apiEndpoint);
        return this;
    }

    private String removeTrailingSlash(String url) {
        return url != null ? url.replaceAll("/\\z", "") : null;
    }
}

