/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.factory;

import com.ibanity.apis.client.builders.IbanityConfiguration;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.VerificationKeyResolver;

public class JwtConsumerFactory {
    public static JwtConsumer build(IbanityConfiguration ibanityConfiguration, VerificationKeyResolver verificationKeyResolver) {
        return new JwtConsumerBuilder().setAllowedClockSkewInSeconds(ibanityConfiguration.getWebhooksJwtClockSkew()).setRequireExpirationTime().setRequireIssuedAt().setExpectedIssuers(true, new String[]{ibanityConfiguration.getApiEndpoint()}).setExpectedAudience(new String[]{ibanityConfiguration.getApplicationId()}).setVerificationKeyResolver(verificationKeyResolver).setJwsAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, new String[]{"RS512"})).build();
    }
}

