/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.http.handler;

import com.ibanity.apis.client.exceptions.IbanityClientException;
import com.ibanity.apis.client.exceptions.IbanityServerException;
import com.ibanity.apis.client.jsonapi.ErrorResourceApiModel;
import com.ibanity.apis.client.jsonapi.IbanityErrorApiModel;
import com.ibanity.apis.client.jsonapi.OAuth2ErrorResourceApiModel;
import com.ibanity.apis.client.mappers.IbanityErrorMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityError;
import com.ibanity.apis.client.utils.IbanityUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;

public class IbanityResponseHandler
implements ResponseHandler<HttpResponse> {
    private static final int CLIENT_ERROR = 400;
    private static final int SERVER_ERROR = 500;
    public static final String IBANITY_REQUEST_ID_HEADER = "ibanity-request-id";

    public HttpResponse handleResponse(HttpResponse httpResponse) {
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode >= 500) {
            throw new IbanityServerException(this.parseErrors(httpResponse), statusCode, this.getIbanityRequestId(httpResponse));
        }
        if (statusCode >= 400) {
            throw new IbanityClientException(this.parseErrors(httpResponse), statusCode, this.getIbanityRequestId(httpResponse));
        }
        return httpResponse;
    }

    private String getIbanityRequestId(HttpResponse httpResponse) {
        Header firstHeader = httpResponse.getFirstHeader(IBANITY_REQUEST_ID_HEADER);
        return firstHeader != null ? firstHeader.getValue() : null;
    }

    private List<IbanityError> parseErrors(HttpResponse httpResponse) {
        try {
            String payload = ModelMapperHelper.readResponseContent(httpResponse.getEntity());
            List<IbanityErrorApiModel> errors = ((ErrorResourceApiModel)IbanityUtils.objectMapper().readValue(payload, ErrorResourceApiModel.class)).getErrors();
            if (!errors.isEmpty()) {
                return errors.stream().map(IbanityErrorMapper::map).collect(Collectors.toList());
            }
            OAuth2ErrorResourceApiModel oAuth2ErrorResourceApiModel = (OAuth2ErrorResourceApiModel)IbanityUtils.objectMapper().readValue(payload, OAuth2ErrorResourceApiModel.class);
            if (StringUtils.isNotBlank((CharSequence)oAuth2ErrorResourceApiModel.getError())) {
                return Collections.singletonList(IbanityErrorMapper.map(oAuth2ErrorResourceApiModel));
            }
            return Collections.emptyList();
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid payload", exception);
        }
    }
}

