/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.http.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.http.handler.IbanityResponseHandler;
import com.ibanity.apis.client.utils.IbanityUtils;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;

public class IbanityHttpClientImpl
implements IbanityHttpClient {
    private final HttpClient httpClient;
    private final SSLContext sslContext;
    private final IbanityResponseHandler ibanityResponseHandler;

    public IbanityHttpClientImpl(HttpClient httpClient, SSLContext sslContext) {
        this.httpClient = httpClient;
        this.sslContext = sslContext;
        this.ibanityResponseHandler = new IbanityResponseHandler();
    }

    @Override
    public SSLContext sslContext() {
        return this.sslContext;
    }

    @Override
    public HttpResponse get(@NonNull URI path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.get(path, null);
    }

    @Override
    public HttpResponse get(@NonNull URI path, String customerAccessToken) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.get(path, new HashMap<String, String>(), customerAccessToken);
    }

    @Override
    public HttpResponse get(@NonNull URI path, @NonNull Map<String, String> additionalHeaders, String customerAccessToken) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (additionalHeaders == null) {
            throw new NullPointerException("additionalHeaders is marked non-null but is null");
        }
        HttpGet httpGet = new HttpGet(path);
        return this.execute(additionalHeaders, customerAccessToken, (HttpRequestBase)httpGet);
    }

    @Override
    public HttpResponse post(@NonNull URI path, @NonNull Object requestApiModel) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (requestApiModel == null) {
            throw new NullPointerException("requestApiModel is marked non-null but is null");
        }
        return this.post(path, requestApiModel, null);
    }

    @Override
    public HttpResponse post(@NonNull URI path, @NonNull Object requestApiModel, String customerAccessToken) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (requestApiModel == null) {
            throw new NullPointerException("requestApiModel is marked non-null but is null");
        }
        return this.post(path, requestApiModel, new HashMap<String, String>(), customerAccessToken);
    }

    @Override
    public HttpResponse post(@NonNull URI path, @NonNull Object requestApiModel, @NonNull Map<String, String> additionalHeaders, String customerAccessToken) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (requestApiModel == null) {
            throw new NullPointerException("requestApiModel is marked non-null but is null");
        }
        if (additionalHeaders == null) {
            throw new NullPointerException("additionalHeaders is marked non-null but is null");
        }
        try {
            HttpPost httpPost = new HttpPost(path);
            httpPost.setEntity(this.createEntityRequest(IbanityUtils.objectMapper().writeValueAsString(requestApiModel)));
            return this.execute(additionalHeaders, customerAccessToken, (HttpRequestBase)httpPost);
        }
        catch (JsonProcessingException exception) {
            throw new RuntimeException("An error occurred while converting object to json", exception);
        }
    }

    @Override
    public HttpResponse delete(@NonNull URI path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.delete(path, null);
    }

    @Override
    public HttpResponse delete(@NonNull URI path, String customerAccessToken) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.delete(path, Collections.emptyMap(), customerAccessToken);
    }

    @Override
    public HttpResponse delete(@NonNull URI path, @NonNull Map<String, String> additionalHeaders, String customerAccessToken) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (additionalHeaders == null) {
            throw new NullPointerException("additionalHeaders is marked non-null but is null");
        }
        HttpDelete httpDelete = new HttpDelete(path);
        return this.execute(additionalHeaders, customerAccessToken, (HttpRequestBase)httpDelete);
    }

    @Override
    public HttpResponse patch(@NonNull URI path, @NonNull Object requestApiModel) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (requestApiModel == null) {
            throw new NullPointerException("requestApiModel is marked non-null but is null");
        }
        return this.patch(path, requestApiModel, null);
    }

    @Override
    public HttpResponse patch(@NonNull URI path, @NonNull Object requestApiModel, String customerAccessToken) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (requestApiModel == null) {
            throw new NullPointerException("requestApiModel is marked non-null but is null");
        }
        return this.patch(path, requestApiModel, new HashMap<String, String>(), customerAccessToken);
    }

    @Override
    public HttpResponse patch(@NonNull URI path, @NonNull Object requestApiModel, @NonNull Map<String, String> additionalHeaders, String customerAccessToken) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (requestApiModel == null) {
            throw new NullPointerException("requestApiModel is marked non-null but is null");
        }
        if (additionalHeaders == null) {
            throw new NullPointerException("additionalHeaders is marked non-null but is null");
        }
        try {
            HttpPatch httpPatch = new HttpPatch(path);
            httpPatch.setEntity(this.createEntityRequest(IbanityUtils.objectMapper().writeValueAsString(requestApiModel)));
            return this.execute(additionalHeaders, customerAccessToken, (HttpRequestBase)httpPatch);
        }
        catch (JsonProcessingException exception) {
            throw new RuntimeException("An error occurred while converting object to json", exception);
        }
    }

    @Override
    public HttpClient httpClient() {
        return this.httpClient;
    }

    private HttpResponse execute(@NonNull Map<String, String> additionalHeaders, String customerAccessToken, HttpRequestBase httpRequestBase) {
        if (additionalHeaders == null) {
            throw new NullPointerException("additionalHeaders is marked non-null but is null");
        }
        try {
            this.addHeaders(customerAccessToken, additionalHeaders, httpRequestBase);
            return this.ibanityResponseHandler.handleResponse(this.httpClient.execute((HttpUriRequest)httpRequestBase));
        }
        catch (IOException exception) {
            throw new RuntimeException("An error occurred while connecting to Ibanity", exception);
        }
    }

    private HttpEntity createEntityRequest(String baseRequest) {
        return new StringEntity(baseRequest, ContentType.APPLICATION_JSON);
    }

    private void addHeaders(String customerAccessToken, Map<String, String> additionalHeaders, HttpRequestBase httpRequestBase) {
        this.addAuthorizationHeader(customerAccessToken, httpRequestBase);
        additionalHeaders.forEach((arg_0, arg_1) -> ((HttpRequestBase)httpRequestBase).addHeader(arg_0, arg_1));
    }

    private void addAuthorizationHeader(String customerAccessToken, HttpRequestBase requestBase) {
        if (StringUtils.isNotBlank((CharSequence)customerAccessToken)) {
            requestBase.addHeader((Header)new BasicHeader("Authorization", "Bearer " + customerAccessToken));
        }
    }
}

