/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.http.impl;

import com.ibanity.apis.client.http.OAuthHttpClient;
import com.ibanity.apis.client.http.handler.IbanityResponseHandler;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

public class OAuthHttpClientImpl
implements OAuthHttpClient {
    private final String clientId;
    private final HttpClient httpClient;
    private final IbanityResponseHandler ibanityResponseHandler;

    public OAuthHttpClientImpl(String clientId, HttpClient httpClient) {
        this.clientId = clientId;
        this.httpClient = httpClient;
        this.ibanityResponseHandler = new IbanityResponseHandler();
    }

    @Override
    public HttpResponse post(URI path, Map<String, String> arguments, String clientSecret) {
        return this.post(path, new HashMap<String, String>(), arguments, clientSecret);
    }

    @Override
    public HttpResponse post(URI path, Map<String, String> additionalHeaders, Map<String, String> arguments, String clientSecret) {
        HttpPost post = new HttpPost(path);
        arguments.put("client_id", this.clientId);
        post.setEntity(this.createEntity(arguments));
        return this.execute(additionalHeaders, clientSecret, (HttpRequestBase)post);
    }

    private HttpEntity createEntity(Map<String, String> arguments) {
        return new UrlEncodedFormEntity((Iterable)arguments.entrySet().stream().map(a -> new BasicNameValuePair((String)a.getKey(), (String)a.getValue())).collect(Collectors.toList()), StandardCharsets.UTF_8);
    }

    private HttpResponse execute(Map<String, String> additionalHeaders, String clientSecret, HttpRequestBase httpRequestBase) {
        try {
            this.addHeaders(clientSecret, additionalHeaders, httpRequestBase);
            return this.ibanityResponseHandler.handleResponse(this.httpClient.execute((HttpUriRequest)httpRequestBase));
        }
        catch (IOException exception) {
            throw new RuntimeException("An error occurred while connecting to Ibanity", exception);
        }
    }

    private void addHeaders(String clientSecret, Map<String, String> additionalHeaders, HttpRequestBase httpRequestBase) {
        this.addAuthorizationHeader(this.clientId, clientSecret, httpRequestBase);
        additionalHeaders.forEach((arg_0, arg_1) -> ((HttpRequestBase)httpRequestBase).addHeader(arg_0, arg_1));
    }

    private void addAuthorizationHeader(String clientId, String clientSecret, HttpRequestBase requestBase) {
        if (StringUtils.isNotBlank((CharSequence)clientId) && StringUtils.isNotBlank((CharSequence)clientSecret)) {
            String base64Encoded = Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes(StandardCharsets.UTF_8));
            requestBase.addHeader((Header)new BasicHeader("Authorization", "Basic " + base64Encoded));
        }
    }
}

