/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.http.interceptor;

import com.ibanity.apis.client.http.service.IbanityHttpSignatureService;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.protocol.HttpContext;

public class IbanitySignatureInterceptor
implements HttpRequestInterceptor {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private final IbanityHttpSignatureService httpSignatureService;
    private final String basePath;

    public IbanitySignatureInterceptor(IbanityHttpSignatureService httpSignatureService, String basePath) {
        this.httpSignatureService = httpSignatureService;
        this.basePath = basePath;
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws IOException {
        try {
            InputStream payload;
            HttpRequestWrapper requestWrapper = (HttpRequestWrapper)httpRequest;
            if (requestWrapper.getOriginal() instanceof HttpEntityEnclosingRequestBase) {
                HttpEntityEnclosingRequestBase original = (HttpEntityEnclosingRequestBase)requestWrapper.getOriginal();
                payload = original.getEntity().getContent();
            } else {
                payload = IOUtils.toInputStream((String)"", (Charset)DEFAULT_CHARSET);
            }
            this.httpSignatureService.getHttpSignatureHeaders(requestWrapper.getMethod(), this.getUrl(requestWrapper), this.getAllHeaders(requestWrapper), payload).entrySet().forEach(this.addHeaderToRequest(httpRequest));
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage(), exception);
        }
    }

    private URL getUrl(HttpRequestWrapper requestWrapper) throws MalformedURLException {
        return new URL(this.basePath + requestWrapper.getURI().toString());
    }

    private Consumer<? super Map.Entry<String, String>> addHeaderToRequest(HttpRequest httpRequest) {
        return entry -> httpRequest.addHeader((String)entry.getKey(), (String)entry.getValue());
    }

    private Map<String, String> getAllHeaders(HttpRequestWrapper requestWrapper) {
        return Stream.of(requestWrapper.getAllHeaders()).collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue));
    }
}

