/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.http.interceptor;

import java.util.UUID;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

public class IdempotencyInterceptor
implements HttpRequestInterceptor {
    private static final String IDEMPOTENCY_HTTP_HEADER_KEY = "ibanity-idempotency-key";

    public void process(HttpRequest httpRequest, HttpContext httpContext) {
        if (!httpRequest.containsHeader(IDEMPOTENCY_HTTP_HEADER_KEY) && (httpRequest.getRequestLine().getMethod().equalsIgnoreCase("post") || httpRequest.getRequestLine().getMethod().equalsIgnoreCase("patch"))) {
            httpRequest.addHeader(IDEMPOTENCY_HTTP_HEADER_KEY, UUID.randomUUID().toString());
        }
    }
}

