/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.http.service.impl;

import com.ibanity.apis.client.http.service.IbanityHttpSignatureService;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IbanityHttpSignatureServiceImpl
implements IbanityHttpSignatureService {
    public static final int BUFFER_SIZE = 32768;
    public static final String SIGNATURE_ALGORITHM = "RSASSA-PSS";
    public static final PSSParameterSpec PARAMETER_SPEC = new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1);
    private static final Logger LOGGER = LoggerFactory.getLogger(IbanityHttpSignatureServiceImpl.class);
    private static final String SIGNATURE_HEADER_TEMPLATE = "keyId=\"%s\",created=\"%s\",algorithm=\"%s\",headers=\"%s\",signature=\"%s\"";
    private static final String DIGEST_ALGORITHM = "SHA-512";
    private static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;
    private static final String ACCEPTED_HEADERS_REGEX = "(authorization|ibanity.*?)";
    private static final Pattern HEADERS_PATTERN = Pattern.compile("(authorization|ibanity.*?)", 2);
    private static final String SIGNATURE_HEADER_ALGORITHM = "hs2019";
    private Clock clock;
    private String certificateId;
    private PrivateKey privateKey;
    private String ibanityEndpoint;
    private String proxyEndpoint;

    public IbanityHttpSignatureServiceImpl(@NonNull PrivateKey privateKey, @NonNull X509Certificate certificate, @NonNull String certificateId, @NonNull String ibanityEndpoint) {
        this(privateKey, certificate, certificateId, Clock.systemUTC(), ibanityEndpoint, null);
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        if (certificate == null) {
            throw new NullPointerException("certificate is marked non-null but is null");
        }
        if (certificateId == null) {
            throw new NullPointerException("certificateId is marked non-null but is null");
        }
        if (ibanityEndpoint == null) {
            throw new NullPointerException("ibanityEndpoint is marked non-null but is null");
        }
    }

    public IbanityHttpSignatureServiceImpl(@NonNull PrivateKey privateKey, @NonNull String certificateId, @NonNull String ibanityEndpoint) {
        this(privateKey, certificateId, Clock.systemUTC(), ibanityEndpoint, null);
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        if (certificateId == null) {
            throw new NullPointerException("certificateId is marked non-null but is null");
        }
        if (ibanityEndpoint == null) {
            throw new NullPointerException("ibanityEndpoint is marked non-null but is null");
        }
    }

    public IbanityHttpSignatureServiceImpl(@NonNull PrivateKey privateKey, @NonNull X509Certificate certificate, @NonNull String certificateId, @NonNull String ibanityEndpoint, String proxyEndpoint) {
        this(privateKey, certificate, certificateId, Clock.systemUTC(), ibanityEndpoint, proxyEndpoint);
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        if (certificate == null) {
            throw new NullPointerException("certificate is marked non-null but is null");
        }
        if (certificateId == null) {
            throw new NullPointerException("certificateId is marked non-null but is null");
        }
        if (ibanityEndpoint == null) {
            throw new NullPointerException("ibanityEndpoint is marked non-null but is null");
        }
    }

    public IbanityHttpSignatureServiceImpl(@NonNull PrivateKey privateKey, @NonNull String certificateId, @NonNull String ibanityEndpoint, String proxyEndpoint) {
        this(privateKey, certificateId, Clock.systemUTC(), ibanityEndpoint, proxyEndpoint);
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        if (certificateId == null) {
            throw new NullPointerException("certificateId is marked non-null but is null");
        }
        if (ibanityEndpoint == null) {
            throw new NullPointerException("ibanityEndpoint is marked non-null but is null");
        }
    }

    public IbanityHttpSignatureServiceImpl(@NonNull PrivateKey privateKey, @NonNull X509Certificate certificate, @NonNull String certificateId, @NonNull Clock clock, @NonNull String ibanityEndpoint) {
        this(privateKey, certificateId, clock, ibanityEndpoint, null);
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        if (certificate == null) {
            throw new NullPointerException("certificate is marked non-null but is null");
        }
        if (certificateId == null) {
            throw new NullPointerException("certificateId is marked non-null but is null");
        }
        if (clock == null) {
            throw new NullPointerException("clock is marked non-null but is null");
        }
        if (ibanityEndpoint == null) {
            throw new NullPointerException("ibanityEndpoint is marked non-null but is null");
        }
    }

    public IbanityHttpSignatureServiceImpl(@NonNull PrivateKey privateKey, @NonNull String certificateId, @NonNull Clock clock, @NonNull String ibanityEndpoint) {
        this(privateKey, certificateId, clock, ibanityEndpoint, null);
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        if (certificateId == null) {
            throw new NullPointerException("certificateId is marked non-null but is null");
        }
        if (clock == null) {
            throw new NullPointerException("clock is marked non-null but is null");
        }
        if (ibanityEndpoint == null) {
            throw new NullPointerException("ibanityEndpoint is marked non-null but is null");
        }
    }

    public IbanityHttpSignatureServiceImpl(@NonNull PrivateKey privateKey, @NonNull X509Certificate certificate, @NonNull String certificateId, @NonNull Clock clock, @NonNull String ibanityEndpoint, String proxyEndpoint) {
        this(privateKey, certificateId, clock, ibanityEndpoint, proxyEndpoint);
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        if (certificate == null) {
            throw new NullPointerException("certificate is marked non-null but is null");
        }
        if (certificateId == null) {
            throw new NullPointerException("certificateId is marked non-null but is null");
        }
        if (clock == null) {
            throw new NullPointerException("clock is marked non-null but is null");
        }
        if (ibanityEndpoint == null) {
            throw new NullPointerException("ibanityEndpoint is marked non-null but is null");
        }
    }

    public IbanityHttpSignatureServiceImpl(@NonNull PrivateKey privateKey, @NonNull String certificateId, @NonNull Clock clock, @NonNull String ibanityEndpoint, String proxyEndpoint) {
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        if (certificateId == null) {
            throw new NullPointerException("certificateId is marked non-null but is null");
        }
        if (clock == null) {
            throw new NullPointerException("clock is marked non-null but is null");
        }
        if (ibanityEndpoint == null) {
            throw new NullPointerException("ibanityEndpoint is marked non-null but is null");
        }
        this.privateKey = privateKey;
        this.certificateId = certificateId;
        this.clock = clock;
        this.ibanityEndpoint = ibanityEndpoint;
        this.proxyEndpoint = proxyEndpoint;
    }

    @Override
    public Map<String, String> getHttpSignatureHeaders(@NonNull String httpMethod, @NonNull URL url, @NonNull Map<String, String> requestHeaders) {
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (requestHeaders == null) {
            throw new NullPointerException("requestHeaders is marked non-null but is null");
        }
        return this.getHttpSignatureHeaders(httpMethod, url, requestHeaders, "");
    }

    @Override
    public Map<String, String> getHttpSignatureHeaders(@NonNull String httpMethod, @NonNull URL url, @NonNull Map<String, String> requestHeaders, String payload) {
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (requestHeaders == null) {
            throw new NullPointerException("requestHeaders is marked non-null but is null");
        }
        return this.getHttpSignatureHeaders(httpMethod, url, requestHeaders, IOUtils.toInputStream((String)payload, (Charset)UTF8_CHARSET));
    }

    @Override
    public Map<String, String> getHttpSignatureHeaders(@NonNull String httpMethod, @NonNull URL url, @NonNull Map<String, String> requestHeaders, InputStream inputStream) {
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (requestHeaders == null) {
            throw new NullPointerException("requestHeaders is marked non-null but is null");
        }
        return this.httpSignatureHeaders(httpMethod, url, requestHeaders, IbanityHttpSignatureServiceImpl.getDigestHeader(inputStream));
    }

    private Map<String, String> httpSignatureHeaders(@NonNull String httpMethod, @NonNull URL url, @NonNull Map<String, String> requestHeaders, @NonNull String payloadDigestHeaderValue) {
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (requestHeaders == null) {
            throw new NullPointerException("requestHeaders is marked non-null but is null");
        }
        if (payloadDigestHeaderValue == null) {
            throw new NullPointerException("payloadDigestHeaderValue is marked non-null but is null");
        }
        HashMap<String, String> httpSignatureHeaders = new HashMap<String, String>();
        Long createdTimestamp = this.getTimestamp();
        String signatureDigest = this.getSignatureDigest(this.getRequestTarget(httpMethod, url), this.getHost(), payloadDigestHeaderValue, createdTimestamp, requestHeaders);
        String signatureHeaderValue = this.getSignatureHeader(this.certificateId, createdTimestamp, SIGNATURE_HEADER_ALGORITHM, this.getSignatureHeaders(requestHeaders), signatureDigest);
        httpSignatureHeaders.put("Digest", payloadDigestHeaderValue);
        httpSignatureHeaders.put("Signature", signatureHeaderValue);
        return httpSignatureHeaders;
    }

    private String getHost() {
        try {
            return new URL(this.ibanityEndpoint).getHost();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Ibanity api endpoint misconfigured: " + this.ibanityEndpoint, e);
        }
    }

    public static String getDigestHeader(InputStream payload) {
        MessageDigest md = IbanityHttpSignatureServiceImpl.getDigest();
        try (BufferedInputStream stream = new BufferedInputStream(payload, 32768);){
            int length;
            byte[] buffer = new byte[32768];
            while ((length = stream.read(buffer)) != -1) {
                md.update(buffer, 0, length);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read payload");
        }
        String digest = Base64.getEncoder().encodeToString(md.digest());
        return "SHA-512=" + digest;
    }

    private static MessageDigest getDigest() {
        try {
            return MessageDigest.getInstance(DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Unsupported digest algorithm:SHA-512");
        }
    }

    private Long getTimestamp() {
        return Instant.now(this.clock).getEpochSecond();
    }

    private String getSignatureHeader(String certificateId, Long created, String algorithm, String headers, String signature) {
        return String.format(SIGNATURE_HEADER_TEMPLATE, certificateId, created, algorithm, headers, signature);
    }

    private String getSignatureHeaders(Map<String, String> requestHeaders) {
        ArrayList<String> headers = new ArrayList<String>(Arrays.asList("(request-target)", "host", "digest", "(created)"));
        List additionalHeaders = this.getAdditionalHeaders(requestHeaders).keySet().stream().map(String::toLowerCase).collect(Collectors.toList());
        headers.addAll(additionalHeaders);
        return String.join((CharSequence)" ", headers);
    }

    private Map<String, String> getAdditionalHeaders(Map<String, String> requestHeaders) {
        return requestHeaders.entrySet().stream().filter(entry -> HEADERS_PATTERN.matcher((CharSequence)entry.getKey()).matches()).collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(), Map.Entry::getValue));
    }

    private String getSignatureDigest(String requestTarget, String host, String payloadDigest, Long timestamp, Map<String, String> requestHeaders) {
        try {
            String signatureString = this.getSignatureString(requestTarget, host, payloadDigest, timestamp, requestHeaders);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Signature value: {}", (Object)signatureString);
            }
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.setParameter(PARAMETER_SPEC);
            signature.initSign(this.privateKey);
            signature.update(signatureString.getBytes());
            byte[] signedData = signature.sign();
            return Base64.getEncoder().encodeToString(signedData);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException exception) {
            String errorMessage = "Error while trying to generate the signature of the request";
            throw new IllegalArgumentException(errorMessage, exception);
        }
    }

    private String getSignatureString(String requestTarget, String host, String payloadDigest, Long timestamp, Map<String, String> requestHeaders) {
        ArrayList<String> values = new ArrayList<String>(Arrays.asList("(request-target): " + requestTarget, "host: " + host, "digest: " + payloadDigest, "(created): " + timestamp));
        values.addAll(this.getAdditionalHeaders(requestHeaders).entrySet().stream().map(entry -> String.format("%s: %s", ((String)entry.getKey()).toLowerCase(), entry.getValue())).collect(Collectors.toList()));
        return String.join((CharSequence)"\n", values);
    }

    private String getRequestTarget(String httpMethod, URL url) {
        String requestTarget = httpMethod.toLowerCase() + " " + this.getPath(url);
        if (url.getQuery() != null) {
            requestTarget = requestTarget + "?" + url.getQuery();
        }
        return requestTarget;
    }

    private String getPath(URL url) {
        if (this.proxyEndpoint == null) {
            return url.getPath();
        }
        return url.getPath().replace(URI.create(this.proxyEndpoint).getPath(), "");
    }
}

