/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.mappers;

import com.ibanity.apis.client.jsonapi.CollectionApiModel;
import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.ResourceApiModel;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityCollection;
import com.ibanity.apis.client.models.IbanityModel;
import com.ibanity.apis.client.products.xs2a.mappers.SynchronizationMapper;
import com.ibanity.apis.client.products.xs2a.models.Synchronization;
import com.ibanity.apis.client.utils.IbanityUtils;
import java.io.IOException;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class IbanityModelMapper {
    public static <T extends IbanityModel> T mapResource(HttpResponse httpResponse, Class<T> classType) {
        return (T)IbanityModelMapper.mapResource(httpResponse, (DataApiModel dataApiModel) -> IbanityModelMapper.toIbanityModel(dataApiModel, classType));
    }

    public static <T extends IbanityModel> T mapResource(HttpResponse httpResponse, Function<DataApiModel, T> customMapping) {
        try {
            String jsonPayload = ModelMapperHelper.readResponseContent(httpResponse.getEntity());
            DataApiModel dataApiModel = ((ResourceApiModel)IbanityUtils.objectMapper().readValue(jsonPayload, ResourceApiModel.class)).getData();
            IbanityModel ibanityModel = (IbanityModel)customMapping.apply(dataApiModel);
            ibanityModel.setRequestId(ModelMapperHelper.getRequestId(httpResponse));
            return (T)ibanityModel;
        }
        catch (IOException exception) {
            throw new IllegalArgumentException("Response cannot be parsed", exception);
        }
    }

    public static <T extends IbanityModel> IbanityCollection<T> mapCollection(HttpResponse httpResponse, Class<T> classType) {
        return IbanityModelMapper.mapCollection(httpResponse, (DataApiModel dataApiModel) -> IbanityModelMapper.toIbanityModel(dataApiModel, classType));
    }

    public static <T extends IbanityModel> IbanityCollection<T> mapCollection(HttpResponse httpResponse, Function<DataApiModel, T> customMapping) {
        try {
            String jsonPayload = ModelMapperHelper.readResponseContent(httpResponse.getEntity());
            CollectionApiModel collectionApiModel = (CollectionApiModel)IbanityUtils.objectMapper().readValue(jsonPayload, CollectionApiModel.class);
            String requestId = ModelMapperHelper.getRequestId(httpResponse);
            return IbanityCollection.builder().requestId(requestId).pageLimit(collectionApiModel.getMeta().getPaging().getLimit()).pageNumber(collectionApiModel.getMeta().getPaging().getPageNumber()).pageSize(collectionApiModel.getMeta().getPaging().getPageSize()).totalEntries(collectionApiModel.getMeta().getPaging().getTotalEntries()).totalPages(collectionApiModel.getMeta().getPaging().getTotalPages()).afterCursor(IbanityModelMapper.toUUIDNullSafe(collectionApiModel.getMeta().getPaging().getAfter())).beforeCursor(IbanityModelMapper.toUUIDNullSafe(collectionApiModel.getMeta().getPaging().getBefore())).firstLink(collectionApiModel.getLinks().getFirst()).previousLink(collectionApiModel.getLinks().getPrev()).nextLink(collectionApiModel.getLinks().getNext()).lastLink(collectionApiModel.getLinks().getLast()).latestSynchronization(IbanityModelMapper.getLatestSynchronization(collectionApiModel)).items(collectionApiModel.getData().stream().map(customMapping).peek(value -> value.setRequestId(requestId)).collect(Collectors.toList())).build();
        }
        catch (IOException exception) {
            throw new IllegalArgumentException("Response cannot be parsed", exception);
        }
    }

    private static Synchronization getLatestSynchronization(CollectionApiModel collectionApiModel) {
        if (collectionApiModel.getMeta().getLatestSynchronization() != null) {
            return SynchronizationMapper.map(collectionApiModel.getMeta().getLatestSynchronization());
        }
        return null;
    }

    public static <T extends IbanityModel> T toIbanityModel(DataApiModel data, Class<T> classType) {
        try {
            IbanityModel clientObject = (IbanityModel)IbanityUtils.objectMapper().convertValue(data.getAttributes(), classType);
            if (clientObject == null) {
                clientObject = (IbanityModel)classType.newInstance();
            }
            clientObject.setId(UUID.fromString(data.getId()));
            if (data.getLinks() != null) {
                clientObject.setSelfLink(data.getLinks().getSelf());
            }
            return (T)clientObject;
        }
        catch (IllegalAccessException | InstantiationException exception) {
            throw new RuntimeException(String.format("Instantiation of class %s is impossible for default constructor", classType), exception);
        }
    }

    public static UUID toUUIDNullSafe(String value) {
        return StringUtils.isNotBlank((CharSequence)value) ? UUID.fromString(value) : null;
    }
}

