/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.mappers;

import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.ResourceApiModel;
import com.ibanity.apis.client.models.IbanityWebhookEvent;
import com.ibanity.apis.client.utils.IbanityUtils;
import java.io.IOException;
import java.util.UUID;
import java.util.function.Function;

public class IbanityWebhookEventMapper {
    public static <T extends IbanityWebhookEvent> T mapWebhookResource(String payload, Function<DataApiModel, T> customMapping) {
        try {
            DataApiModel dataApiModel = ((ResourceApiModel)IbanityUtils.objectMapper().readValue(payload, ResourceApiModel.class)).getData();
            return (T)((IbanityWebhookEvent)customMapping.apply(dataApiModel));
        }
        catch (IOException exception) {
            throw new IllegalArgumentException("Response cannot be parsed", exception);
        }
    }

    public static <T extends IbanityWebhookEvent> T toIbanityWebhooks(DataApiModel data, Class<T> classType) {
        try {
            IbanityWebhookEvent clientObject = (IbanityWebhookEvent)IbanityUtils.objectMapper().convertValue(data.getAttributes(), classType);
            if (clientObject == null) {
                clientObject = (IbanityWebhookEvent)classType.newInstance();
            }
            clientObject.setId(UUID.fromString(data.getId()));
            clientObject.setType(data.getType());
            return (T)clientObject;
        }
        catch (IllegalAccessException | InstantiationException exception) {
            throw new RuntimeException(String.format("Instantiation of class %s is impossible for default constructor", classType), exception);
        }
    }
}

