/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.mappers;

import com.ibanity.apis.client.jsonapi.RequestApiModel;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class ModelMapperHelper {
    private static final String DEFAULT_ENCODING = "UTF-8";

    public static String getRequestId(HttpResponse httpResponse) {
        Header header = httpResponse.getFirstHeader("ibanity-request-id");
        return header == null ? null : header.getValue();
    }

    public static RequestApiModel buildRequest(String resourceType, Object attributes) {
        return ModelMapperHelper.buildRequest(resourceType, attributes, null);
    }

    public static RequestApiModel buildRequest(String resourceType, Object attributes, Object meta) {
        return RequestApiModel.builder().data(RequestApiModel.RequestDataApiModel.builder().type(resourceType).meta(meta).attributes(attributes).build()).build();
    }

    public static String readResponseContent(HttpEntity entity) throws IOException {
        try {
            String string = IOUtils.toString((InputStream)entity.getContent(), (String)DEFAULT_ENCODING);
            return string;
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)entity);
        }
    }
}

