/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.isabel_connect.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.isabel_connect.CollectionApiModel;
import com.ibanity.apis.client.jsonapi.isabel_connect.DataApiModel;
import com.ibanity.apis.client.mappers.IsabelModelMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.models.IsabelCollection;
import com.ibanity.apis.client.products.isabel_connect.models.AccountReport;
import com.ibanity.apis.client.products.isabel_connect.models.read.AccountReportReadQuery;
import com.ibanity.apis.client.products.isabel_connect.models.read.AccountReportsReadQuery;
import com.ibanity.apis.client.products.isabel_connect.services.AccountReportService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.IbanityUtils;
import com.ibanity.apis.client.utils.URIHelper;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class AccountReportServiceImpl
implements AccountReportService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public AccountReportServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public IsabelCollection<AccountReport> list(AccountReportsReadQuery query) {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put("after", query.getAfter());
        URI uri = URIHelper.buildUri(this.getUrl(), query.getPagingSpec(), queryParameters);
        return this.mapCollection(this.ibanityHttpClient.get(uri, query.getAdditionalHeaders(), query.getAccessToken()));
    }

    @Override
    public String find(AccountReportReadQuery query) {
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(this.getUrl(query.getAccountReportId())), query.getAdditionalHeaders(), query.getAccessToken());
        try {
            return ModelMapperHelper.readResponseContent(response.getEntity());
        }
        catch (IOException exception) {
            throw new IllegalArgumentException("Response cannot be parsed", exception);
        }
    }

    @Override
    public <T> T find(AccountReportReadQuery query, Function<HttpResponse, T> func) {
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(this.getUrl(query.getAccountReportId())), query.getAdditionalHeaders(), query.getAccessToken());
        return func.apply(response);
    }

    private String getUrl() {
        return this.getUrl("");
    }

    private String getUrl(String accountReportId) {
        String url = this.apiUrlProvider.find(IbanityProduct.IsabelConnect, "accountReports").replace("{accountReportId}", accountReportId);
        return StringUtils.removeEnd((String)url, (String)"/");
    }

    private IsabelCollection<AccountReport> mapCollection(HttpResponse httpResponse) {
        try {
            String jsonPayload = ModelMapperHelper.readResponseContent(httpResponse.getEntity());
            CollectionApiModel collectionApiModel = (CollectionApiModel)IbanityUtils.objectMapper().readValue(jsonPayload, CollectionApiModel.class);
            String requestId = ModelMapperHelper.getRequestId(httpResponse);
            return IsabelCollection.builder().requestId(requestId).pagingOffset(collectionApiModel.getPaginationOffset()).pagingTotal(collectionApiModel.getPaginationTotal()).items(collectionApiModel.getData().stream().map(dataApiModel -> this.mapItem((DataApiModel)dataApiModel)).collect(Collectors.toList())).build();
        }
        catch (IOException exception) {
            throw new IllegalArgumentException("Response cannot be parsed", exception);
        }
    }

    private AccountReport mapItem(DataApiModel data) {
        return IsabelModelMapper.toIsabelModel(data, AccountReport.class);
    }
}

