/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.isabel_connect.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.isabel_connect.DataApiModel;
import com.ibanity.apis.client.mappers.IsabelModelMapper;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.models.IsabelCollection;
import com.ibanity.apis.client.products.isabel_connect.models.Account;
import com.ibanity.apis.client.products.isabel_connect.models.read.AccountReadQuery;
import com.ibanity.apis.client.products.isabel_connect.models.read.AccountsReadQuery;
import com.ibanity.apis.client.products.isabel_connect.models.read.IsabelPagingSpec;
import com.ibanity.apis.client.products.isabel_connect.services.AccountService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class AccountServiceImpl
implements AccountService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public AccountServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public Account find(AccountReadQuery query) {
        String url = this.getUrl(query.getAccountId());
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url), query.getAdditionalHeaders(), query.getAccessToken());
        return IsabelModelMapper.mapResource(response, Account.class);
    }

    @Override
    public IsabelCollection<Account> list(AccountsReadQuery query) {
        IsabelPagingSpec pagingSpec = query.getPagingSpec();
        if (pagingSpec == null) {
            pagingSpec = IsabelPagingSpec.DEFAULT_PAGING_SPEC;
        }
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(this.getUrl(), pagingSpec), query.getAdditionalHeaders(), query.getAccessToken());
        return IsabelModelMapper.mapCollection(response, this.customMappingFunction());
    }

    private String getUrl() {
        return this.getUrl("");
    }

    private String getUrl(String accountId) {
        String url = this.apiUrlProvider.find(IbanityProduct.IsabelConnect, "accounts").replace(Account.API_URL_TAG_ID, accountId);
        return StringUtils.removeEnd((String)url, (String)"/");
    }

    private Function<DataApiModel, Account> customMappingFunction() {
        return dataApiModel -> IsabelModelMapper.toIsabelModel(dataApiModel, Account.class);
    }
}

