/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.isabel_connect.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.isabel_connect.CollectionApiModel;
import com.ibanity.apis.client.jsonapi.isabel_connect.DataApiModel;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.models.IsabelCollection;
import com.ibanity.apis.client.products.isabel_connect.models.Account;
import com.ibanity.apis.client.products.isabel_connect.models.Balance;
import com.ibanity.apis.client.products.isabel_connect.models.read.BalancesReadQuery;
import com.ibanity.apis.client.products.isabel_connect.models.read.IsabelPagingSpec;
import com.ibanity.apis.client.products.isabel_connect.services.BalanceService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.IbanityUtils;
import com.ibanity.apis.client.utils.URIHelper;
import java.io.IOException;
import java.net.URI;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class BalanceServiceImpl
implements BalanceService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public BalanceServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public IsabelCollection<Balance> list(BalancesReadQuery query) {
        IsabelPagingSpec pagingSpec = query.getPagingSpec();
        URI uri = URIHelper.buildUri(this.getUrl(query.getAccountId()), pagingSpec);
        HttpResponse response = this.ibanityHttpClient.get(uri, query.getAdditionalHeaders(), query.getAccessToken());
        return this.mapCollection(response);
    }

    private String getUrl(String accountId) {
        String url = this.apiUrlProvider.find(IbanityProduct.IsabelConnect, "account", "balances").replace(Account.API_URL_TAG_ID, accountId);
        return StringUtils.removeEnd((String)url, (String)"/");
    }

    private IsabelCollection<Balance> mapCollection(HttpResponse httpResponse) {
        try {
            String jsonPayload = ModelMapperHelper.readResponseContent(httpResponse.getEntity());
            CollectionApiModel collectionApiModel = (CollectionApiModel)IbanityUtils.objectMapper().readValue(jsonPayload, CollectionApiModel.class);
            String requestId = ModelMapperHelper.getRequestId(httpResponse);
            return IsabelCollection.builder().requestId(requestId).pagingOffset(collectionApiModel.getPaginationOffset()).pagingTotal(collectionApiModel.getPaginationTotal()).items(collectionApiModel.getData().stream().map(dataApiModel -> this.mapItem((DataApiModel)dataApiModel)).collect(Collectors.toList())).build();
        }
        catch (IOException exception) {
            throw new IllegalArgumentException("Response cannot be parsed", exception);
        }
    }

    private Balance mapItem(DataApiModel data) {
        return (Balance)IbanityUtils.objectMapper().convertValue(data.getAttributes(), Balance.class);
    }
}

