/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.isabel_connect.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.http.handler.IbanityResponseHandler;
import com.ibanity.apis.client.mappers.IsabelModelMapper;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.isabel_connect.models.BulkPaymentInitiationRequest;
import com.ibanity.apis.client.products.isabel_connect.models.create.BulkPaymentInitiationRequestCreateQuery;
import com.ibanity.apis.client.products.isabel_connect.models.read.BulkPaymentInitiationRequestReadQuery;
import com.ibanity.apis.client.products.isabel_connect.services.BulkPaymentInitiationRequestService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;

public class BulkPaymentInitiationRequestServiceImpl
implements BulkPaymentInitiationRequestService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityResponseHandler ibanityResponseHandler;
    private final IbanityHttpClient ibanityHttpClient;

    public BulkPaymentInitiationRequestServiceImpl(ApiUrlProvider apiUrlProvider, IbanityResponseHandler ibanityResponseHandler, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityResponseHandler = ibanityResponseHandler;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public BulkPaymentInitiationRequest create(BulkPaymentInitiationRequestCreateQuery query) {
        URI url = URIHelper.buildUri(this.getUrl());
        HttpPost httpPost = new HttpPost(url);
        this.setHeaders(httpPost, query);
        FileEntity entity = query.getFile() != null ? new FileEntity(query.getFile()) : new StringEntity(query.getContent());
        entity.setChunked(true);
        httpPost.setEntity((HttpEntity)entity);
        HttpResponse res = this.execute(query.getAdditionalHeaders(), query.getAccessToken(), (HttpRequestBase)httpPost);
        return IsabelModelMapper.mapResource(res, BulkPaymentInitiationRequest.class);
    }

    private void setHeaders(HttpPost httpPost, BulkPaymentInitiationRequestCreateQuery query) {
        httpPost.setHeader("Accept", "application/vnd.api+json");
        httpPost.setHeader("Content-Type", "application/xml");
        httpPost.setHeader("Content-Disposition", "inline; filename=" + query.getFilename());
        if (query.getShared() != null) {
            httpPost.setHeader("Is-Shared", query.getShared().toString());
        }
        if (query.getHideDetails() != null) {
            httpPost.setHeader("Hide-Details", query.getHideDetails().toString());
        }
    }

    @Override
    public BulkPaymentInitiationRequest find(BulkPaymentInitiationRequestReadQuery query) {
        URI uri = URIHelper.buildUri(this.getUrl(query.getBulkPaymentInitiationRequestId()));
        HttpResponse response = this.ibanityHttpClient.get(uri, query.getAdditionalHeaders(), query.getAccessToken());
        return IsabelModelMapper.mapResource(response, BulkPaymentInitiationRequest.class);
    }

    private String getUrl() {
        return this.getUrl("");
    }

    private String getUrl(String bulkPaymentInitiationRequestId) {
        String url = this.apiUrlProvider.find(IbanityProduct.IsabelConnect, "bulkPaymentInitiationRequests").replace("{bulkPaymentInitiationRequestId}", bulkPaymentInitiationRequestId);
        return StringUtils.removeEnd((String)url, (String)"/");
    }

    private HttpResponse execute(@NonNull Map<String, String> additionalHeaders, String customerAccessToken, HttpRequestBase httpRequestBase) {
        if (additionalHeaders == null) {
            throw new NullPointerException("additionalHeaders is marked non-null but is null");
        }
        try {
            this.addHeaders(httpRequestBase, customerAccessToken, additionalHeaders);
            return this.ibanityResponseHandler.handleResponse(this.ibanityHttpClient.httpClient().execute((HttpUriRequest)httpRequestBase));
        }
        catch (IOException exception) {
            throw new RuntimeException("An error occurred while connecting to Ibanity", exception);
        }
    }

    private void addHeaders(HttpRequestBase httpRequestBase, String customerAccessToken, Map<String, String> additionalHeaders) {
        this.addAuthorizationHeader(httpRequestBase, customerAccessToken);
        additionalHeaders.forEach((arg_0, arg_1) -> ((HttpRequestBase)httpRequestBase).addHeader(arg_0, arg_1));
    }

    private void addAuthorizationHeader(HttpRequestBase requestBase, String customerAccessToken) {
        if (StringUtils.isNotBlank((CharSequence)customerAccessToken)) {
            requestBase.addHeader((Header)new BasicHeader("Authorization", "Bearer " + customerAccessToken));
        }
    }
}

