/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.ponto_connect.sandbox.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.models.IbanityCollection;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.ponto_connect.sandbox.models.FinancialInstitutionAccount;
import com.ibanity.apis.client.products.ponto_connect.sandbox.models.factory.read.FinancialInstitutionAccountReadQuery;
import com.ibanity.apis.client.products.ponto_connect.sandbox.models.factory.read.FinancialInstitutionAccountsReadQuery;
import com.ibanity.apis.client.products.ponto_connect.sandbox.services.FinancialInstitutionAccountsService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class FinancialInstitutionAccountsServiceImpl
implements FinancialInstitutionAccountsService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public FinancialInstitutionAccountsServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public FinancialInstitutionAccount find(FinancialInstitutionAccountReadQuery accountReadQuery) {
        String url = this.getUrl(accountReadQuery.getFinancialInstitutionId().toString(), accountReadQuery.getFinancialInstitutionAccountId().toString());
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url), accountReadQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, FinancialInstitutionAccount.class);
    }

    @Override
    public IbanityCollection<FinancialInstitutionAccount> list(FinancialInstitutionAccountsReadQuery accountsReadQuery) {
        String url = this.getUrl(accountsReadQuery.getFinancialInstitutionId().toString(), "");
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url, accountsReadQuery.getPagingSpec()), accountsReadQuery.getAccessToken());
        return IbanityModelMapper.mapCollection(response, FinancialInstitutionAccount.class);
    }

    private String getUrl(String financialInstitutionId, String financialInstitutionAccountId) {
        return StringUtils.removeEnd((String)this.apiUrlProvider.find(IbanityProduct.PontoConnect, "sandbox", "financialInstitution", "financialInstitutionAccounts").replace("{financialInstitutionId}", financialInstitutionId).replace("{financialInstitutionAccountId}", financialInstitutionAccountId), (String)"/");
    }
}

