/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.ponto_connect.sandbox.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.RequestApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityCollection;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.ponto_connect.sandbox.models.FinancialInstitutionTransaction;
import com.ibanity.apis.client.products.ponto_connect.sandbox.models.factory.create.FinancialInstitutionTransactionCreationQuery;
import com.ibanity.apis.client.products.ponto_connect.sandbox.models.factory.read.FinancialInstitutionTransactionReadQuery;
import com.ibanity.apis.client.products.ponto_connect.sandbox.models.factory.read.FinancialInstitutionTransactionsReadQuery;
import com.ibanity.apis.client.products.ponto_connect.sandbox.models.factory.update.FinancialInstitutionTransactionUpdateQuery;
import com.ibanity.apis.client.products.ponto_connect.sandbox.services.FinancialInstitutionTransactionsService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class FinancialInstitutionTransactionsServiceImpl
implements FinancialInstitutionTransactionsService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public FinancialInstitutionTransactionsServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public FinancialInstitutionTransaction find(FinancialInstitutionTransactionReadQuery readQuery) {
        String url = this.getUrl(readQuery.getFinancialInstitutionId().toString(), readQuery.getFinancialInstitutionAccountId().toString(), readQuery.getFinancialInstitutionTransactionId().toString());
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url), readQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, FinancialInstitutionTransaction.class);
    }

    @Override
    public IbanityCollection<FinancialInstitutionTransaction> list(FinancialInstitutionTransactionsReadQuery readQuery) {
        String url = this.getUrl(readQuery.getFinancialInstitutionId().toString(), readQuery.getFinancialInstitutionAccountId().toString(), "");
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(url, readQuery.getPagingSpec()), readQuery.getAccessToken());
        return IbanityModelMapper.mapCollection(response, FinancialInstitutionTransaction.class);
    }

    @Override
    public FinancialInstitutionTransaction create(FinancialInstitutionTransactionCreationQuery creationQuery) {
        FinancialInstitutionTransaction transaction = this.requestMapping(creationQuery);
        String url = this.getUrl(creationQuery.getFinancialInstitutionId().toString(), creationQuery.getFinancialInstitutionAccountId().toString(), "");
        RequestApiModel request = ModelMapperHelper.buildRequest("financialInstitutionTransaction", transaction);
        HttpResponse response = this.ibanityHttpClient.post(URIHelper.buildUri(url), request, creationQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, FinancialInstitutionTransaction.class);
    }

    @Override
    public FinancialInstitutionTransaction update(FinancialInstitutionTransactionUpdateQuery transactionUpdateQuery) {
        FinancialInstitutionTransaction transaction = this.requestMapping(transactionUpdateQuery);
        String url = this.getUrl(transactionUpdateQuery.getFinancialInstitutionId().toString(), transactionUpdateQuery.getFinancialInstitutionAccountId().toString(), transactionUpdateQuery.getFinancialInstitutionTransactionId().toString());
        RequestApiModel request = ModelMapperHelper.buildRequest("financialInstitutionTransaction", transaction);
        HttpResponse response = this.ibanityHttpClient.patch(URIHelper.buildUri(url), request, transactionUpdateQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, FinancialInstitutionTransaction.class);
    }

    private String getUrl(String financialInstitutionId, String financialInstitutionAccountId, String financialInstitutionTransactionId) {
        return StringUtils.removeEnd((String)this.apiUrlProvider.find(IbanityProduct.PontoConnect, "sandbox", "financialInstitution", "financialInstitutionAccount", "financialInstitutionTransactions").replace("{financialInstitutionId}", financialInstitutionId).replace("{financialInstitutionAccountId}", financialInstitutionAccountId).replace("{financialInstitutionTransactionId}", financialInstitutionTransactionId), (String)"/");
    }

    private FinancialInstitutionTransaction requestMapping(FinancialInstitutionTransactionCreationQuery transactionCreationQuery) {
        return ((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)FinancialInstitutionTransaction.builder().amount(transactionCreationQuery.getAmount())).currency(transactionCreationQuery.getCurrency())).remittanceInformation(transactionCreationQuery.getRemittanceInformation())).remittanceInformationType(transactionCreationQuery.getRemittanceInformationType())).counterpartName(transactionCreationQuery.getCounterpartName())).counterpartReference(transactionCreationQuery.getCounterpartReference())).valueDate(transactionCreationQuery.getValueDate())).executionDate(transactionCreationQuery.getExecutionDate())).description(transactionCreationQuery.getDescription())).bankTransactionCode(transactionCreationQuery.getBankTransactionCode())).proprietaryBankTransactionCode(transactionCreationQuery.getProprietaryBankTransactionCode())).additionalInformation(transactionCreationQuery.getAdditionalInformation())).creditorId(transactionCreationQuery.getCreditorId())).mandateId(transactionCreationQuery.getMandateId())).purposeCode(transactionCreationQuery.getPurposeCode())).endToEndId(transactionCreationQuery.getEndToEndId())).cardReference(transactionCreationQuery.getCardReference())).cardReferenceType(transactionCreationQuery.getCardReferenceType())).fee(transactionCreationQuery.getFee())).automaticBooking(transactionCreationQuery.isAutomaticBooking())).build();
    }

    private FinancialInstitutionTransaction requestMapping(FinancialInstitutionTransactionUpdateQuery transactionUpdateQuery) {
        return ((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)((FinancialInstitutionTransaction.FinancialInstitutionTransactionBuilder)FinancialInstitutionTransaction.builder().remittanceInformation(transactionUpdateQuery.getRemittanceInformation())).counterpartName(transactionUpdateQuery.getCounterpartName())).description(transactionUpdateQuery.getDescription())).bankTransactionCode(transactionUpdateQuery.getBankTransactionCode())).proprietaryBankTransactionCode(transactionUpdateQuery.getProprietaryBankTransactionCode())).additionalInformation(transactionUpdateQuery.getAdditionalInformation())).creditorId(transactionUpdateQuery.getCreditorId())).mandateId(transactionUpdateQuery.getMandateId())).purposeCode(transactionUpdateQuery.getPurposeCode())).endToEndId(transactionUpdateQuery.getEndToEndId())).build();
    }
}

