/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.ponto_connect.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.RelationshipsApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.models.IbanityCollection;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.paging.IbanityPagingSpec;
import com.ibanity.apis.client.products.ponto_connect.mappers.SynchronizationMapper;
import com.ibanity.apis.client.products.ponto_connect.models.Account;
import com.ibanity.apis.client.products.ponto_connect.models.Synchronization;
import com.ibanity.apis.client.products.ponto_connect.models.delete.AccountDeleteQuery;
import com.ibanity.apis.client.products.ponto_connect.models.read.AccountReadQuery;
import com.ibanity.apis.client.products.ponto_connect.models.read.AccountsReadQuery;
import com.ibanity.apis.client.products.ponto_connect.services.AccountService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.util.UUID;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class AccountServiceImpl
implements AccountService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public AccountServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public Account find(AccountReadQuery accountReadQuery) {
        String uri = this.getUrl() + "/" + accountReadQuery.getAccountId();
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(uri), accountReadQuery.getAdditionalHeaders(), accountReadQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, this.customMappingFunction());
    }

    @Override
    public IbanityCollection<Account> list(AccountsReadQuery accountsReadQuery) {
        IbanityPagingSpec pagingSpec = accountsReadQuery.getPagingSpec();
        if (pagingSpec == null) {
            pagingSpec = IbanityPagingSpec.DEFAULT_PAGING_SPEC;
        }
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(this.getUrl(), pagingSpec), accountsReadQuery.getAdditionalHeaders(), accountsReadQuery.getAccessToken());
        return IbanityModelMapper.mapCollection(response, this.customMappingFunction());
    }

    @Override
    public Account delete(AccountDeleteQuery accountDeleteQuery) {
        String uri = this.getUrl() + "/" + accountDeleteQuery.getAccountId();
        HttpResponse response = this.ibanityHttpClient.delete(URIHelper.buildUri(uri), accountDeleteQuery.getAdditionalHeaders(), accountDeleteQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, this.customMappingFunction());
    }

    private String getUrl() {
        String url = this.apiUrlProvider.find(IbanityProduct.PontoConnect, "accounts").replace("{accountId}", "");
        return StringUtils.removeEnd((String)url, (String)"/");
    }

    private Function<DataApiModel, Account> customMappingFunction() {
        return dataApiModel -> {
            RelationshipsApiModel financialInstitution;
            Account account = IbanityModelMapper.toIbanityModel(dataApiModel, Account.class);
            if (dataApiModel.getMeta() != null) {
                Synchronization synchronization = SynchronizationMapper.map(dataApiModel.getMeta().getLatestSynchronization());
                account.setLatestSynchronization(synchronization);
                account.setSynchronizedAt(dataApiModel.getMeta().getSynchronizedAt());
            }
            if ((financialInstitution = dataApiModel.getRelationships().get("financialInstitution")) != null) {
                account.setFinancialInstitutionId(UUID.fromString(financialInstitution.getData().getId()));
            }
            return account;
        };
    }
}

