/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.ponto_connect.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.RequestApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityModel;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.ponto_connect.models.create.BulkPaymentCreateQuery;
import com.ibanity.apis.client.products.ponto_connect.models.delete.BulkPaymentDeleteQuery;
import com.ibanity.apis.client.products.ponto_connect.models.read.BulkPaymentReadQuery;
import com.ibanity.apis.client.products.ponto_connect.services.BulkPaymentService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.math.BigDecimal;
import java.net.URI;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class BulkPaymentServiceImpl
implements BulkPaymentService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public BulkPaymentServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public com.ibanity.apis.client.products.ponto_connect.models.BulkPayment find(BulkPaymentReadQuery bulkPaymentReadQuery) {
        URI uri = URIHelper.buildUri(this.getUrl(bulkPaymentReadQuery.getAccountId().toString(), bulkPaymentReadQuery.getBulkPaymentId().toString()));
        HttpResponse response = this.ibanityHttpClient.get(uri, bulkPaymentReadQuery.getAdditionalHeaders(), bulkPaymentReadQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, com.ibanity.apis.client.products.ponto_connect.models.BulkPayment.class);
    }

    @Override
    public com.ibanity.apis.client.products.ponto_connect.models.BulkPayment create(BulkPaymentCreateQuery bulkPaymentCreateQuery) {
        URI uri = URIHelper.buildUri(this.getUrl(bulkPaymentCreateQuery.getAccountId().toString(), ""));
        BulkPayment bulkPayment = this.toRequest(bulkPaymentCreateQuery);
        RequestApiModel requestApiModel = ModelMapperHelper.buildRequest("bulkPayment", bulkPayment);
        HttpResponse response = this.ibanityHttpClient.post(uri, requestApiModel, bulkPaymentCreateQuery.getAdditionalHeaders(), bulkPaymentCreateQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, this.customMapping());
    }

    private Function<DataApiModel, com.ibanity.apis.client.products.ponto_connect.models.BulkPayment> customMapping() {
        return dataApiModel -> {
            com.ibanity.apis.client.products.ponto_connect.models.BulkPayment payment = IbanityModelMapper.toIbanityModel(dataApiModel, com.ibanity.apis.client.products.ponto_connect.models.BulkPayment.class);
            if (dataApiModel.getLinks() != null) {
                payment.setRedirectLink(dataApiModel.getLinks().getRedirect());
            }
            return payment;
        };
    }

    @Override
    public com.ibanity.apis.client.products.ponto_connect.models.BulkPayment delete(BulkPaymentDeleteQuery bulkPaymentDeleteQuery) {
        URI uri = URIHelper.buildUri(this.getUrl(bulkPaymentDeleteQuery.getAccountId().toString(), bulkPaymentDeleteQuery.getBulkPaymentId().toString()));
        HttpResponse response = this.ibanityHttpClient.delete(uri, bulkPaymentDeleteQuery.getAdditionalHeaders(), bulkPaymentDeleteQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, com.ibanity.apis.client.products.ponto_connect.models.BulkPayment.class);
    }

    private String getUrl(String accountId, String bulkPaymentId) {
        return StringUtils.removeEnd((String)this.apiUrlProvider.find(IbanityProduct.PontoConnect, "account", "bulkPayments").replace("{accountId}", accountId).replace("{bulkPaymentId}", bulkPaymentId), (String)"/");
    }

    private BulkPayment toRequest(BulkPaymentCreateQuery bulkPaymentCreateQuery) {
        return BulkPayment.builder().requestedExecutionDate(bulkPaymentCreateQuery.getRequestedExecutionDate()).reference(bulkPaymentCreateQuery.getReference()).redirectUri(bulkPaymentCreateQuery.getRedirectUri()).batchBookingPreferred(bulkPaymentCreateQuery.isBatchBookingPreferred()).payments(bulkPaymentCreateQuery.getPayments().stream().map(this::toPayment).collect(Collectors.toList())).build();
    }

    private BulkPayment.Payment toPayment(BulkPaymentCreateQuery.Payment payment) {
        return BulkPayment.Payment.builder().amount(payment.getAmount()).creditorAccountReference(payment.getCreditorAccountReference()).creditorAccountReferenceType(payment.getCreditorAccountReferenceType()).creditorAgent(payment.getCreditorAgent()).creditorAgentType(payment.getCreditorAgentType()).creditorName(payment.getCreditorName()).currency(payment.getCurrency()).remittanceInformation(payment.getRemittanceInformation()).remittanceInformationType(payment.getRemittanceInformationType()).build();
    }

    private static class BulkPayment
    implements IbanityModel {
        public static final String RESOURCE_TYPE = "bulkPayment";
        public static final String API_URL_TAG_ID = "{bulkPaymentId}";
        private UUID id;
        private String selfLink;
        private String requestId;
        private String status;
        private LocalDate requestedExecutionDate;
        private String reference;
        private String redirectUri;
        private boolean batchBookingPreferred;
        private List<Payment> payments;

        @Generated
        private static List<Payment> $default$payments() {
            return Collections.emptyList();
        }

        @Generated
        public static BulkPaymentBuilder builder() {
            return new BulkPaymentBuilder();
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public String getSelfLink() {
            return this.selfLink;
        }

        @Generated
        public String getRequestId() {
            return this.requestId;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public LocalDate getRequestedExecutionDate() {
            return this.requestedExecutionDate;
        }

        @Generated
        public String getReference() {
            return this.reference;
        }

        @Generated
        public String getRedirectUri() {
            return this.redirectUri;
        }

        @Generated
        public boolean isBatchBookingPreferred() {
            return this.batchBookingPreferred;
        }

        @Generated
        public List<Payment> getPayments() {
            return this.payments;
        }

        @Override
        @Generated
        public void setId(UUID id) {
            this.id = id;
        }

        @Override
        @Generated
        public void setSelfLink(String selfLink) {
            this.selfLink = selfLink;
        }

        @Override
        @Generated
        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
            this.requestedExecutionDate = requestedExecutionDate;
        }

        @Generated
        public void setReference(String reference) {
            this.reference = reference;
        }

        @Generated
        public void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @Generated
        public void setBatchBookingPreferred(boolean batchBookingPreferred) {
            this.batchBookingPreferred = batchBookingPreferred;
        }

        @Generated
        public void setPayments(List<Payment> payments) {
            this.payments = payments;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BulkPayment)) {
                return false;
            }
            BulkPayment other = (BulkPayment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isBatchBookingPreferred() != other.isBatchBookingPreferred()) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$selfLink = this.getSelfLink();
            String other$selfLink = other.getSelfLink();
            if (this$selfLink == null ? other$selfLink != null : !this$selfLink.equals(other$selfLink)) {
                return false;
            }
            String this$requestId = this.getRequestId();
            String other$requestId = other.getRequestId();
            if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            LocalDate this$requestedExecutionDate = this.getRequestedExecutionDate();
            LocalDate other$requestedExecutionDate = other.getRequestedExecutionDate();
            if (this$requestedExecutionDate == null ? other$requestedExecutionDate != null : !((Object)this$requestedExecutionDate).equals(other$requestedExecutionDate)) {
                return false;
            }
            String this$reference = this.getReference();
            String other$reference = other.getReference();
            if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                return false;
            }
            String this$redirectUri = this.getRedirectUri();
            String other$redirectUri = other.getRedirectUri();
            if (this$redirectUri == null ? other$redirectUri != null : !this$redirectUri.equals(other$redirectUri)) {
                return false;
            }
            List<Payment> this$payments = this.getPayments();
            List<Payment> other$payments = other.getPayments();
            return !(this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BulkPayment;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isBatchBookingPreferred() ? 79 : 97);
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $selfLink = this.getSelfLink();
            result = result * 59 + ($selfLink == null ? 43 : $selfLink.hashCode());
            String $requestId = this.getRequestId();
            result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            LocalDate $requestedExecutionDate = this.getRequestedExecutionDate();
            result = result * 59 + ($requestedExecutionDate == null ? 43 : ((Object)$requestedExecutionDate).hashCode());
            String $reference = this.getReference();
            result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
            String $redirectUri = this.getRedirectUri();
            result = result * 59 + ($redirectUri == null ? 43 : $redirectUri.hashCode());
            List<Payment> $payments = this.getPayments();
            result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BulkPaymentServiceImpl.BulkPayment(id=" + this.getId() + ", selfLink=" + this.getSelfLink() + ", requestId=" + this.getRequestId() + ", status=" + this.getStatus() + ", requestedExecutionDate=" + this.getRequestedExecutionDate() + ", reference=" + this.getReference() + ", redirectUri=" + this.getRedirectUri() + ", batchBookingPreferred=" + this.isBatchBookingPreferred() + ", payments=" + this.getPayments() + ")";
        }

        @Generated
        public BulkPayment() {
            this.payments = BulkPayment.$default$payments();
        }

        @Generated
        private BulkPayment(UUID id, String selfLink, String requestId, String status, LocalDate requestedExecutionDate, String reference, String redirectUri, boolean batchBookingPreferred, List<Payment> payments) {
            this.id = id;
            this.selfLink = selfLink;
            this.requestId = requestId;
            this.status = status;
            this.requestedExecutionDate = requestedExecutionDate;
            this.reference = reference;
            this.redirectUri = redirectUri;
            this.batchBookingPreferred = batchBookingPreferred;
            this.payments = payments;
        }

        @Generated
        public static class BulkPaymentBuilder {
            @Generated
            private UUID id;
            @Generated
            private String selfLink;
            @Generated
            private String requestId;
            @Generated
            private String status;
            @Generated
            private LocalDate requestedExecutionDate;
            @Generated
            private String reference;
            @Generated
            private String redirectUri;
            @Generated
            private boolean batchBookingPreferred;
            @Generated
            private boolean payments$set;
            @Generated
            private List<Payment> payments$value;

            @Generated
            BulkPaymentBuilder() {
            }

            @Generated
            public BulkPaymentBuilder id(UUID id) {
                this.id = id;
                return this;
            }

            @Generated
            public BulkPaymentBuilder selfLink(String selfLink) {
                this.selfLink = selfLink;
                return this;
            }

            @Generated
            public BulkPaymentBuilder requestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Generated
            public BulkPaymentBuilder status(String status) {
                this.status = status;
                return this;
            }

            @Generated
            public BulkPaymentBuilder requestedExecutionDate(LocalDate requestedExecutionDate) {
                this.requestedExecutionDate = requestedExecutionDate;
                return this;
            }

            @Generated
            public BulkPaymentBuilder reference(String reference) {
                this.reference = reference;
                return this;
            }

            @Generated
            public BulkPaymentBuilder redirectUri(String redirectUri) {
                this.redirectUri = redirectUri;
                return this;
            }

            @Generated
            public BulkPaymentBuilder batchBookingPreferred(boolean batchBookingPreferred) {
                this.batchBookingPreferred = batchBookingPreferred;
                return this;
            }

            @Generated
            public BulkPaymentBuilder payments(List<Payment> payments) {
                this.payments$value = payments;
                this.payments$set = true;
                return this;
            }

            @Generated
            public BulkPayment build() {
                List payments$value = this.payments$value;
                if (!this.payments$set) {
                    payments$value = BulkPayment.$default$payments();
                }
                return new BulkPayment(this.id, this.selfLink, this.requestId, this.status, this.requestedExecutionDate, this.reference, this.redirectUri, this.batchBookingPreferred, payments$value);
            }

            @Generated
            public String toString() {
                return "BulkPaymentServiceImpl.BulkPayment.BulkPaymentBuilder(id=" + this.id + ", selfLink=" + this.selfLink + ", requestId=" + this.requestId + ", status=" + this.status + ", requestedExecutionDate=" + this.requestedExecutionDate + ", reference=" + this.reference + ", redirectUri=" + this.redirectUri + ", batchBookingPreferred=" + this.batchBookingPreferred + ", payments$value=" + this.payments$value + ")";
            }
        }

        private static class Payment {
            private String remittanceInformationType;
            private String remittanceInformation;
            private String currency;
            private String creditorName;
            private String creditorAgentType;
            private String creditorAgent;
            private String creditorAccountReferenceType;
            private String creditorAccountReference;
            private BigDecimal amount;

            @Generated
            public static PaymentBuilder builder() {
                return new PaymentBuilder();
            }

            @Generated
            public String getRemittanceInformationType() {
                return this.remittanceInformationType;
            }

            @Generated
            public String getRemittanceInformation() {
                return this.remittanceInformation;
            }

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public String getCreditorName() {
                return this.creditorName;
            }

            @Generated
            public String getCreditorAgentType() {
                return this.creditorAgentType;
            }

            @Generated
            public String getCreditorAgent() {
                return this.creditorAgent;
            }

            @Generated
            public String getCreditorAccountReferenceType() {
                return this.creditorAccountReferenceType;
            }

            @Generated
            public String getCreditorAccountReference() {
                return this.creditorAccountReference;
            }

            @Generated
            public BigDecimal getAmount() {
                return this.amount;
            }

            @Generated
            public void setRemittanceInformationType(String remittanceInformationType) {
                this.remittanceInformationType = remittanceInformationType;
            }

            @Generated
            public void setRemittanceInformation(String remittanceInformation) {
                this.remittanceInformation = remittanceInformation;
            }

            @Generated
            public void setCurrency(String currency) {
                this.currency = currency;
            }

            @Generated
            public void setCreditorName(String creditorName) {
                this.creditorName = creditorName;
            }

            @Generated
            public void setCreditorAgentType(String creditorAgentType) {
                this.creditorAgentType = creditorAgentType;
            }

            @Generated
            public void setCreditorAgent(String creditorAgent) {
                this.creditorAgent = creditorAgent;
            }

            @Generated
            public void setCreditorAccountReferenceType(String creditorAccountReferenceType) {
                this.creditorAccountReferenceType = creditorAccountReferenceType;
            }

            @Generated
            public void setCreditorAccountReference(String creditorAccountReference) {
                this.creditorAccountReference = creditorAccountReference;
            }

            @Generated
            public void setAmount(BigDecimal amount) {
                this.amount = amount;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Payment)) {
                    return false;
                }
                Payment other = (Payment)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$remittanceInformationType = this.getRemittanceInformationType();
                String other$remittanceInformationType = other.getRemittanceInformationType();
                if (this$remittanceInformationType == null ? other$remittanceInformationType != null : !this$remittanceInformationType.equals(other$remittanceInformationType)) {
                    return false;
                }
                String this$remittanceInformation = this.getRemittanceInformation();
                String other$remittanceInformation = other.getRemittanceInformation();
                if (this$remittanceInformation == null ? other$remittanceInformation != null : !this$remittanceInformation.equals(other$remittanceInformation)) {
                    return false;
                }
                String this$currency = this.getCurrency();
                String other$currency = other.getCurrency();
                if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                    return false;
                }
                String this$creditorName = this.getCreditorName();
                String other$creditorName = other.getCreditorName();
                if (this$creditorName == null ? other$creditorName != null : !this$creditorName.equals(other$creditorName)) {
                    return false;
                }
                String this$creditorAgentType = this.getCreditorAgentType();
                String other$creditorAgentType = other.getCreditorAgentType();
                if (this$creditorAgentType == null ? other$creditorAgentType != null : !this$creditorAgentType.equals(other$creditorAgentType)) {
                    return false;
                }
                String this$creditorAgent = this.getCreditorAgent();
                String other$creditorAgent = other.getCreditorAgent();
                if (this$creditorAgent == null ? other$creditorAgent != null : !this$creditorAgent.equals(other$creditorAgent)) {
                    return false;
                }
                String this$creditorAccountReferenceType = this.getCreditorAccountReferenceType();
                String other$creditorAccountReferenceType = other.getCreditorAccountReferenceType();
                if (this$creditorAccountReferenceType == null ? other$creditorAccountReferenceType != null : !this$creditorAccountReferenceType.equals(other$creditorAccountReferenceType)) {
                    return false;
                }
                String this$creditorAccountReference = this.getCreditorAccountReference();
                String other$creditorAccountReference = other.getCreditorAccountReference();
                if (this$creditorAccountReference == null ? other$creditorAccountReference != null : !this$creditorAccountReference.equals(other$creditorAccountReference)) {
                    return false;
                }
                BigDecimal this$amount = this.getAmount();
                BigDecimal other$amount = other.getAmount();
                return !(this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Payment;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $remittanceInformationType = this.getRemittanceInformationType();
                result = result * 59 + ($remittanceInformationType == null ? 43 : $remittanceInformationType.hashCode());
                String $remittanceInformation = this.getRemittanceInformation();
                result = result * 59 + ($remittanceInformation == null ? 43 : $remittanceInformation.hashCode());
                String $currency = this.getCurrency();
                result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                String $creditorName = this.getCreditorName();
                result = result * 59 + ($creditorName == null ? 43 : $creditorName.hashCode());
                String $creditorAgentType = this.getCreditorAgentType();
                result = result * 59 + ($creditorAgentType == null ? 43 : $creditorAgentType.hashCode());
                String $creditorAgent = this.getCreditorAgent();
                result = result * 59 + ($creditorAgent == null ? 43 : $creditorAgent.hashCode());
                String $creditorAccountReferenceType = this.getCreditorAccountReferenceType();
                result = result * 59 + ($creditorAccountReferenceType == null ? 43 : $creditorAccountReferenceType.hashCode());
                String $creditorAccountReference = this.getCreditorAccountReference();
                result = result * 59 + ($creditorAccountReference == null ? 43 : $creditorAccountReference.hashCode());
                BigDecimal $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "BulkPaymentServiceImpl.BulkPayment.Payment(remittanceInformationType=" + this.getRemittanceInformationType() + ", remittanceInformation=" + this.getRemittanceInformation() + ", currency=" + this.getCurrency() + ", creditorName=" + this.getCreditorName() + ", creditorAgentType=" + this.getCreditorAgentType() + ", creditorAgent=" + this.getCreditorAgent() + ", creditorAccountReferenceType=" + this.getCreditorAccountReferenceType() + ", creditorAccountReference=" + this.getCreditorAccountReference() + ", amount=" + this.getAmount() + ")";
            }

            @Generated
            public Payment() {
            }

            @Generated
            private Payment(String remittanceInformationType, String remittanceInformation, String currency, String creditorName, String creditorAgentType, String creditorAgent, String creditorAccountReferenceType, String creditorAccountReference, BigDecimal amount) {
                this.remittanceInformationType = remittanceInformationType;
                this.remittanceInformation = remittanceInformation;
                this.currency = currency;
                this.creditorName = creditorName;
                this.creditorAgentType = creditorAgentType;
                this.creditorAgent = creditorAgent;
                this.creditorAccountReferenceType = creditorAccountReferenceType;
                this.creditorAccountReference = creditorAccountReference;
                this.amount = amount;
            }

            @Generated
            public static class PaymentBuilder {
                @Generated
                private String remittanceInformationType;
                @Generated
                private String remittanceInformation;
                @Generated
                private String currency;
                @Generated
                private String creditorName;
                @Generated
                private String creditorAgentType;
                @Generated
                private String creditorAgent;
                @Generated
                private String creditorAccountReferenceType;
                @Generated
                private String creditorAccountReference;
                @Generated
                private BigDecimal amount;

                @Generated
                PaymentBuilder() {
                }

                @Generated
                public PaymentBuilder remittanceInformationType(String remittanceInformationType) {
                    this.remittanceInformationType = remittanceInformationType;
                    return this;
                }

                @Generated
                public PaymentBuilder remittanceInformation(String remittanceInformation) {
                    this.remittanceInformation = remittanceInformation;
                    return this;
                }

                @Generated
                public PaymentBuilder currency(String currency) {
                    this.currency = currency;
                    return this;
                }

                @Generated
                public PaymentBuilder creditorName(String creditorName) {
                    this.creditorName = creditorName;
                    return this;
                }

                @Generated
                public PaymentBuilder creditorAgentType(String creditorAgentType) {
                    this.creditorAgentType = creditorAgentType;
                    return this;
                }

                @Generated
                public PaymentBuilder creditorAgent(String creditorAgent) {
                    this.creditorAgent = creditorAgent;
                    return this;
                }

                @Generated
                public PaymentBuilder creditorAccountReferenceType(String creditorAccountReferenceType) {
                    this.creditorAccountReferenceType = creditorAccountReferenceType;
                    return this;
                }

                @Generated
                public PaymentBuilder creditorAccountReference(String creditorAccountReference) {
                    this.creditorAccountReference = creditorAccountReference;
                    return this;
                }

                @Generated
                public PaymentBuilder amount(BigDecimal amount) {
                    this.amount = amount;
                    return this;
                }

                @Generated
                public Payment build() {
                    return new Payment(this.remittanceInformationType, this.remittanceInformation, this.currency, this.creditorName, this.creditorAgentType, this.creditorAgent, this.creditorAccountReferenceType, this.creditorAccountReference, this.amount);
                }

                @Generated
                public String toString() {
                    return "BulkPaymentServiceImpl.BulkPayment.Payment.PaymentBuilder(remittanceInformationType=" + this.remittanceInformationType + ", remittanceInformation=" + this.remittanceInformation + ", currency=" + this.currency + ", creditorName=" + this.creditorName + ", creditorAgentType=" + this.creditorAgentType + ", creditorAgent=" + this.creditorAgent + ", creditorAccountReferenceType=" + this.creditorAccountReferenceType + ", creditorAccountReference=" + this.creditorAccountReference + ", amount=" + this.amount + ")";
                }
            }
        }
    }
}

