/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.ponto_connect.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.models.IbanityCollection;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.paging.IbanityPagingSpec;
import com.ibanity.apis.client.products.ponto_connect.models.FinancialInstitution;
import com.ibanity.apis.client.products.ponto_connect.models.read.FinancialInstitutionReadQuery;
import com.ibanity.apis.client.products.ponto_connect.models.read.FinancialInstitutionsReadQuery;
import com.ibanity.apis.client.products.ponto_connect.models.read.OrganizationFinancialInstitutionReadQuery;
import com.ibanity.apis.client.products.ponto_connect.models.read.OrganizationFinancialInstitutionsReadQuery;
import com.ibanity.apis.client.products.ponto_connect.services.FinancialInstitutionService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class FinancialInstitutionServiceImpl
implements FinancialInstitutionService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public FinancialInstitutionServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public FinancialInstitution find(FinancialInstitutionReadQuery financialInstitutionReadQuery) {
        URI uri = URIHelper.buildUri(this.getUrl() + "/" + financialInstitutionReadQuery.getFinancialInstitutionId().toString());
        HttpResponse response = this.ibanityHttpClient.get(uri, financialInstitutionReadQuery.getAdditionalHeaders(), null);
        return IbanityModelMapper.mapResource(response, FinancialInstitution.class);
    }

    @Override
    public FinancialInstitution find(OrganizationFinancialInstitutionReadQuery organizationFinancialInstitutionReadQuery) {
        URI uri = URIHelper.buildUri(this.getUrl() + "/" + organizationFinancialInstitutionReadQuery.getFinancialInstitutionId().toString());
        HttpResponse response = this.ibanityHttpClient.get(uri, organizationFinancialInstitutionReadQuery.getAdditionalHeaders(), organizationFinancialInstitutionReadQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, FinancialInstitution.class);
    }

    @Override
    public IbanityCollection<FinancialInstitution> list(OrganizationFinancialInstitutionsReadQuery organizationFinancialInstitutionsReadQuery) {
        IbanityPagingSpec pagingSpec = organizationFinancialInstitutionsReadQuery.getPagingSpec();
        if (pagingSpec == null) {
            pagingSpec = IbanityPagingSpec.DEFAULT_PAGING_SPEC;
        }
        URI url = URIHelper.buildUri(this.getUrl(), pagingSpec);
        HttpResponse response = this.ibanityHttpClient.get(url, organizationFinancialInstitutionsReadQuery.getAdditionalHeaders(), organizationFinancialInstitutionsReadQuery.getAccessToken());
        return IbanityModelMapper.mapCollection(response, FinancialInstitution.class);
    }

    @Override
    public IbanityCollection<FinancialInstitution> list(FinancialInstitutionsReadQuery financialInstitutionsReadQuery) {
        IbanityPagingSpec pagingSpec = financialInstitutionsReadQuery.getPagingSpec();
        if (pagingSpec == null) {
            pagingSpec = IbanityPagingSpec.DEFAULT_PAGING_SPEC;
        }
        URI url = URIHelper.buildUri(this.getUrl(), pagingSpec, financialInstitutionsReadQuery.getFilters());
        HttpResponse response = this.ibanityHttpClient.get(url, financialInstitutionsReadQuery.getAdditionalHeaders(), null);
        return IbanityModelMapper.mapCollection(response, FinancialInstitution.class);
    }

    private String getUrl() {
        return StringUtils.removeEnd((String)this.apiUrlProvider.find(IbanityProduct.PontoConnect, "financialInstitutions").replace("{financialInstitutionId}", ""), (String)"/");
    }
}

