/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.ponto_connect.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.RelationshipsApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.models.IbanityCollection;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.paging.IbanityPagingSpec;
import com.ibanity.apis.client.products.ponto_connect.models.IntegrationAccount;
import com.ibanity.apis.client.products.ponto_connect.models.read.IntegrationAccountsReadQuery;
import com.ibanity.apis.client.products.ponto_connect.services.IntegrationAccountService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.util.UUID;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class IntegrationAccountServiceImpl
implements IntegrationAccountService {
    private final IbanityHttpClient ibanityHttpClient;
    private final ApiUrlProvider apiUrlProvider;

    public IntegrationAccountServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.ibanityHttpClient = ibanityHttpClient;
        this.apiUrlProvider = apiUrlProvider;
    }

    @Override
    public IbanityCollection<IntegrationAccount> list(IntegrationAccountsReadQuery integrationAccountsReadQuery) {
        IbanityPagingSpec pagingSpec = integrationAccountsReadQuery.getPagingSpec();
        if (pagingSpec == null) {
            pagingSpec = IbanityPagingSpec.DEFAULT_PAGING_SPEC;
        }
        HttpResponse response = this.ibanityHttpClient.get(URIHelper.buildUri(this.getUrl(), pagingSpec), integrationAccountsReadQuery.getAdditionalHeaders(), integrationAccountsReadQuery.getAccessToken());
        return IbanityModelMapper.mapCollection(response, this.customMappingFunction());
    }

    private String getUrl() {
        String url = this.apiUrlProvider.find(IbanityProduct.PontoConnect, "integrationAccounts").replace("{integrationAccountId}", "");
        return StringUtils.removeEnd((String)url, (String)"/");
    }

    private Function<DataApiModel, IntegrationAccount> customMappingFunction() {
        return dataApiModel -> {
            RelationshipsApiModel organization;
            RelationshipsApiModel account;
            IntegrationAccount integrationAccount = IbanityModelMapper.toIbanityModel(dataApiModel, IntegrationAccount.class);
            RelationshipsApiModel financialInstitution = dataApiModel.getRelationships().get("financialInstitution");
            if (financialInstitution != null) {
                integrationAccount.setFinancialInstitutionId(UUID.fromString(financialInstitution.getData().getId()));
            }
            if ((account = dataApiModel.getRelationships().get("account")) != null) {
                integrationAccount.setAccountId(UUID.fromString(account.getData().getId()));
            }
            if ((organization = dataApiModel.getRelationships().get("organization")) != null) {
                integrationAccount.setOrganizationId(UUID.fromString(organization.getData().getId()));
            }
            return integrationAccount;
        };
    }
}

