/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.ponto_connect.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.ponto_connect.models.Integration;
import com.ibanity.apis.client.products.ponto_connect.models.delete.OrganizationIntegrationDeleteQuery;
import com.ibanity.apis.client.products.ponto_connect.services.IntegrationService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.net.URI;
import java.util.UUID;
import org.apache.http.HttpResponse;

public class IntegrationServiceImpl
implements IntegrationService {
    private ApiUrlProvider apiUrlProvider;
    private IbanityHttpClient ibanityHttpClient;

    public IntegrationServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public Integration delete(OrganizationIntegrationDeleteQuery organizationIntegrationDeleteQuery) {
        URI uri = URIHelper.buildUri(this.getUrl(organizationIntegrationDeleteQuery.getOrganizationId()));
        HttpResponse response = this.ibanityHttpClient.delete(uri, organizationIntegrationDeleteQuery.getAdditionalHeaders(), organizationIntegrationDeleteQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, Integration.class);
    }

    private String getUrl(UUID organizationId) {
        return this.apiUrlProvider.find(IbanityProduct.PontoConnect, "organizations", "integration").replace("{organizationId}", organizationId.toString());
    }
}

