/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.ponto_connect.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.RequestApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.ponto_connect.models.OnboardingDetails;
import com.ibanity.apis.client.products.ponto_connect.models.create.OnboardingDetailsCreateQuery;
import com.ibanity.apis.client.products.ponto_connect.services.OnboardingDetailsService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import org.apache.http.HttpResponse;

public class OnboardingDetailsServiceImpl
implements OnboardingDetailsService {
    private ApiUrlProvider apiUrlProvider;
    private IbanityHttpClient ibanityHttpClient;

    public OnboardingDetailsServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public OnboardingDetails create(OnboardingDetailsCreateQuery onboardingDetailsCreateQuery) {
        RequestApiModel request = ModelMapperHelper.buildRequest("onboardingDetails", this.toRequest(onboardingDetailsCreateQuery));
        HttpResponse response = this.ibanityHttpClient.post(URIHelper.buildUri(this.getUrl()), request, onboardingDetailsCreateQuery.getAdditionalHeaders(), onboardingDetailsCreateQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, OnboardingDetails.class);
    }

    private OnboardingDetails toRequest(OnboardingDetailsCreateQuery onboardingDetailsCreateQuery) {
        return OnboardingDetails.builder().addressCity(onboardingDetailsCreateQuery.getAddressCity()).addressCountry(onboardingDetailsCreateQuery.getAddressCountry()).addressPostalCode(onboardingDetailsCreateQuery.getAddressPostalCode()).addressStreetAddress(onboardingDetailsCreateQuery.getAddressStreetAddress()).email(onboardingDetailsCreateQuery.getEmail()).enterpriseNumber(onboardingDetailsCreateQuery.getEnterpriseNumber()).firstName(onboardingDetailsCreateQuery.getFirstName()).lastName(onboardingDetailsCreateQuery.getLastName()).organizationName(onboardingDetailsCreateQuery.getOrganizationName()).phoneNumber(onboardingDetailsCreateQuery.getPhoneNumber()).vatNumber(onboardingDetailsCreateQuery.getVatNumber()).initialFinancialInstitutionId(onboardingDetailsCreateQuery.getInitialFinancialInstitutionId()).partnerReference(onboardingDetailsCreateQuery.getPartnerReference()).automaticSubmissionOnCompletedForms(onboardingDetailsCreateQuery.getAutomaticSubmissionOnCompletedForms()).preferredOtpMethod(onboardingDetailsCreateQuery.getPreferredOtpMethod()).requestedOrganisationId(onboardingDetailsCreateQuery.getRequestedOrganisationId()).organizationType(onboardingDetailsCreateQuery.getOrganizationType()).build();
    }

    private String getUrl() {
        return this.apiUrlProvider.find(IbanityProduct.PontoConnect, "onboardingDetails");
    }
}

