/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.ponto_connect.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.RequestApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.ponto_connect.models.create.PaymentActivationRequestCreateQuery;
import com.ibanity.apis.client.products.ponto_connect.services.PaymentActivationRequestService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.net.URI;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class PaymentActivationRequestServiceImpl
implements PaymentActivationRequestService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public PaymentActivationRequestServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public com.ibanity.apis.client.products.ponto_connect.models.PaymentActivationRequest create(PaymentActivationRequestCreateQuery paymentActivationRequestCreateQuery) {
        URI uri = URIHelper.buildUri(this.getUrl());
        RequestApiModel requestApiModel = ModelMapperHelper.buildRequest("paymentActivationRequest", this.toRequest(paymentActivationRequestCreateQuery));
        HttpResponse response = this.ibanityHttpClient.post(uri, requestApiModel, paymentActivationRequestCreateQuery.getAdditionalHeaders(), paymentActivationRequestCreateQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, this.customMapping());
    }

    private PaymentActivationRequest toRequest(PaymentActivationRequestCreateQuery paymentActivationRequestCreateQuery) {
        return PaymentActivationRequest.builder().redirectUri(paymentActivationRequestCreateQuery.getRedirectUri()).build();
    }

    private Function<DataApiModel, com.ibanity.apis.client.products.ponto_connect.models.PaymentActivationRequest> customMapping() {
        return dataApiModel -> {
            com.ibanity.apis.client.products.ponto_connect.models.PaymentActivationRequest paymentActivationRequest = IbanityModelMapper.toIbanityModel(dataApiModel, com.ibanity.apis.client.products.ponto_connect.models.PaymentActivationRequest.class);
            paymentActivationRequest.setRedirectLink(dataApiModel.getLinks().getRedirect());
            return paymentActivationRequest;
        };
    }

    private String getUrl() {
        return StringUtils.removeEnd((String)this.apiUrlProvider.find(IbanityProduct.PontoConnect, "paymentActivationRequests"), (String)"/");
    }

    private static class PaymentActivationRequest {
        public static final String RESOURCE_TYPE = "paymentActivationRequest";
        private String redirectUri;

        @Generated
        public static PaymentActivationRequestBuilder builder() {
            return new PaymentActivationRequestBuilder();
        }

        @Generated
        public String getRedirectUri() {
            return this.redirectUri;
        }

        @Generated
        public void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentActivationRequest)) {
                return false;
            }
            PaymentActivationRequest other = (PaymentActivationRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$redirectUri = this.getRedirectUri();
            String other$redirectUri = other.getRedirectUri();
            return !(this$redirectUri == null ? other$redirectUri != null : !this$redirectUri.equals(other$redirectUri));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentActivationRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $redirectUri = this.getRedirectUri();
            result = result * 59 + ($redirectUri == null ? 43 : $redirectUri.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PaymentActivationRequestServiceImpl.PaymentActivationRequest(redirectUri=" + this.getRedirectUri() + ")";
        }

        @Generated
        public PaymentActivationRequest() {
        }

        @Generated
        private PaymentActivationRequest(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @Generated
        public static class PaymentActivationRequestBuilder {
            @Generated
            private String redirectUri;

            @Generated
            PaymentActivationRequestBuilder() {
            }

            @Generated
            public PaymentActivationRequestBuilder redirectUri(String redirectUri) {
                this.redirectUri = redirectUri;
                return this;
            }

            @Generated
            public PaymentActivationRequest build() {
                return new PaymentActivationRequest(this.redirectUri);
            }

            @Generated
            public String toString() {
                return "PaymentActivationRequestServiceImpl.PaymentActivationRequest.PaymentActivationRequestBuilder(redirectUri=" + this.redirectUri + ")";
            }
        }
    }
}

