/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.ponto_connect.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.RequestApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.ponto_connect.models.create.PaymentRequestCreateQuery;
import com.ibanity.apis.client.products.ponto_connect.models.delete.PaymentRequestDeleteQuery;
import com.ibanity.apis.client.products.ponto_connect.models.read.PaymentRequestReadQuery;
import com.ibanity.apis.client.products.ponto_connect.services.PaymentRequestService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.math.BigDecimal;
import java.net.URI;
import java.time.Instant;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class PaymentRequestServiceImpl
implements PaymentRequestService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public PaymentRequestServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public com.ibanity.apis.client.products.ponto_connect.models.PaymentRequest find(PaymentRequestReadQuery paymentRequestReadQuery) {
        URI uri = URIHelper.buildUri(this.getUrl(paymentRequestReadQuery.getAccountId()) + "/" + paymentRequestReadQuery.getPaymentRequestId().toString());
        HttpResponse response = this.ibanityHttpClient.get(uri, paymentRequestReadQuery.getAdditionalHeaders(), paymentRequestReadQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, com.ibanity.apis.client.products.ponto_connect.models.PaymentRequest.class);
    }

    @Override
    public com.ibanity.apis.client.products.ponto_connect.models.PaymentRequest create(PaymentRequestCreateQuery paymentRequestCreateQuery) {
        URI uri = URIHelper.buildUri(this.getUrl(paymentRequestCreateQuery.getAccountId()));
        PaymentRequest paymentRequest = this.toRequest(paymentRequestCreateQuery);
        RequestApiModel requestApiModel = ModelMapperHelper.buildRequest("paymentRequest", paymentRequest);
        HttpResponse response = this.ibanityHttpClient.post(uri, requestApiModel, paymentRequestCreateQuery.getAdditionalHeaders(), paymentRequestCreateQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, this.customMapping());
    }

    private Function<DataApiModel, com.ibanity.apis.client.products.ponto_connect.models.PaymentRequest> customMapping() {
        return dataApiModel -> {
            com.ibanity.apis.client.products.ponto_connect.models.PaymentRequest paymentRequest = IbanityModelMapper.toIbanityModel(dataApiModel, com.ibanity.apis.client.products.ponto_connect.models.PaymentRequest.class);
            if (dataApiModel.getLinks() != null) {
                paymentRequest.setRedirectLink(dataApiModel.getLinks().getRedirect());
            }
            return paymentRequest;
        };
    }

    @Override
    public com.ibanity.apis.client.products.ponto_connect.models.PaymentRequest delete(PaymentRequestDeleteQuery paymentRequestDeleteQuery) {
        URI uri = URIHelper.buildUri(this.getUrl(paymentRequestDeleteQuery.getAccountId()) + "/" + paymentRequestDeleteQuery.getPaymentRequestId().toString());
        HttpResponse response = this.ibanityHttpClient.delete(uri, paymentRequestDeleteQuery.getAdditionalHeaders(), paymentRequestDeleteQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, com.ibanity.apis.client.products.ponto_connect.models.PaymentRequest.class);
    }

    private String getUrl(UUID accountId) {
        return StringUtils.removeEnd((String)this.apiUrlProvider.find(IbanityProduct.PontoConnect, "account", "paymentRequests").replace("{accountId}", accountId.toString()).replace("{paymentRequestId}", ""), (String)"/");
    }

    private PaymentRequest toRequest(PaymentRequestCreateQuery paymentRequestCreateQuery) {
        return PaymentRequest.builder().amount(paymentRequestCreateQuery.getAmount()).remittanceInformation(paymentRequestCreateQuery.getRemittanceInformation()).remittanceInformationType(paymentRequestCreateQuery.getRemittanceInformationType()).redirectUri(paymentRequestCreateQuery.getRedirectUri()).endToEndId(paymentRequestCreateQuery.getEndToEndId()).build();
    }

    private static class PaymentRequest {
        private String remittanceInformationType;
        private String remittanceInformation;
        private String currency;
        private BigDecimal amount;
        private String creditorAccountReferenceType;
        private String creditorAccountReference;
        private String debtorAccountReferenceType;
        private String debtorAccountReference;
        private String redirectUri;
        private String endToEndId;
        private String signingUri;
        private Instant closedAt;
        private Instant signedAt;

        @Generated
        public static PaymentRequestBuilder builder() {
            return new PaymentRequestBuilder();
        }

        @Generated
        public String getRemittanceInformationType() {
            return this.remittanceInformationType;
        }

        @Generated
        public String getRemittanceInformation() {
            return this.remittanceInformation;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public BigDecimal getAmount() {
            return this.amount;
        }

        @Generated
        public String getCreditorAccountReferenceType() {
            return this.creditorAccountReferenceType;
        }

        @Generated
        public String getCreditorAccountReference() {
            return this.creditorAccountReference;
        }

        @Generated
        public String getDebtorAccountReferenceType() {
            return this.debtorAccountReferenceType;
        }

        @Generated
        public String getDebtorAccountReference() {
            return this.debtorAccountReference;
        }

        @Generated
        public String getRedirectUri() {
            return this.redirectUri;
        }

        @Generated
        public String getEndToEndId() {
            return this.endToEndId;
        }

        @Generated
        public String getSigningUri() {
            return this.signingUri;
        }

        @Generated
        public Instant getClosedAt() {
            return this.closedAt;
        }

        @Generated
        public Instant getSignedAt() {
            return this.signedAt;
        }

        @Generated
        public void setRemittanceInformationType(String remittanceInformationType) {
            this.remittanceInformationType = remittanceInformationType;
        }

        @Generated
        public void setRemittanceInformation(String remittanceInformation) {
            this.remittanceInformation = remittanceInformation;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        @Generated
        public void setCreditorAccountReferenceType(String creditorAccountReferenceType) {
            this.creditorAccountReferenceType = creditorAccountReferenceType;
        }

        @Generated
        public void setCreditorAccountReference(String creditorAccountReference) {
            this.creditorAccountReference = creditorAccountReference;
        }

        @Generated
        public void setDebtorAccountReferenceType(String debtorAccountReferenceType) {
            this.debtorAccountReferenceType = debtorAccountReferenceType;
        }

        @Generated
        public void setDebtorAccountReference(String debtorAccountReference) {
            this.debtorAccountReference = debtorAccountReference;
        }

        @Generated
        public void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @Generated
        public void setEndToEndId(String endToEndId) {
            this.endToEndId = endToEndId;
        }

        @Generated
        public void setSigningUri(String signingUri) {
            this.signingUri = signingUri;
        }

        @Generated
        public void setClosedAt(Instant closedAt) {
            this.closedAt = closedAt;
        }

        @Generated
        public void setSignedAt(Instant signedAt) {
            this.signedAt = signedAt;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentRequest)) {
                return false;
            }
            PaymentRequest other = (PaymentRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$remittanceInformationType = this.getRemittanceInformationType();
            String other$remittanceInformationType = other.getRemittanceInformationType();
            if (this$remittanceInformationType == null ? other$remittanceInformationType != null : !this$remittanceInformationType.equals(other$remittanceInformationType)) {
                return false;
            }
            String this$remittanceInformation = this.getRemittanceInformation();
            String other$remittanceInformation = other.getRemittanceInformation();
            if (this$remittanceInformation == null ? other$remittanceInformation != null : !this$remittanceInformation.equals(other$remittanceInformation)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            BigDecimal this$amount = this.getAmount();
            BigDecimal other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$creditorAccountReferenceType = this.getCreditorAccountReferenceType();
            String other$creditorAccountReferenceType = other.getCreditorAccountReferenceType();
            if (this$creditorAccountReferenceType == null ? other$creditorAccountReferenceType != null : !this$creditorAccountReferenceType.equals(other$creditorAccountReferenceType)) {
                return false;
            }
            String this$creditorAccountReference = this.getCreditorAccountReference();
            String other$creditorAccountReference = other.getCreditorAccountReference();
            if (this$creditorAccountReference == null ? other$creditorAccountReference != null : !this$creditorAccountReference.equals(other$creditorAccountReference)) {
                return false;
            }
            String this$debtorAccountReferenceType = this.getDebtorAccountReferenceType();
            String other$debtorAccountReferenceType = other.getDebtorAccountReferenceType();
            if (this$debtorAccountReferenceType == null ? other$debtorAccountReferenceType != null : !this$debtorAccountReferenceType.equals(other$debtorAccountReferenceType)) {
                return false;
            }
            String this$debtorAccountReference = this.getDebtorAccountReference();
            String other$debtorAccountReference = other.getDebtorAccountReference();
            if (this$debtorAccountReference == null ? other$debtorAccountReference != null : !this$debtorAccountReference.equals(other$debtorAccountReference)) {
                return false;
            }
            String this$redirectUri = this.getRedirectUri();
            String other$redirectUri = other.getRedirectUri();
            if (this$redirectUri == null ? other$redirectUri != null : !this$redirectUri.equals(other$redirectUri)) {
                return false;
            }
            String this$endToEndId = this.getEndToEndId();
            String other$endToEndId = other.getEndToEndId();
            if (this$endToEndId == null ? other$endToEndId != null : !this$endToEndId.equals(other$endToEndId)) {
                return false;
            }
            String this$signingUri = this.getSigningUri();
            String other$signingUri = other.getSigningUri();
            if (this$signingUri == null ? other$signingUri != null : !this$signingUri.equals(other$signingUri)) {
                return false;
            }
            Instant this$closedAt = this.getClosedAt();
            Instant other$closedAt = other.getClosedAt();
            if (this$closedAt == null ? other$closedAt != null : !((Object)this$closedAt).equals(other$closedAt)) {
                return false;
            }
            Instant this$signedAt = this.getSignedAt();
            Instant other$signedAt = other.getSignedAt();
            return !(this$signedAt == null ? other$signedAt != null : !((Object)this$signedAt).equals(other$signedAt));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $remittanceInformationType = this.getRemittanceInformationType();
            result = result * 59 + ($remittanceInformationType == null ? 43 : $remittanceInformationType.hashCode());
            String $remittanceInformation = this.getRemittanceInformation();
            result = result * 59 + ($remittanceInformation == null ? 43 : $remittanceInformation.hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            BigDecimal $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $creditorAccountReferenceType = this.getCreditorAccountReferenceType();
            result = result * 59 + ($creditorAccountReferenceType == null ? 43 : $creditorAccountReferenceType.hashCode());
            String $creditorAccountReference = this.getCreditorAccountReference();
            result = result * 59 + ($creditorAccountReference == null ? 43 : $creditorAccountReference.hashCode());
            String $debtorAccountReferenceType = this.getDebtorAccountReferenceType();
            result = result * 59 + ($debtorAccountReferenceType == null ? 43 : $debtorAccountReferenceType.hashCode());
            String $debtorAccountReference = this.getDebtorAccountReference();
            result = result * 59 + ($debtorAccountReference == null ? 43 : $debtorAccountReference.hashCode());
            String $redirectUri = this.getRedirectUri();
            result = result * 59 + ($redirectUri == null ? 43 : $redirectUri.hashCode());
            String $endToEndId = this.getEndToEndId();
            result = result * 59 + ($endToEndId == null ? 43 : $endToEndId.hashCode());
            String $signingUri = this.getSigningUri();
            result = result * 59 + ($signingUri == null ? 43 : $signingUri.hashCode());
            Instant $closedAt = this.getClosedAt();
            result = result * 59 + ($closedAt == null ? 43 : ((Object)$closedAt).hashCode());
            Instant $signedAt = this.getSignedAt();
            result = result * 59 + ($signedAt == null ? 43 : ((Object)$signedAt).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PaymentRequestServiceImpl.PaymentRequest(remittanceInformationType=" + this.getRemittanceInformationType() + ", remittanceInformation=" + this.getRemittanceInformation() + ", currency=" + this.getCurrency() + ", amount=" + this.getAmount() + ", creditorAccountReferenceType=" + this.getCreditorAccountReferenceType() + ", creditorAccountReference=" + this.getCreditorAccountReference() + ", debtorAccountReferenceType=" + this.getDebtorAccountReferenceType() + ", debtorAccountReference=" + this.getDebtorAccountReference() + ", redirectUri=" + this.getRedirectUri() + ", endToEndId=" + this.getEndToEndId() + ", signingUri=" + this.getSigningUri() + ", closedAt=" + this.getClosedAt() + ", signedAt=" + this.getSignedAt() + ")";
        }

        @Generated
        public PaymentRequest() {
        }

        @Generated
        private PaymentRequest(String remittanceInformationType, String remittanceInformation, String currency, BigDecimal amount, String creditorAccountReferenceType, String creditorAccountReference, String debtorAccountReferenceType, String debtorAccountReference, String redirectUri, String endToEndId, String signingUri, Instant closedAt, Instant signedAt) {
            this.remittanceInformationType = remittanceInformationType;
            this.remittanceInformation = remittanceInformation;
            this.currency = currency;
            this.amount = amount;
            this.creditorAccountReferenceType = creditorAccountReferenceType;
            this.creditorAccountReference = creditorAccountReference;
            this.debtorAccountReferenceType = debtorAccountReferenceType;
            this.debtorAccountReference = debtorAccountReference;
            this.redirectUri = redirectUri;
            this.endToEndId = endToEndId;
            this.signingUri = signingUri;
            this.closedAt = closedAt;
            this.signedAt = signedAt;
        }

        @Generated
        public static class PaymentRequestBuilder {
            @Generated
            private String remittanceInformationType;
            @Generated
            private String remittanceInformation;
            @Generated
            private String currency;
            @Generated
            private BigDecimal amount;
            @Generated
            private String creditorAccountReferenceType;
            @Generated
            private String creditorAccountReference;
            @Generated
            private String debtorAccountReferenceType;
            @Generated
            private String debtorAccountReference;
            @Generated
            private String redirectUri;
            @Generated
            private String endToEndId;
            @Generated
            private String signingUri;
            @Generated
            private Instant closedAt;
            @Generated
            private Instant signedAt;

            @Generated
            PaymentRequestBuilder() {
            }

            @Generated
            public PaymentRequestBuilder remittanceInformationType(String remittanceInformationType) {
                this.remittanceInformationType = remittanceInformationType;
                return this;
            }

            @Generated
            public PaymentRequestBuilder remittanceInformation(String remittanceInformation) {
                this.remittanceInformation = remittanceInformation;
                return this;
            }

            @Generated
            public PaymentRequestBuilder currency(String currency) {
                this.currency = currency;
                return this;
            }

            @Generated
            public PaymentRequestBuilder amount(BigDecimal amount) {
                this.amount = amount;
                return this;
            }

            @Generated
            public PaymentRequestBuilder creditorAccountReferenceType(String creditorAccountReferenceType) {
                this.creditorAccountReferenceType = creditorAccountReferenceType;
                return this;
            }

            @Generated
            public PaymentRequestBuilder creditorAccountReference(String creditorAccountReference) {
                this.creditorAccountReference = creditorAccountReference;
                return this;
            }

            @Generated
            public PaymentRequestBuilder debtorAccountReferenceType(String debtorAccountReferenceType) {
                this.debtorAccountReferenceType = debtorAccountReferenceType;
                return this;
            }

            @Generated
            public PaymentRequestBuilder debtorAccountReference(String debtorAccountReference) {
                this.debtorAccountReference = debtorAccountReference;
                return this;
            }

            @Generated
            public PaymentRequestBuilder redirectUri(String redirectUri) {
                this.redirectUri = redirectUri;
                return this;
            }

            @Generated
            public PaymentRequestBuilder endToEndId(String endToEndId) {
                this.endToEndId = endToEndId;
                return this;
            }

            @Generated
            public PaymentRequestBuilder signingUri(String signingUri) {
                this.signingUri = signingUri;
                return this;
            }

            @Generated
            public PaymentRequestBuilder closedAt(Instant closedAt) {
                this.closedAt = closedAt;
                return this;
            }

            @Generated
            public PaymentRequestBuilder signedAt(Instant signedAt) {
                this.signedAt = signedAt;
                return this;
            }

            @Generated
            public PaymentRequest build() {
                return new PaymentRequest(this.remittanceInformationType, this.remittanceInformation, this.currency, this.amount, this.creditorAccountReferenceType, this.creditorAccountReference, this.debtorAccountReferenceType, this.debtorAccountReference, this.redirectUri, this.endToEndId, this.signingUri, this.closedAt, this.signedAt);
            }

            @Generated
            public String toString() {
                return "PaymentRequestServiceImpl.PaymentRequest.PaymentRequestBuilder(remittanceInformationType=" + this.remittanceInformationType + ", remittanceInformation=" + this.remittanceInformation + ", currency=" + this.currency + ", amount=" + this.amount + ", creditorAccountReferenceType=" + this.creditorAccountReferenceType + ", creditorAccountReference=" + this.creditorAccountReference + ", debtorAccountReferenceType=" + this.debtorAccountReferenceType + ", debtorAccountReference=" + this.debtorAccountReference + ", redirectUri=" + this.redirectUri + ", endToEndId=" + this.endToEndId + ", signingUri=" + this.signingUri + ", closedAt=" + this.closedAt + ", signedAt=" + this.signedAt + ")";
            }
        }
    }
}

