/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.ponto_connect.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.RequestApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.ponto_connect.models.create.PaymentCreateQuery;
import com.ibanity.apis.client.products.ponto_connect.models.delete.PaymentDeleteQuery;
import com.ibanity.apis.client.products.ponto_connect.models.read.PaymentReadQuery;
import com.ibanity.apis.client.products.ponto_connect.services.PaymentService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.math.BigDecimal;
import java.net.URI;
import java.time.LocalDate;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class PaymentServiceImpl
implements PaymentService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public PaymentServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public com.ibanity.apis.client.products.ponto_connect.models.Payment find(PaymentReadQuery paymentReadQuery) {
        URI uri = URIHelper.buildUri(this.getUrl(paymentReadQuery.getAccountId()) + "/" + paymentReadQuery.getPaymentId().toString());
        HttpResponse response = this.ibanityHttpClient.get(uri, paymentReadQuery.getAdditionalHeaders(), paymentReadQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, com.ibanity.apis.client.products.ponto_connect.models.Payment.class);
    }

    @Override
    public com.ibanity.apis.client.products.ponto_connect.models.Payment create(PaymentCreateQuery paymentCreateQuery) {
        URI uri = URIHelper.buildUri(this.getUrl(paymentCreateQuery.getAccountId()));
        Payment payment = this.toRequest(paymentCreateQuery);
        RequestApiModel requestApiModel = ModelMapperHelper.buildRequest("payment", payment);
        HttpResponse response = this.ibanityHttpClient.post(uri, requestApiModel, paymentCreateQuery.getAdditionalHeaders(), paymentCreateQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, this.customMapping());
    }

    private Function<DataApiModel, com.ibanity.apis.client.products.ponto_connect.models.Payment> customMapping() {
        return dataApiModel -> {
            com.ibanity.apis.client.products.ponto_connect.models.Payment payment = IbanityModelMapper.toIbanityModel(dataApiModel, com.ibanity.apis.client.products.ponto_connect.models.Payment.class);
            if (dataApiModel.getLinks() != null) {
                payment.setRedirectLink(dataApiModel.getLinks().getRedirect());
            }
            return payment;
        };
    }

    @Override
    public com.ibanity.apis.client.products.ponto_connect.models.Payment delete(PaymentDeleteQuery paymentDeleteQuery) {
        URI uri = URIHelper.buildUri(this.getUrl(paymentDeleteQuery.getAccountId()) + "/" + paymentDeleteQuery.getPaymentId().toString());
        HttpResponse response = this.ibanityHttpClient.delete(uri, paymentDeleteQuery.getAdditionalHeaders(), paymentDeleteQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, com.ibanity.apis.client.products.ponto_connect.models.Payment.class);
    }

    private String getUrl(UUID accountId) {
        return StringUtils.removeEnd((String)this.apiUrlProvider.find(IbanityProduct.PontoConnect, "account", "payments").replace("{accountId}", accountId.toString()).replace("{paymentId}", ""), (String)"/");
    }

    private Payment toRequest(PaymentCreateQuery paymentCreateQuery) {
        return Payment.builder().amount(paymentCreateQuery.getAmount()).creditorAccountReference(paymentCreateQuery.getCreditorAccountReference()).creditorAccountReferenceType(paymentCreateQuery.getCreditorAccountReferenceType()).creditorAgent(paymentCreateQuery.getCreditorAgent()).creditorAgentType(paymentCreateQuery.getCreditorAgentType()).creditorName(paymentCreateQuery.getCreditorName()).currency(paymentCreateQuery.getCurrency()).remittanceInformation(paymentCreateQuery.getRemittanceInformation()).remittanceInformationType(paymentCreateQuery.getRemittanceInformationType()).requestedExecutionDate(paymentCreateQuery.getRequestedExecutionDate()).redirectUri(paymentCreateQuery.getRedirectUri()).endToEndId(paymentCreateQuery.getEndToEndId()).build();
    }

    private static class Payment {
        private LocalDate requestedExecutionDate;
        private String remittanceInformationType;
        private String remittanceInformation;
        private String currency;
        private BigDecimal amount;
        private String creditorName;
        private String creditorAgentType;
        private String creditorAgent;
        private String creditorAccountReferenceType;
        private String creditorAccountReference;
        private String redirectUri;
        private String endToEndId;

        @Generated
        public static PaymentBuilder builder() {
            return new PaymentBuilder();
        }

        @Generated
        public LocalDate getRequestedExecutionDate() {
            return this.requestedExecutionDate;
        }

        @Generated
        public String getRemittanceInformationType() {
            return this.remittanceInformationType;
        }

        @Generated
        public String getRemittanceInformation() {
            return this.remittanceInformation;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public BigDecimal getAmount() {
            return this.amount;
        }

        @Generated
        public String getCreditorName() {
            return this.creditorName;
        }

        @Generated
        public String getCreditorAgentType() {
            return this.creditorAgentType;
        }

        @Generated
        public String getCreditorAgent() {
            return this.creditorAgent;
        }

        @Generated
        public String getCreditorAccountReferenceType() {
            return this.creditorAccountReferenceType;
        }

        @Generated
        public String getCreditorAccountReference() {
            return this.creditorAccountReference;
        }

        @Generated
        public String getRedirectUri() {
            return this.redirectUri;
        }

        @Generated
        public String getEndToEndId() {
            return this.endToEndId;
        }

        @Generated
        public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
            this.requestedExecutionDate = requestedExecutionDate;
        }

        @Generated
        public void setRemittanceInformationType(String remittanceInformationType) {
            this.remittanceInformationType = remittanceInformationType;
        }

        @Generated
        public void setRemittanceInformation(String remittanceInformation) {
            this.remittanceInformation = remittanceInformation;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        @Generated
        public void setCreditorName(String creditorName) {
            this.creditorName = creditorName;
        }

        @Generated
        public void setCreditorAgentType(String creditorAgentType) {
            this.creditorAgentType = creditorAgentType;
        }

        @Generated
        public void setCreditorAgent(String creditorAgent) {
            this.creditorAgent = creditorAgent;
        }

        @Generated
        public void setCreditorAccountReferenceType(String creditorAccountReferenceType) {
            this.creditorAccountReferenceType = creditorAccountReferenceType;
        }

        @Generated
        public void setCreditorAccountReference(String creditorAccountReference) {
            this.creditorAccountReference = creditorAccountReference;
        }

        @Generated
        public void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @Generated
        public void setEndToEndId(String endToEndId) {
            this.endToEndId = endToEndId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Payment)) {
                return false;
            }
            Payment other = (Payment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LocalDate this$requestedExecutionDate = this.getRequestedExecutionDate();
            LocalDate other$requestedExecutionDate = other.getRequestedExecutionDate();
            if (this$requestedExecutionDate == null ? other$requestedExecutionDate != null : !((Object)this$requestedExecutionDate).equals(other$requestedExecutionDate)) {
                return false;
            }
            String this$remittanceInformationType = this.getRemittanceInformationType();
            String other$remittanceInformationType = other.getRemittanceInformationType();
            if (this$remittanceInformationType == null ? other$remittanceInformationType != null : !this$remittanceInformationType.equals(other$remittanceInformationType)) {
                return false;
            }
            String this$remittanceInformation = this.getRemittanceInformation();
            String other$remittanceInformation = other.getRemittanceInformation();
            if (this$remittanceInformation == null ? other$remittanceInformation != null : !this$remittanceInformation.equals(other$remittanceInformation)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            BigDecimal this$amount = this.getAmount();
            BigDecimal other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$creditorName = this.getCreditorName();
            String other$creditorName = other.getCreditorName();
            if (this$creditorName == null ? other$creditorName != null : !this$creditorName.equals(other$creditorName)) {
                return false;
            }
            String this$creditorAgentType = this.getCreditorAgentType();
            String other$creditorAgentType = other.getCreditorAgentType();
            if (this$creditorAgentType == null ? other$creditorAgentType != null : !this$creditorAgentType.equals(other$creditorAgentType)) {
                return false;
            }
            String this$creditorAgent = this.getCreditorAgent();
            String other$creditorAgent = other.getCreditorAgent();
            if (this$creditorAgent == null ? other$creditorAgent != null : !this$creditorAgent.equals(other$creditorAgent)) {
                return false;
            }
            String this$creditorAccountReferenceType = this.getCreditorAccountReferenceType();
            String other$creditorAccountReferenceType = other.getCreditorAccountReferenceType();
            if (this$creditorAccountReferenceType == null ? other$creditorAccountReferenceType != null : !this$creditorAccountReferenceType.equals(other$creditorAccountReferenceType)) {
                return false;
            }
            String this$creditorAccountReference = this.getCreditorAccountReference();
            String other$creditorAccountReference = other.getCreditorAccountReference();
            if (this$creditorAccountReference == null ? other$creditorAccountReference != null : !this$creditorAccountReference.equals(other$creditorAccountReference)) {
                return false;
            }
            String this$redirectUri = this.getRedirectUri();
            String other$redirectUri = other.getRedirectUri();
            if (this$redirectUri == null ? other$redirectUri != null : !this$redirectUri.equals(other$redirectUri)) {
                return false;
            }
            String this$endToEndId = this.getEndToEndId();
            String other$endToEndId = other.getEndToEndId();
            return !(this$endToEndId == null ? other$endToEndId != null : !this$endToEndId.equals(other$endToEndId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Payment;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LocalDate $requestedExecutionDate = this.getRequestedExecutionDate();
            result = result * 59 + ($requestedExecutionDate == null ? 43 : ((Object)$requestedExecutionDate).hashCode());
            String $remittanceInformationType = this.getRemittanceInformationType();
            result = result * 59 + ($remittanceInformationType == null ? 43 : $remittanceInformationType.hashCode());
            String $remittanceInformation = this.getRemittanceInformation();
            result = result * 59 + ($remittanceInformation == null ? 43 : $remittanceInformation.hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            BigDecimal $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $creditorName = this.getCreditorName();
            result = result * 59 + ($creditorName == null ? 43 : $creditorName.hashCode());
            String $creditorAgentType = this.getCreditorAgentType();
            result = result * 59 + ($creditorAgentType == null ? 43 : $creditorAgentType.hashCode());
            String $creditorAgent = this.getCreditorAgent();
            result = result * 59 + ($creditorAgent == null ? 43 : $creditorAgent.hashCode());
            String $creditorAccountReferenceType = this.getCreditorAccountReferenceType();
            result = result * 59 + ($creditorAccountReferenceType == null ? 43 : $creditorAccountReferenceType.hashCode());
            String $creditorAccountReference = this.getCreditorAccountReference();
            result = result * 59 + ($creditorAccountReference == null ? 43 : $creditorAccountReference.hashCode());
            String $redirectUri = this.getRedirectUri();
            result = result * 59 + ($redirectUri == null ? 43 : $redirectUri.hashCode());
            String $endToEndId = this.getEndToEndId();
            result = result * 59 + ($endToEndId == null ? 43 : $endToEndId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PaymentServiceImpl.Payment(requestedExecutionDate=" + this.getRequestedExecutionDate() + ", remittanceInformationType=" + this.getRemittanceInformationType() + ", remittanceInformation=" + this.getRemittanceInformation() + ", currency=" + this.getCurrency() + ", amount=" + this.getAmount() + ", creditorName=" + this.getCreditorName() + ", creditorAgentType=" + this.getCreditorAgentType() + ", creditorAgent=" + this.getCreditorAgent() + ", creditorAccountReferenceType=" + this.getCreditorAccountReferenceType() + ", creditorAccountReference=" + this.getCreditorAccountReference() + ", redirectUri=" + this.getRedirectUri() + ", endToEndId=" + this.getEndToEndId() + ")";
        }

        @Generated
        public Payment() {
        }

        @Generated
        private Payment(LocalDate requestedExecutionDate, String remittanceInformationType, String remittanceInformation, String currency, BigDecimal amount, String creditorName, String creditorAgentType, String creditorAgent, String creditorAccountReferenceType, String creditorAccountReference, String redirectUri, String endToEndId) {
            this.requestedExecutionDate = requestedExecutionDate;
            this.remittanceInformationType = remittanceInformationType;
            this.remittanceInformation = remittanceInformation;
            this.currency = currency;
            this.amount = amount;
            this.creditorName = creditorName;
            this.creditorAgentType = creditorAgentType;
            this.creditorAgent = creditorAgent;
            this.creditorAccountReferenceType = creditorAccountReferenceType;
            this.creditorAccountReference = creditorAccountReference;
            this.redirectUri = redirectUri;
            this.endToEndId = endToEndId;
        }

        @Generated
        public static class PaymentBuilder {
            @Generated
            private LocalDate requestedExecutionDate;
            @Generated
            private String remittanceInformationType;
            @Generated
            private String remittanceInformation;
            @Generated
            private String currency;
            @Generated
            private BigDecimal amount;
            @Generated
            private String creditorName;
            @Generated
            private String creditorAgentType;
            @Generated
            private String creditorAgent;
            @Generated
            private String creditorAccountReferenceType;
            @Generated
            private String creditorAccountReference;
            @Generated
            private String redirectUri;
            @Generated
            private String endToEndId;

            @Generated
            PaymentBuilder() {
            }

            @Generated
            public PaymentBuilder requestedExecutionDate(LocalDate requestedExecutionDate) {
                this.requestedExecutionDate = requestedExecutionDate;
                return this;
            }

            @Generated
            public PaymentBuilder remittanceInformationType(String remittanceInformationType) {
                this.remittanceInformationType = remittanceInformationType;
                return this;
            }

            @Generated
            public PaymentBuilder remittanceInformation(String remittanceInformation) {
                this.remittanceInformation = remittanceInformation;
                return this;
            }

            @Generated
            public PaymentBuilder currency(String currency) {
                this.currency = currency;
                return this;
            }

            @Generated
            public PaymentBuilder amount(BigDecimal amount) {
                this.amount = amount;
                return this;
            }

            @Generated
            public PaymentBuilder creditorName(String creditorName) {
                this.creditorName = creditorName;
                return this;
            }

            @Generated
            public PaymentBuilder creditorAgentType(String creditorAgentType) {
                this.creditorAgentType = creditorAgentType;
                return this;
            }

            @Generated
            public PaymentBuilder creditorAgent(String creditorAgent) {
                this.creditorAgent = creditorAgent;
                return this;
            }

            @Generated
            public PaymentBuilder creditorAccountReferenceType(String creditorAccountReferenceType) {
                this.creditorAccountReferenceType = creditorAccountReferenceType;
                return this;
            }

            @Generated
            public PaymentBuilder creditorAccountReference(String creditorAccountReference) {
                this.creditorAccountReference = creditorAccountReference;
                return this;
            }

            @Generated
            public PaymentBuilder redirectUri(String redirectUri) {
                this.redirectUri = redirectUri;
                return this;
            }

            @Generated
            public PaymentBuilder endToEndId(String endToEndId) {
                this.endToEndId = endToEndId;
                return this;
            }

            @Generated
            public Payment build() {
                return new Payment(this.requestedExecutionDate, this.remittanceInformationType, this.remittanceInformation, this.currency, this.amount, this.creditorName, this.creditorAgentType, this.creditorAgent, this.creditorAccountReferenceType, this.creditorAccountReference, this.redirectUri, this.endToEndId);
            }

            @Generated
            public String toString() {
                return "PaymentServiceImpl.Payment.PaymentBuilder(requestedExecutionDate=" + this.requestedExecutionDate + ", remittanceInformationType=" + this.remittanceInformationType + ", remittanceInformation=" + this.remittanceInformation + ", currency=" + this.currency + ", amount=" + this.amount + ", creditorName=" + this.creditorName + ", creditorAgentType=" + this.creditorAgentType + ", creditorAgent=" + this.creditorAgent + ", creditorAccountReferenceType=" + this.creditorAccountReferenceType + ", creditorAccountReference=" + this.creditorAccountReference + ", redirectUri=" + this.redirectUri + ", endToEndId=" + this.endToEndId + ")";
            }
        }
    }
}

