/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.ponto_connect.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.models.IbanityCollection;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.paging.IbanityPagingSpec;
import com.ibanity.apis.client.products.ponto_connect.models.PendingTransaction;
import com.ibanity.apis.client.products.ponto_connect.models.read.PendingTransactionReadQuery;
import com.ibanity.apis.client.products.ponto_connect.models.read.PendingTransactionsReadQuery;
import com.ibanity.apis.client.products.ponto_connect.services.PendingTransactionService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.net.URI;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class PendingTransactionServiceImpl
implements PendingTransactionService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public PendingTransactionServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public PendingTransaction find(PendingTransactionReadQuery pendingTransactionReadQuery) {
        URI uri = URIHelper.buildUri(this.getUrl(pendingTransactionReadQuery.getAccountId()) + "/" + pendingTransactionReadQuery.getPendingTransactionId());
        HttpResponse response = this.ibanityHttpClient.get(uri, pendingTransactionReadQuery.getAdditionalHeaders(), pendingTransactionReadQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, PendingTransaction.class);
    }

    @Override
    public IbanityCollection<PendingTransaction> list(PendingTransactionsReadQuery pendingTransactionsReadQuery) {
        IbanityPagingSpec pagingSpec = pendingTransactionsReadQuery.getPagingSpec();
        if (pagingSpec == null) {
            pagingSpec = IbanityPagingSpec.DEFAULT_PAGING_SPEC;
        }
        URI uri = URIHelper.buildUri(this.getUrl(pendingTransactionsReadQuery.getAccountId()), pagingSpec);
        HttpResponse response = this.ibanityHttpClient.get(uri, pendingTransactionsReadQuery.getAdditionalHeaders(), pendingTransactionsReadQuery.getAccessToken());
        return IbanityModelMapper.mapCollection(response, PendingTransaction.class);
    }

    @Override
    public IbanityCollection<PendingTransaction> listUpdatedForSynchronization(PendingTransactionsReadQuery pendingTransactionsReadQuery) {
        IbanityPagingSpec pagingSpec = pendingTransactionsReadQuery.getPagingSpec();
        if (pagingSpec == null) {
            pagingSpec = IbanityPagingSpec.DEFAULT_PAGING_SPEC;
        }
        URI uri = URIHelper.buildUri(this.getUrlForSynchronizationId(pendingTransactionsReadQuery.getSynchronizationId()), pagingSpec);
        HttpResponse response = this.ibanityHttpClient.get(uri, pendingTransactionsReadQuery.getAdditionalHeaders(), pendingTransactionsReadQuery.getAccessToken());
        return IbanityModelMapper.mapCollection(response, PendingTransaction.class);
    }

    private String getUrl(UUID accountId) {
        String url = this.apiUrlProvider.find(IbanityProduct.PontoConnect, "account", "pendingTransactions").replace("{accountId}", accountId.toString()).replace("{pendingTransactionId}", "");
        return StringUtils.removeEnd((String)url, (String)"/");
    }

    private String getUrlForSynchronizationId(UUID synchronizationId) {
        String url = this.apiUrlProvider.find(IbanityProduct.PontoConnect, "synchronization", "updatedPendingTransactions").replace("{synchronizationId}", synchronizationId.toString());
        return StringUtils.removeEnd((String)url, (String)"/");
    }
}

