/*
 * Decompiled with CFR 0.152.
 */
package com.ibanity.apis.client.products.ponto_connect.services.impl;

import com.ibanity.apis.client.http.IbanityHttpClient;
import com.ibanity.apis.client.jsonapi.DataApiModel;
import com.ibanity.apis.client.jsonapi.RequestApiModel;
import com.ibanity.apis.client.mappers.IbanityModelMapper;
import com.ibanity.apis.client.mappers.ModelMapperHelper;
import com.ibanity.apis.client.models.IbanityProduct;
import com.ibanity.apis.client.products.ponto_connect.models.create.ReauthorizationRequestCreateQuery;
import com.ibanity.apis.client.products.ponto_connect.services.ReauthorizationRequestService;
import com.ibanity.apis.client.services.ApiUrlProvider;
import com.ibanity.apis.client.utils.URIHelper;
import java.net.URI;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class ReauthorizationRequestServiceImpl
implements ReauthorizationRequestService {
    private final ApiUrlProvider apiUrlProvider;
    private final IbanityHttpClient ibanityHttpClient;

    public ReauthorizationRequestServiceImpl(ApiUrlProvider apiUrlProvider, IbanityHttpClient ibanityHttpClient) {
        this.apiUrlProvider = apiUrlProvider;
        this.ibanityHttpClient = ibanityHttpClient;
    }

    @Override
    public com.ibanity.apis.client.products.ponto_connect.models.ReauthorizationRequest create(ReauthorizationRequestCreateQuery reauthorizationRequestCreateQuery) {
        URI uri = URIHelper.buildUri(this.getUrl(reauthorizationRequestCreateQuery.getAccountId()));
        ReauthorizationRequest reauthorizationRequest = this.toRequest(reauthorizationRequestCreateQuery);
        RequestApiModel requestApiModel = ModelMapperHelper.buildRequest("reauthorizationRequest", reauthorizationRequest);
        HttpResponse response = this.ibanityHttpClient.post(uri, requestApiModel, reauthorizationRequestCreateQuery.getAdditionalHeaders(), reauthorizationRequestCreateQuery.getAccessToken());
        return IbanityModelMapper.mapResource(response, this.customMapping());
    }

    private Function<DataApiModel, com.ibanity.apis.client.products.ponto_connect.models.ReauthorizationRequest> customMapping() {
        return dataApiModel -> {
            com.ibanity.apis.client.products.ponto_connect.models.ReauthorizationRequest reauthorizationRequest = IbanityModelMapper.toIbanityModel(dataApiModel, com.ibanity.apis.client.products.ponto_connect.models.ReauthorizationRequest.class);
            reauthorizationRequest.setRedirectLink(dataApiModel.getLinks().getRedirect());
            return reauthorizationRequest;
        };
    }

    private String getUrl(UUID accountId) {
        return StringUtils.removeEnd((String)this.apiUrlProvider.find(IbanityProduct.PontoConnect, "account", "reauthorizationRequests").replace("{accountId}", accountId.toString()).replace("{reauthorizationRequestId}", ""), (String)"/");
    }

    private ReauthorizationRequest toRequest(ReauthorizationRequestCreateQuery reauthorizationRequestCreateQuery) {
        return ReauthorizationRequest.builder().redirectUri(reauthorizationRequestCreateQuery.getRedirectUri()).build();
    }

    private static class ReauthorizationRequest {
        private String redirectUri;

        @Generated
        public static ReauthorizationRequestBuilder builder() {
            return new ReauthorizationRequestBuilder();
        }

        @Generated
        public String getRedirectUri() {
            return this.redirectUri;
        }

        @Generated
        public void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReauthorizationRequest)) {
                return false;
            }
            ReauthorizationRequest other = (ReauthorizationRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$redirectUri = this.getRedirectUri();
            String other$redirectUri = other.getRedirectUri();
            return !(this$redirectUri == null ? other$redirectUri != null : !this$redirectUri.equals(other$redirectUri));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReauthorizationRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $redirectUri = this.getRedirectUri();
            result = result * 59 + ($redirectUri == null ? 43 : $redirectUri.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ReauthorizationRequestServiceImpl.ReauthorizationRequest(redirectUri=" + this.getRedirectUri() + ")";
        }

        @Generated
        public ReauthorizationRequest() {
        }

        @Generated
        private ReauthorizationRequest(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @Generated
        public static class ReauthorizationRequestBuilder {
            @Generated
            private String redirectUri;

            @Generated
            ReauthorizationRequestBuilder() {
            }

            @Generated
            public ReauthorizationRequestBuilder redirectUri(String redirectUri) {
                this.redirectUri = redirectUri;
                return this;
            }

            @Generated
            public ReauthorizationRequest build() {
                return new ReauthorizationRequest(this.redirectUri);
            }

            @Generated
            public String toString() {
                return "ReauthorizationRequestServiceImpl.ReauthorizationRequest.ReauthorizationRequestBuilder(redirectUri=" + this.redirectUri + ")";
            }
        }
    }
}

